/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.block.custom.letterbutton;

import java.util.List;
import java.util.Objects;
import net.larsmans.infinitybuttons.InfinityButtonsUtil;
import net.larsmans.infinitybuttons.block.custom.button.AbstractLeverableButton;
import net.larsmans.infinitybuttons.block.custom.button.LargeButtonShape;
import net.larsmans.infinitybuttons.block.custom.letterbutton.LetterButtonEnum;
import net.larsmans.infinitybuttons.network.IBPacketHandler;
import net.larsmans.infinitybuttons.network.packets.LetterButtonScreenPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LetterButton
extends AbstractLeverableButton {
    public static final EnumProperty<LetterButtonEnum> CHARACTER = EnumProperty.m_61587_((String)"character", LetterButtonEnum.class);

    public LetterButton(BlockBehaviour.Properties properties, boolean lever) {
        super(lever, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)PRESSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_53179_, (Comparable)AttachFace.FLOOR)).m_61124_(CHARACTER, (Comparable)((Object)LetterButtonEnum.NONE)));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        GameType gameMode = GameType.f_151492_;
        if (worldIn.f_46443_) {
            ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
            assert (connection != null);
            gameMode = Objects.requireNonNull(connection.m_104949_(player.m_36316_().getId())).m_105325_();
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            gameMode = serverPlayer.f_8941_.m_9290_();
        }
        if (gameMode == GameType.SPECTATOR) {
            return InteractionResult.FAIL;
        }
        if (player.m_6144_() && gameMode != GameType.ADVENTURE) {
            this.openScreen(pos, (LivingEntity)player);
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public void m_6402_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        this.openScreen(pPos, pPlacer);
    }

    public void openScreen(BlockPos pos, LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            IBPacketHandler.sendToPlayer(new LetterButtonScreenPacket(pos), player);
        }
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return LargeButtonShape.outlineShape(pState);
    }

    @Override
    public int getPressDuration() {
        return 30;
    }

    @Override
    protected SoundEvent getSoundEvent(boolean pressed) {
        return SoundEvents.f_12444_;
    }

    public int getEnumId(BlockState state) {
        return ((LetterButtonEnum)((Object)state.m_61143_(CHARACTER))).ordinal();
    }

    public void setState(BlockState state, Level worldIn, BlockPos pos, LetterButtonEnum buttonEnum) {
        worldIn.m_7731_(pos, (BlockState)state.m_61124_(CHARACTER, (Comparable)((Object)buttonEnum)), 3);
        this.updateNeighbors(state, worldIn, pos);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CHARACTER});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(@NotNull ItemStack pStack, @Nullable BlockGetter pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        InfinityButtonsUtil.tooltip(pTooltip, "letter_button");
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }
}

