/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.block.custom.emergencybutton;

import java.util.ArrayList;
import java.util.List;
import net.larsmans.infinitybuttons.advancement.InfinityButtonsTriggers;
import net.larsmans.infinitybuttons.block.custom.button.AbstractButton;
import net.larsmans.infinitybuttons.config.AlarmEnum;
import net.larsmans.infinitybuttons.network.IBPacketHandler;
import net.larsmans.infinitybuttons.network.packets.AlarmPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EmergencyButton
extends AbstractButton {
    private static final VoxelShape STONE_DOWN = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0);
    private static final VoxelShape STONE_UP = Block.m_49796_((double)4.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape STONE_NORTH = Block.m_49796_((double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0, (double)16.0);
    private static final VoxelShape STONE_EAST = Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0);
    private static final VoxelShape STONE_SOUTH = Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)1.0);
    private static final VoxelShape STONE_WEST = Block.m_49796_((double)15.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final VoxelShape FLOOR_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), (VoxelShape)STONE_DOWN).m_83296_();
    private static final VoxelShape FLOOR_PRESSED_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0), (VoxelShape)STONE_DOWN).m_83296_();
    private static final VoxelShape NORTH_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)15.0), (VoxelShape)STONE_NORTH).m_83296_();
    private static final VoxelShape NORTH_PRESSED_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)5.0, (double)13.0, (double)11.0, (double)11.0, (double)15.0), (VoxelShape)STONE_NORTH).m_83296_();
    private static final VoxelShape EAST_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0), (VoxelShape)STONE_EAST).m_83296_();
    private static final VoxelShape EAST_PRESSED_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)5.0, (double)5.0, (double)3.0, (double)11.0, (double)11.0), (VoxelShape)STONE_EAST).m_83296_();
    private static final VoxelShape SOUTH_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)11.0, (double)5.0), (VoxelShape)STONE_SOUTH).m_83296_();
    private static final VoxelShape SOUTH_PRESSED_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)11.0, (double)3.0), (VoxelShape)STONE_SOUTH).m_83296_();
    private static final VoxelShape WEST_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)11.0, (double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0), (VoxelShape)STONE_WEST).m_83296_();
    private static final VoxelShape WEST_PRESSED_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)13.0, (double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0), (VoxelShape)STONE_WEST).m_83296_();
    private static final VoxelShape CEILING_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0), (VoxelShape)STONE_UP).m_83296_();
    private static final VoxelShape CEILING_PRESSED_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0), (VoxelShape)STONE_UP).m_83296_();

    public EmergencyButton(BlockBehaviour.Properties properties) {
        super(false, properties);
    }

    @Override
    public int getPressDuration() {
        return 10;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        boolean flag = (Boolean)state.m_61143_((Property)PRESSED);
        switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            case FLOOR: {
                return flag ? FLOOR_PRESSED_SHAPE : FLOOR_SHAPE;
            }
            case WALL: {
                switch (direction) {
                    case EAST: {
                        return flag ? EAST_PRESSED_SHAPE : EAST_SHAPE;
                    }
                    case WEST: {
                        return flag ? WEST_PRESSED_SHAPE : WEST_SHAPE;
                    }
                    case SOUTH: {
                        return flag ? SOUTH_PRESSED_SHAPE : SOUTH_SHAPE;
                    }
                }
                return flag ? NORTH_PRESSED_SHAPE : NORTH_SHAPE;
            }
        }
        return flag ? CEILING_PRESSED_SHAPE : CEILING_SHAPE;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)PRESSED)).booleanValue()) {
            return InteractionResult.CONSUME;
        }
        this.powerBlock(state, worldIn, pos);
        this.playSound(player, (LevelAccessor)worldIn, pos, true);
        EmergencyButton.emergencySound(worldIn, pos);
        if (player instanceof ServerPlayer) {
            InfinityButtonsTriggers.EMERGENCY_TRIGGER.trigger((ServerPlayer)player);
        }
        if (!worldIn.f_46443_ && EmergencyButton.config.alarmVillagerPanic) {
            List<LivingEntity> villagers = new ArrayList();
            if (EmergencyButton.config.alarmSoundType == AlarmEnum.GLOBAL) {
                villagers = new ArrayList();
                List villagersDup = worldIn.m_6443_(LivingEntity.class, new AABB(pos).m_82400_(512.0), entity -> entity.m_6095_() == EntityType.f_20492_);
                for (Player player1 : worldIn.m_6907_()) {
                    villagersDup.addAll(worldIn.m_6443_(LivingEntity.class, new AABB(player1.m_20097_()).m_82400_(512.0), entity -> entity.m_6095_() == EntityType.f_20492_));
                }
                for (LivingEntity villager : villagersDup) {
                    if (villagers.contains(villager)) continue;
                    villagers.add(villager);
                }
            }
            if (EmergencyButton.config.alarmSoundType == AlarmEnum.RANGE) {
                villagers = worldIn.m_6443_(LivingEntity.class, new AABB(pos).m_82400_((double)EmergencyButton.config.alarmSoundRange), entity -> entity.m_6095_() == EntityType.f_20492_);
            }
            for (LivingEntity villager : villagers) {
                if (!(villager instanceof Villager)) continue;
                Villager villagerEntity = (Villager)villager;
                villagerEntity.m_6274_().m_21879_(MemoryModuleType.f_26325_, (Object)worldIn.m_46467_());
            }
        }
        worldIn.m_142346_((Entity)player, GameEvent.f_223702_, pos);
        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
    }

    @Override
    protected void playSound(@Nullable Player playerIn, LevelAccessor worldIn, BlockPos pos, boolean pressed) {
        worldIn.m_5594_((Player)(pressed ? playerIn : null), pos, this.getSoundEvent(pressed), SoundSource.BLOCKS, 1.0f, pressed ? 0.6f : 0.5f);
    }

    @Override
    protected SoundEvent getSoundEvent(boolean pressed) {
        return SoundEvents.f_11708_;
    }

    public static void emergencySound(Level level, BlockPos pos) {
        if (!level.f_46443_) {
            IBPacketHandler.sendToAllPlayers(new AlarmPacket(pos, EmergencyButton.config.alarmSoundType));
        }
    }
}

