/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config.forge;

import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import top.theillusivec4.curios.api.CuriosApi;
import uk.co.dotcode.asb.ASB;
import uk.co.dotcode.asb.ModLogger;
import uk.co.dotcode.asb.ModUtils;
import uk.co.dotcode.asb.config.SetPiece;
import uk.co.dotcode.asb.config.forge.ArmorSetImpl;

public class AdditionalSetPieceImpl {
    public static boolean verifySpecific(String armorSetName, String slotType, SetPiece sp) {
        boolean valid = true;
        if (!ASB.isCuriosLoaded) {
            ModLogger.warn("Failed to add custom armorset: " + armorSetName + ". Curios slots have been declared, but the Curios mod is not installed.");
            valid = false;
        }
        if (!ModUtils.checkItemKey(sp.itemKey)) {
            ModLogger.warn("Failed to add custom armorset: " + armorSetName + ". The " + slotType + " slot is invalid!");
            valid = false;
        }
        if (sp.mixAndMatch != null && sp.mixAndMatch.length > 0) {
            for (String s : sp.mixAndMatch) {
                if (ModUtils.checkItemKey(s)) continue;
                ModLogger.warn("Failed to add custom armorset: " + armorSetName + ". " + slotType + " MixAndMatch is invalid: " + s);
                valid = false;
            }
        }
        return valid;
    }

    public static boolean additionalMatches(Player player, SetPiece sp) {
        return ArmorSetImpl.curioMatches((LivingEntity)player, sp);
    }

    public static boolean additionalMatchesSpecific(Player player, String itemKey) {
        Optional optional = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, ModUtils.getItem(itemKey));
        return optional.isPresent();
    }
}

