/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config;

import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import uk.co.dotcode.asb.ComponentManager;
import uk.co.dotcode.asb.ModLogger;
import uk.co.dotcode.asb.ModUtils;
import uk.co.dotcode.asb.config.AdditionalSetPiece;
import uk.co.dotcode.asb.config.EnchantmentCondition;
import uk.co.dotcode.asb.config.TagData;

public class SetPiece {
    public String itemKey;
    public String[] mixAndMatch;
    public boolean mustBeEmpty = false;
    public TagData tagData;
    public EnchantmentCondition[] enchantments;
    public transient Integer toolTipTickStage = 0;

    public SetPiece() {
    }

    public SetPiece(String itemKey) {
        this();
        this.itemKey = itemKey;
    }

    public boolean verify(String armorSetName, String slotType) {
        boolean valid = true;
        if (!this.mustBeEmpty) {
            if (this.itemKey == null || this.itemKey.isEmpty() || !ModUtils.checkItemKey(this.itemKey)) {
                ModLogger.warn("Failed to add custom armorset: " + armorSetName + ". The " + slotType + " slot is invalid!");
                valid = false;
            }
            if (this.mixAndMatch != null && this.mixAndMatch.length > 0) {
                for (String s : this.mixAndMatch) {
                    if (s != null && !s.isEmpty() && ModUtils.checkItemKey(s)) continue;
                    ModLogger.warn("Failed to add custom armorset: " + armorSetName + ". " + slotType + " MixAndMatch is invalid: " + (String)s);
                    valid = false;
                }
            }
            if (this.enchantments != null && this.enchantments.length > 0) {
                for (EnchantmentCondition e : this.enchantments) {
                    if (e.verify(armorSetName, slotType)) continue;
                    valid = false;
                }
            }
        }
        return valid;
    }

    public MutableComponent toolTipText(Player player, int armorSlot, boolean nextStage) {
        if (this.mustBeEmpty) {
            MutableComponent tooltip = ComponentManager.emptyError;
            boolean matchesRequirement = false;
            if (armorSlot == -1) {
                matchesRequirement = player.m_21205_().m_41619_();
                tooltip = ComponentManager.slotEmptyMainHand;
            } else if (armorSlot == -2) {
                matchesRequirement = player.m_21206_().m_41619_();
                tooltip = ComponentManager.slotEmptyOffhand;
            } else if (armorSlot == 0) {
                matchesRequirement = player.m_150109_().m_36052_(armorSlot).m_41619_();
                tooltip = ComponentManager.slotEmptyFeet;
            } else if (armorSlot == 1) {
                matchesRequirement = player.m_150109_().m_36052_(armorSlot).m_41619_();
                tooltip = ComponentManager.slotEmptyLegs;
            } else if (armorSlot == 2) {
                matchesRequirement = player.m_150109_().m_36052_(armorSlot).m_41619_();
                tooltip = ComponentManager.slotEmptyChest;
            } else if (armorSlot == 3) {
                matchesRequirement = player.m_150109_().m_36052_(armorSlot).m_41619_();
                tooltip = ComponentManager.slotEmptyHead;
            }
            if (matchesRequirement) {
                return ComponentManager.setGreen(tooltip);
            }
            return ComponentManager.setGray(tooltip);
        }
        ArrayList<Object> targets = new ArrayList<Object>();
        targets.add(this.itemKey);
        MutableComponent extraText = null;
        if (this.mixAndMatch != null && this.mixAndMatch.length > 0) {
            for (String s : this.mixAndMatch) {
                targets.add(s);
            }
        }
        if (nextStage) {
            String[] stringArray = this.toolTipTickStage;
            this.toolTipTickStage = this.toolTipTickStage + 1;
            if (this.toolTipTickStage >= targets.size()) {
                this.toolTipTickStage = 0;
            }
        }
        if (armorSlot == -1) {
            extraText = ComponentManager.mergeComponents(new Component[]{ComponentManager.space, ComponentManager.bracketOpen, ComponentManager.slotMainHand, ComponentManager.bracketClose});
            for (String string : targets) {
                if (!ModUtils.getRegistryNameItem(player.m_21205_().m_41720_()).toString().equals(string)) continue;
                ItemStack active = new ItemStack((ItemLike)ModUtils.getItem(string));
                return ComponentManager.setGreen(ComponentManager.mergeComponents(new Component[]{ComponentManager.dash, ComponentManager.createComponent(active.m_41778_(), true), extraText}));
            }
        } else if (armorSlot == -2) {
            extraText = ComponentManager.mergeComponents(new Component[]{ComponentManager.space, ComponentManager.bracketOpen, ComponentManager.slotOffhand, ComponentManager.bracketClose});
            for (String string : targets) {
                if (!ModUtils.getRegistryNameItem(player.m_21206_().m_41720_()).toString().equals(string)) continue;
                ItemStack active = new ItemStack((ItemLike)ModUtils.getItem(string));
                return ComponentManager.setGreen(ComponentManager.mergeComponents(new Component[]{ComponentManager.dash, ComponentManager.createComponent(active.m_41778_(), true), extraText}));
            }
        } else if (armorSlot == -3) {
            extraText = ComponentManager.mergeComponents(new Component[]{ComponentManager.space, ComponentManager.bracketOpen, ComponentManager.createComponent(AdditionalSetPiece.additionalType, false), ComponentManager.bracketClose});
            for (String string : targets) {
                if (!AdditionalSetPiece.additionalMatchesSpecific(player, string)) continue;
                ItemStack active = new ItemStack((ItemLike)ModUtils.getItem(string));
                return ComponentManager.setGreen(ComponentManager.mergeComponents(new Component[]{ComponentManager.dash, ComponentManager.createComponent(active.m_41778_(), true), extraText}));
            }
        } else {
            for (String string : targets) {
                if (!ModUtils.getRegistryNameItem(player.m_150109_().m_36052_(armorSlot).m_41720_()).toString().equalsIgnoreCase(string)) continue;
                ItemStack active = new ItemStack((ItemLike)ModUtils.getItem(string));
                return ComponentManager.setGreen(ComponentManager.mergeComponents(new Component[]{ComponentManager.dash, ComponentManager.createComponent(active.m_41778_(), true)}));
            }
        }
        String currentString = (String)targets.get(this.toolTipTickStage);
        ItemStack itemStack = new ItemStack((ItemLike)ModUtils.getItem(currentString));
        if (extraText != null) {
            return ComponentManager.setGray(ComponentManager.mergeComponents(new Component[]{ComponentManager.dash, ComponentManager.createComponent(itemStack.m_41778_(), true), extraText}));
        }
        return ComponentManager.setGray(ComponentManager.mergeComponents(new Component[]{ComponentManager.dash, ComponentManager.createComponent(itemStack.m_41778_(), true)}));
    }

    public ArrayList<MutableComponent> toolTipEnchantmentText(Player player, int armorSlot) {
        ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
        if (this.enchantments != null && this.enchantments.length > 0) {
            for (EnchantmentCondition c : this.enchantments) {
                tooltips.add(c.getEnchantmentTooltipText(armorSlot, player, this.itemKey));
            }
        }
        return tooltips;
    }

    public boolean matches(ItemStack stack, String itemRegName) {
        if (this.mustBeEmpty) {
            if (itemRegName.equalsIgnoreCase("minecraft:air")) {
                return true;
            }
        } else if (!stack.m_41619_() && this.enchantmentsMatch(stack) && (this.tagData == null || this.tagData.hasTag(stack))) {
            if (this.itemKey.equalsIgnoreCase(itemRegName)) {
                return true;
            }
            if (this.mixAndMatch != null && this.mixAndMatch.length > 0) {
                for (String s : this.mixAndMatch) {
                    if (!s.equalsIgnoreCase(itemRegName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean matchesSimple(String itemRegName) {
        if (this.mustBeEmpty) {
            if (itemRegName.equalsIgnoreCase("minecraft:air")) {
                return true;
            }
        } else {
            if (this.itemKey.equalsIgnoreCase(itemRegName)) {
                return true;
            }
            if (this.mixAndMatch != null && this.mixAndMatch.length > 0) {
                for (String s : this.mixAndMatch) {
                    if (!s.equalsIgnoreCase(itemRegName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean enchantmentsMatch(ItemStack stack) {
        boolean flag = true;
        if (this.enchantments != null && this.enchantments.length > 0) {
            for (EnchantmentCondition c : this.enchantments) {
                if (c.matches(stack)) continue;
                flag = false;
                break;
            }
        }
        return flag;
    }
}

