/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.helpers;

import java.util.HashSet;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeHelper {
    public static VoxelShape rotateY(VoxelShape shape, int rotation) {
        HashSet rotatedShapes = new HashSet();
        shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
            x1 = x1 * 16.0 - 8.0;
            x2 = x2 * 16.0 - 8.0;
            z1 = z1 * 16.0 - 8.0;
            z2 = z2 * 16.0 - 8.0;
            switch (rotation) {
                case 90: {
                    rotatedShapes.add(VoxelShapeHelper.boxSafe(8.0 - z1, y1 * 16.0, 8.0 + x1, 8.0 - z2, y2 * 16.0, 8.0 + x2));
                    break;
                }
                case 180: {
                    rotatedShapes.add(VoxelShapeHelper.boxSafe(8.0 - x1, y1 * 16.0, 8.0 - z1, 8.0 - x2, y2 * 16.0, 8.0 - z2));
                    break;
                }
                case 270: {
                    rotatedShapes.add(VoxelShapeHelper.boxSafe(8.0 + z1, y1 * 16.0, 8.0 - x1, 8.0 + z2, y2 * 16.0, 8.0 - x2));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid rotation " + rotation + " (must be 90,180 or 270)");
                }
            }
        });
        return rotatedShapes.stream().reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElse(shape);
    }

    public static VoxelShape rotateX(VoxelShape shape, int rotation) {
        HashSet rotatedShapes = new HashSet();
        shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
            y1 = y1 * 16.0 - 8.0;
            y2 = y2 * 16.0 - 8.0;
            z1 = z1 * 16.0 - 8.0;
            z2 = z2 * 16.0 - 8.0;
            switch (rotation) {
                case 90: {
                    rotatedShapes.add(VoxelShapeHelper.boxSafe(x1 * 16.0, 8.0 - z1, 8.0 + y1, x2 * 16.0, 8.0 - z2, 8.0 + y2));
                    break;
                }
                case 180: {
                    rotatedShapes.add(VoxelShapeHelper.boxSafe(x1 * 16.0, 8.0 - z1, 8.0 - y1, x2 * 16.0, 8.0 - z2, 8.0 - y2));
                    break;
                }
                case 270: {
                    rotatedShapes.add(VoxelShapeHelper.boxSafe(x1 * 16.0, 8.0 + z1, 8.0 - y1, x2 * 16.0, 8.0 + z2, 8.0 - y2));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid rotation " + rotation + " (must be 90,180 or 270)");
                }
            }
        });
        return rotatedShapes.stream().reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElse(shape);
    }

    public static VoxelShape combine(BooleanOp func, VoxelShape ... shapes) {
        VoxelShape result = Shapes.m_83040_();
        for (VoxelShape shape : shapes) {
            result = Shapes.m_83148_((VoxelShape)result, (VoxelShape)shape, (BooleanOp)func);
        }
        return result.m_83296_();
    }

    private static VoxelShape boxSafe(double pMinX, double pMinY, double pMinZ, double pMaxX, double pMaxY, double pMaxZ) {
        double x1 = Math.min(pMinX, pMaxX);
        double x2 = Math.max(pMinX, pMaxX);
        double y1 = Math.min(pMinY, pMaxY);
        double y2 = Math.max(pMinY, pMaxY);
        double z1 = Math.min(pMinZ, pMaxZ);
        double z2 = Math.max(pMinZ, pMaxZ);
        return Block.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }
}

