/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import joptsimple.internal.Strings;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector3f;
import shetiphian.core.client.ClientFunction;
import shetiphian.core.client.model.AssembledBakedModel;
import shetiphian.core.client.model.CompositeBakedModel;
import shetiphian.core.client.model.data.ModelProperties;
import shetiphian.core.common.UseContext;
import shetiphian.platforms.client.misc.TextureInfoHelper;
import shetiphian.platforms.client.model.CacheBuilder;
import shetiphian.platforms.client.model.Parts;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumCovering;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.misc.EnumTorchType;

@OnlyIn(value=Dist.CLIENT)
public class ModelPlatform {
    public static final Loader INSTANCE = new Loader();

    private static String getTextureForRenderLayer(ItemStack stack, RenderType layer) {
        if (layer == null || stack.m_41720_() == Items.f_42127_) {
            return Parts.getPlacementTexture();
        }
        BlockState materialState = UseContext.getBlockPlacementStateFor((ItemStack)stack);
        boolean doRender = layer == (ClientFunction.isTranslucent((BlockState)materialState) ? RenderType.m_110466_() : (ClientFunction.isCutout((BlockState)materialState) ? RenderType.m_110463_() : RenderType.m_110451_()));
        return doRender ? CacheBuilder.INSTANCE.getTexture(stack) : null;
    }

    private static void addParts_Flat(List<BakedModel> list, EnumSubType subType, String[] textures, String particle, Direction facing, EnumPlatformType railType, Pair<EnumCovering, String> coveringData) {
        EnumSubType.EnumBase baseType = subType.getBaseType();
        EnumSubType.EnumStyle styleType = subType.getStyleType();
        String name = styleType + (baseType == EnumSubType.EnumBase.CORNER ? "_corner" : "");
        ModelPlatform.add(list, "flat/base_" + baseType, textures[0], styleType == EnumSubType.EnumStyle.INSIDE ? facing.m_122424_() : facing, particle);
        for (String part : subType.getParts()) {
            ModelPlatform.add(list, "flat/" + name + "_" + part, textures[1], facing, particle);
        }
        if (railType != null) {
            if (styleType != EnumSubType.EnumStyle.MIDDLE) {
                ModelPlatform.addParts_Rise(list, subType, new String[]{textures[2], textures[3]}, particle, facing, railType == EnumPlatformType.RAIL, false, coveringData);
            } else {
                ModelPlatform.addParts_SpecialAddon(list, subType, new String[]{textures[2], textures[3]}, particle, facing, railType == EnumPlatformType.RAIL, "flat", coveringData);
            }
        }
        if (coveringData != null) {
            ModelPlatform.addCover(list, "flat", "_" + (String)(styleType == EnumSubType.EnumStyle.MIDDLE ? "middle" : name), facing, coveringData);
        }
    }

    private static void addParts_Floor(List<BakedModel> list, EnumSubType subType, String[] textures, String particle, Direction facing, int support, Pair<EnumCovering, String> coveringData) {
        EnumSubType.EnumBase baseType = subType.getBaseType();
        EnumSubType.EnumStyle styleType = subType.getStyleType();
        String leg_base = baseType + "_" + styleType;
        String name = styleType + (baseType == EnumSubType.EnumBase.CORNER ? "_corner" : "");
        ModelPlatform.add(list, "floor/base_" + leg_base, textures[0], facing, particle);
        for (String part : subType.getParts()) {
            ModelPlatform.add(list, "floor/" + name + "_" + part, textures[1], facing, particle);
        }
        if (support == 0) {
            ModelPlatform.add(list, "floor/support_legs", textures[0], facing, particle);
        } else if (support == 1) {
            if (styleType != EnumSubType.EnumStyle.MIDDLE) {
                ModelPlatform.add(list, "floor/support_post_" + leg_base, textures[0], facing, particle);
            } else {
                ModelPlatform.add(list, "floor/support_post_extension", textures[0], facing, particle);
            }
        }
        if (coveringData != null) {
            ModelPlatform.addCover(list, "floor", "_" + (String)(styleType == EnumSubType.EnumStyle.MIDDLE ? "middle" : name), facing, coveringData);
        }
    }

    private static void addParts_Ramps(List<BakedModel> list, EnumPlatformType type, EnumSubType subType, String[] textures, String particle, Direction facing, EnumPlatformType railType, int support, Pair<EnumCovering, String> coveringData) {
        String base;
        EnumSubType.EnumBase baseType = subType.getBaseType();
        EnumSubType.EnumStyle styleType = subType.getStyleType();
        ModelPlatform.add(list, type + "/" + styleType, textures[1], facing, particle);
        String string = base = baseType == EnumSubType.EnumBase.NORMAL ? "normal" : baseType + "_" + styleType;
        if (type == EnumPlatformType.RAMP || type == EnumPlatformType.STAIRS) {
            ModelPlatform.add(list, "ramp/base_" + base, textures[0], facing, particle);
            if (support % 3 < 2) {
                ModelPlatform.add(list, "ramp/support_" + base + (support % 3 == 1 ? "_post" : "_legs"), textures[0], facing, particle);
            }
            if (support > 2 && type == EnumPlatformType.RAMP) {
                String extra = styleType == EnumSubType.EnumStyle.RIGHT || styleType == EnumSubType.EnumStyle.LEFT ? (support % 3 != 1 ? "_sb" : "_lb") : "";
                ModelPlatform.add(list, "ramp/support_beam_" + styleType + extra, textures[0], facing, particle);
                ModelPlatform.add(list, "ramp/support_brace_" + styleType, textures[0], facing, particle);
            }
        } else {
            ModelPlatform.add(list, type + "/base_" + base, textures[0], facing, particle);
            if (support % 3 < 2) {
                ModelPlatform.add(list, type + "/support_" + base + (support % 3 == 1 ? "_post" : "_legs"), textures[0], facing, particle);
            }
        }
        if (railType != null && (subType == EnumSubType.MIDDLE || baseType == EnumSubType.EnumBase.CORNER)) {
            ModelPlatform.addParts_SpecialAddon(list, subType, new String[]{textures[2], textures[3]}, particle, facing, railType == EnumPlatformType.RAIL, type.m_7912_(), coveringData);
        }
        if (coveringData != null) {
            ModelPlatform.addCover(list, type.m_7912_(), "_" + styleType, facing, coveringData);
        }
    }

    private static void addParts_Roofs(List<BakedModel> list, EnumPlatformType type, EnumSubType subType, String edgeType, String[] textures, String particle, Direction facing, EnumPlatformType railType, int support, boolean skylight, Pair<EnumCovering, String> coveringData) {
        EnumSubType.EnumBase baseType = subType.getBaseType();
        EnumSubType.EnumStyle styleType = subType.getStyleType();
        boolean bl = skylight = skylight && support > 0;
        if (!skylight || type == EnumPlatformType.TILES) {
            ModelPlatform.add(list, "shingles/" + styleType, textures[1], facing, particle);
        }
        if (!skylight) {
            ModelPlatform.add(list, type + "/" + styleType, textures[1], facing, particle);
        }
        if (support == 0 && (baseType == EnumSubType.EnumBase.CORNER || styleType == EnumSubType.EnumStyle.MIDDLE)) {
            if (styleType == EnumSubType.EnumStyle.MIDDLE) {
                ModelPlatform.add(list, "shingles/base_full", textures[0], facing, particle);
            } else {
                ModelPlatform.add(list, "shingles/base_" + baseType + "_" + styleType + "_full", textures[0], facing, particle);
            }
        } else {
            if (edgeType == null) {
                edgeType = "";
            }
            Object base = baseType == EnumSubType.EnumBase.NORMAL ? "" + styleType : baseType + "_" + styleType;
            ModelPlatform.add(list, "shingles/base_" + (String)base, textures[skylight ? 1 : 0], facing, particle);
            if (styleType == EnumSubType.EnumStyle.OUTSIDE && edgeType.contains("lower")) {
                ModelPlatform.add(list, "shingles/support_beam_outside_purlin", textures[0], facing, particle);
            } else {
                ModelPlatform.add(list, "shingles/support_beam_" + styleType, textures[0], facing, particle);
            }
            if (baseType == EnumSubType.EnumBase.NORMAL) {
                String ends = edgeType.contains("lower") ? "_purlin_lower" : "_cap_lower";
                ModelPlatform.add(list, "shingles/support_beam_" + styleType + ends, textures[0], facing, particle);
                ends = edgeType.contains("upper") ? "_purlin_upper" : "_cap_upper";
                ModelPlatform.add(list, "shingles/support_beam_" + styleType + ends, textures[0], facing, particle);
            }
            if (support == 1 && railType == null) {
                base = baseType == EnumSubType.EnumBase.NORMAL ? "normal" : baseType + "_" + styleType;
                ModelPlatform.add(list, "ramp/support_" + (String)base + "_post", textures[0], facing, particle);
            } else if (support >= 3) {
                if (support != 4 && (baseType == EnumSubType.EnumBase.CORNER || styleType == EnumSubType.EnumStyle.MIDDLE)) {
                    ModelPlatform.add(list, "shingles/support_plane_" + styleType, textures[0], facing, particle);
                }
                if (support != 3 && baseType == EnumSubType.EnumBase.NORMAL) {
                    ModelPlatform.add(list, "shingles/support_plane_slope", textures[skylight ? 1 : 0], facing, particle);
                }
            }
        }
        if (railType != null) {
            String name = support == 1 ? "full" : (baseType == EnumSubType.EnumBase.NORMAL ? "middle" : subType.getStyleName());
            ModelPlatform.add(list, railType + "/support_roof_" + name, textures[2], facing, particle);
            ModelPlatform.add(list, railType + "/bar_roof", textures[3], facing, particle);
            if (coveringData != null && ((EnumCovering)((Object)coveringData.getLeft())).renderSides()) {
                ModelPlatform.add(list, railType + "/covering/roof", (String)coveringData.getRight(), facing, (String)coveringData.getRight());
            }
        }
        if (coveringData != null) {
            if (skylight) {
                if (type == EnumPlatformType.TILES) {
                    ModelPlatform.addCover(list, "shingles", "_" + styleType, facing, (Pair<EnumCovering, String>)Pair.of((Object)((Object)((EnumCovering)((Object)coveringData.getLeft())).min()), (Object)((String)coveringData.getRight())));
                }
            } else {
                ModelPlatform.addCover(list, type.m_7912_(), "_" + styleType, facing, coveringData);
            }
        }
    }

    private static void addParts_RoofCaps(List<BakedModel> list, EnumPlatformType type, String edgeType, String[] textures, String particle, Direction facing, EnumPlatformType railType, boolean skylight, boolean diwhy, Pair<EnumCovering, String> coveringData) {
        Object suffix;
        if (Strings.isNullOrEmpty((String)edgeType)) {
            edgeType = "cap";
        }
        Object object = suffix = ((String)(edgeType = "peak_" + (String)edgeType)).endsWith("_sides") ? edgeType : ((String)edgeType).substring(0, 4);
        if (!skylight || type == EnumPlatformType.TILES) {
            ModelPlatform.add(list, "shingles/" + (String)edgeType, textures[1], facing, particle);
            if (diwhy) {
                ModelPlatform.add(list, "shingles/" + (String)suffix + "_dn", textures[1], facing, particle);
            }
        }
        if (!skylight) {
            ModelPlatform.add(list, type + "/" + (String)edgeType, textures[1], facing, particle);
            if (((String)edgeType).matches(".*_(end|middle|sides)")) {
                ModelPlatform.add(list, "shingles/support_plane_" + (String)edgeType, textures[diwhy ? 1 : 0], facing, particle);
            }
        }
        ModelPlatform.add(list, "shingles/base_" + (String)suffix, textures[skylight ? 1 : 0], facing, particle);
        if (skylight) {
            ModelPlatform.add(list, "shingles/base_" + (String)suffix + "_up", textures[1], facing, particle);
        }
        ModelPlatform.add(list, "shingles/support_beam_" + (String)suffix, textures[0], facing, particle);
        if (railType != null) {
            ModelPlatform.add(list, railType + "/support_roof_full", textures[2], facing, particle);
            ModelPlatform.add(list, railType + "/bar_roof", textures[3], facing, particle);
            if (coveringData != null && ((EnumCovering)((Object)coveringData.getLeft())).renderSides()) {
                ModelPlatform.add(list, railType + "/covering/roof", (String)coveringData.getRight(), facing, (String)coveringData.getRight());
            }
        }
        if (coveringData != null) {
            ModelPlatform.addCover(list, type.m_7912_(), "_" + (String)edgeType, facing, coveringData);
        }
    }

    private static void addParts_SpecialAddon(List<BakedModel> list, EnumSubType subType, String[] textures, String particle, Direction facing, boolean isRail, String suffix, Pair<EnumCovering, String> coveringData) {
        String variant = isRail ? "rail" : "rise";
        boolean isRamp = suffix.startsWith("ramp") || suffix.startsWith("steps") || suffix.startsWith("stairs");
        String name = subType.getStyleName();
        if (isRamp) {
            ModelPlatform.add(list, variant + "/bar_ramp_" + name, textures[1], facing, particle);
            ModelPlatform.add(list, variant + "/support_ramp_" + name, textures[0], facing, particle);
            name = "middle";
        } else {
            ModelPlatform.add(list, variant + "/bar_" + name, textures[1], facing, particle);
            ModelPlatform.add(list, variant + "/support_" + name, textures[0], facing, particle);
        }
        if (suffix.equals("")) {
            ModelPlatform.add(list, variant + "/support_" + name + "_extended", textures[0], facing, particle);
        }
        if (coveringData != null && ((EnumCovering)((Object)coveringData.getLeft())).renderOnRails()) {
            ModelPlatform.addCover(list, variant, "_" + name, facing, coveringData);
            if (!isRamp) {
                ModelPlatform.addCover(list, variant, "_" + name + "_lower", facing, coveringData);
            }
        }
    }

    private static void addParts_Rise(List<BakedModel> list, EnumSubType subType, String[] textures, String particle, Direction facing, boolean isRail, boolean isLinkedToFloor, Pair<EnumCovering, String> coveringData) {
        EnumSubType.EnumBase baseType = subType.getBaseType();
        EnumSubType.EnumStyle styleType = subType.getStyleType();
        if (styleType != EnumSubType.EnumStyle.MIDDLE) {
            String variant = isRail ? "rail" : "rise";
            String name = styleType + (baseType == EnumSubType.EnumBase.CORNER ? "_corner" : "");
            if (name.equals("left") || name.equals("right")) {
                name = name + "_tall";
            }
            ModelPlatform.add(list, variant + "/bar_" + name, textures[1], facing, particle);
            ModelPlatform.add(list, variant + "/support_" + name + (isLinkedToFloor ? "_extended" : ""), textures[0], facing, particle);
            if (coveringData != null && ((EnumCovering)((Object)coveringData.getLeft())).renderOnRails()) {
                ModelPlatform.addCover(list, variant, "_" + name, facing, coveringData);
            }
        } else {
            ModelPlatform.addParts_SpecialAddon(list, subType, textures, particle, facing, isRail, "", coveringData);
        }
    }

    private static void addCover(List<BakedModel> list, String type, String part, Direction facing, Pair<EnumCovering, String> coveringData) {
        if (((EnumCovering)((Object)coveringData.getLeft())).renderSides()) {
            ModelPlatform.add(list, type + "/covering/lvl-" + part, (String)coveringData.getRight(), facing, (String)coveringData.getRight());
        }
        ModelPlatform.add(list, type + "/covering/lvl" + ((EnumCovering)((Object)coveringData.getLeft())).getLayer() + part, (String)coveringData.getRight(), facing, (String)coveringData.getRight());
    }

    private static void add(List<BakedModel> list, String part, String key, Direction facing, String particle) {
        BakedModel model;
        if (!Strings.isNullOrEmpty((String)key) && (model = CacheBuilder.get(part, key, facing, particle)) != null) {
            list.add(model);
        }
    }

    private static class Loader
    implements IGeometryLoader<Geometry> {
        private Loader() {
        }

        public Geometry read(JsonObject modelContents, JsonDeserializationContext deserializationContext) throws JsonParseException {
            return Geometry.INSTANCE;
        }
    }

    private static class ItemHandler {
        static ItemHandler INSTANCE = new ItemHandler();
        private static final Table<EnumPlatformType, EnumSubType.EnumStyle, ItemTransforms> SPECIAL_TRANSFORMS = HashBasedTable.create();
        private static final Map<EnumPlatformType, ItemTransforms> TRANSFORMS = ItemHandler.buildTransforms();

        private ItemHandler() {
        }

        BakedModel getModel(ItemStack stack, BakedModel original) {
            if (!stack.m_41619_() && stack.m_41720_() instanceof ItemBlockPlatform) {
                String modelKey;
                EnumPlatformType platformType = ((ItemBlockPlatform)stack.m_41720_()).getPlatformType();
                ItemTransforms transforms = TRANSFORMS.getOrDefault((Object)platformType, ItemTransforms.f_111786_);
                ItemStack itemFrame = ItemBlockPlatform.getFrameTextureStack(stack);
                ItemStack itemCover = ItemBlockPlatform.getCoverTextureStack(stack);
                String key1 = CacheBuilder.INSTANCE.getTexture(itemFrame);
                String key2 = CacheBuilder.INSTANCE.getTexture(itemCover);
                EnumSubType subType = ItemBlockPlatform.getSubType(stack);
                if (SPECIAL_TRANSFORMS.contains((Object)platformType, (Object)subType.getStyleType())) {
                    transforms = (ItemTransforms)SPECIAL_TRANSFORMS.get((Object)platformType, (Object)subType.getStyleType());
                }
                if (!CacheBuilder.INSTANCE.ITEM_CACHE.containsKey(modelKey = platformType + "::" + subType + "::" + key1 + "::" + key2)) {
                    ArrayList<BakedModel> list = new ArrayList<BakedModel>();
                    switch (platformType) {
                        case FLAT: {
                            if (subType == EnumSubType.NONE) {
                                ModelPlatform.add(list, "flat/edge_north", key2, Direction.NORTH, key2);
                                ModelPlatform.add(list, "flat/base_normal", key1, Direction.NORTH, key2);
                                break;
                            }
                            ModelPlatform.addParts_Flat(list, subType, new String[]{key1, key2}, key2, Direction.NORTH, null, null);
                            break;
                        }
                        case FLOOR: {
                            if (subType == EnumSubType.NONE) {
                                ModelPlatform.add(list, "floor/edge_north", key2, Direction.NORTH, key2);
                                ModelPlatform.add(list, "floor/base_normal_edge", key1, Direction.NORTH, key2);
                                break;
                            }
                            ModelPlatform.addParts_Floor(list, subType, new String[]{key1, key2}, key2, Direction.NORTH, 0, null);
                            break;
                        }
                        case FRAME: {
                            ModelPlatform.add(list, "frame/bar", key2, Direction.NORTH, key2);
                            ModelPlatform.add(list, "frame/support", key1, Direction.NORTH, key2);
                            break;
                        }
                        case RAMP: 
                        case STAIRS: {
                            if (subType == EnumSubType.NONE) {
                                ModelPlatform.add(list, platformType + "/left", key2, Direction.NORTH, key2);
                                ModelPlatform.add(list, "ramp/base_normal", key1, Direction.NORTH, key2);
                                ModelPlatform.add(list, "ramp/base_normal_strut", key1, Direction.NORTH, key2);
                                ModelPlatform.add(list, "ramp/support_normal_post", key1, Direction.NORTH, key2);
                                break;
                            }
                            ModelPlatform.addParts_Ramps(list, platformType, subType, new String[]{key1, key2}, key2, Direction.NORTH, null, 1, null);
                            break;
                        }
                        case STEPS: {
                            if (subType == EnumSubType.NONE) {
                                ModelPlatform.add(list, "steps/left", key2, Direction.NORTH, key2);
                                ModelPlatform.add(list, "steps/base_normal", key1, Direction.NORTH, key2);
                                ModelPlatform.add(list, "steps/base_normal_strut", key1, Direction.NORTH, key2);
                                ModelPlatform.add(list, "steps/support_normal_post", key1, Direction.NORTH, key2);
                                break;
                            }
                            ModelPlatform.addParts_Ramps(list, platformType, subType, new String[]{key1, key2}, key2, Direction.NORTH, null, 1, null);
                            break;
                        }
                        case SHINGLES: 
                        case TILES: {
                            boolean skylight = ClientFunction.isTranslucent((BlockState)UseContext.getBlockPlacementStateFor((ItemStack)itemCover));
                            if (subType == EnumSubType.NONE || subType.getStyleType() == EnumSubType.EnumStyle.EDGE) {
                                String part;
                                String string = part = subType == EnumSubType.NONE ? "left" : "peak_cap";
                                if (!skylight || platformType == EnumPlatformType.TILES) {
                                    ModelPlatform.add(list, "shingles/" + part, key2, Direction.NORTH, key2);
                                }
                                if (subType == EnumSubType.NONE) {
                                    ModelPlatform.add(list, "shingles/base_left", skylight ? key2 : key1, Direction.NORTH, key2);
                                    ModelPlatform.add(list, "shingles/support_beam_left", key1, Direction.NORTH, key2);
                                    ModelPlatform.add(list, "shingles/support_beam_left_cap_lower", key1, Direction.NORTH, key2);
                                    ModelPlatform.add(list, "shingles/support_beam_left_cap_upper", key1, Direction.NORTH, key2);
                                } else {
                                    ModelPlatform.add(list, "shingles/base_peak", skylight ? key2 : key1, Direction.NORTH, key2);
                                    ModelPlatform.add(list, "shingles/support_beam_peak", key1, Direction.NORTH, key2);
                                }
                                if (skylight || platformType != EnumPlatformType.TILES) break;
                                ModelPlatform.add(list, "tiles/" + part, key2, Direction.NORTH, key2);
                                break;
                            }
                            ModelPlatform.addParts_Roofs(list, platformType, subType, "", new String[]{key1, key2}, key2, Direction.NORTH, null, 1, skylight, null);
                            break;
                        }
                        case RISE: {
                            if (subType == EnumSubType.NONE) {
                                ModelPlatform.add(list, "rise/bar_edge", key2, Direction.NORTH, key2);
                                ModelPlatform.add(list, "rise/support_edge", key1, Direction.NORTH, key2);
                                break;
                            }
                            ModelPlatform.addParts_Rise(list, subType, new String[]{key1, key2}, key2, Direction.NORTH, false, false, null);
                            break;
                        }
                        case RAIL: {
                            if (subType == EnumSubType.NONE) {
                                ModelPlatform.add(list, "rail/bar_edge", key2, Direction.NORTH, key2);
                                ModelPlatform.add(list, "rail/support_edge", key1, Direction.NORTH, key2);
                                break;
                            }
                            ModelPlatform.addParts_Rise(list, subType, new String[]{key1, key2}, key2, Direction.NORTH, true, false, null);
                        }
                    }
                    BlockState stateFrame = UseContext.getBlockPlacementStateFor((ItemStack)itemFrame);
                    BlockState stateCover = UseContext.getBlockPlacementStateFor((ItemStack)itemCover);
                    CacheBuilder.INSTANCE.ITEM_CACHE.put(modelKey, new AssembledBakedModel(list, new ItemTransforms[]{transforms}).setItemLayers(new RenderType[]{ClientFunction.isTranslucent((BlockState)stateFrame) || ClientFunction.isTranslucent((BlockState)stateCover) ? Sheets.m_110792_() : (ClientFunction.isCutout((BlockState)stateFrame) || ClientFunction.isCutout((BlockState)stateCover) ? Sheets.m_110790_() : Sheets.m_110789_())}));
                }
                return (BakedModel)CacheBuilder.INSTANCE.ITEM_CACHE.get(modelKey);
            }
            return original;
        }

        private static Map<EnumPlatformType, ItemTransforms> buildTransforms() {
            HashMap<EnumPlatformType, ItemTransforms> transforms = new HashMap<EnumPlatformType, ItemTransforms>();
            transforms.put(EnumPlatformType.FLAT, ItemHandler.getFlatTransforms());
            transforms.put(EnumPlatformType.FLOOR, ItemHandler.getFloorTransforms());
            transforms.put(EnumPlatformType.FRAME, ItemHandler.getFrameTransforms());
            ItemTransforms inclines = ItemHandler.getInclineTransforms();
            transforms.put(EnumPlatformType.RAMP, inclines);
            transforms.put(EnumPlatformType.STAIRS, inclines);
            transforms.put(EnumPlatformType.STEPS, inclines);
            ItemTransforms roofs = ItemHandler.getRoofTransforms();
            transforms.put(EnumPlatformType.SHINGLES, roofs);
            transforms.put(EnumPlatformType.TILES, roofs);
            ItemTransforms railings = ItemHandler.getRailingTransforms(false);
            transforms.put(EnumPlatformType.RISE, railings);
            transforms.put(EnumPlatformType.RAIL, railings);
            SPECIAL_TRANSFORMS.clear();
            railings = ItemHandler.getRailingTransforms(true);
            SPECIAL_TRANSFORMS.put((Object)EnumPlatformType.RISE, (Object)EnumSubType.EnumStyle.LEFT, (Object)railings);
            SPECIAL_TRANSFORMS.put((Object)EnumPlatformType.RISE, (Object)EnumSubType.EnumStyle.RIGHT, (Object)railings);
            SPECIAL_TRANSFORMS.put((Object)EnumPlatformType.RAIL, (Object)EnumSubType.EnumStyle.LEFT, (Object)railings);
            SPECIAL_TRANSFORMS.put((Object)EnumPlatformType.RAIL, (Object)EnumSubType.EnumStyle.RIGHT, (Object)railings);
            return transforms;
        }

        private static ItemTransforms getFlatTransforms() {
            ItemTransform thirdperson_left = ItemHandler.create(75.0f, 135.0f, 0.0f, 0.0f, 2.5f, 3.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform thirdperson_right = ItemHandler.create(75.0f, 135.0f, 0.0f, 0.0f, 2.5f, 3.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform firstperson_left = ItemHandler.create(0.0f, 135.0f, 0.0f, 0.0f, 5.25f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform firstperson_right = ItemHandler.create(0.0f, 135.0f, 0.0f, 0.0f, 5.25f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform head = ItemTransform.f_111754_;
            ItemTransform gui = ItemHandler.create(30.0f, 315.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.625f, 0.625f, 0.625f);
            ItemTransform ground = ItemHandler.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransform fixed = ItemHandler.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            return new ItemTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private static ItemTransforms getInclineTransforms() {
            ItemTransform thirdperson_left = ItemHandler.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform thirdperson_right = ItemHandler.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform firstperson_left = ItemHandler.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform firstperson_right = ItemHandler.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform head = ItemTransform.f_111754_;
            ItemTransform gui = ItemHandler.create(30.0f, 315.0f, 0.0f, 0.0f, 0.75f, 0.0f, 0.625f, 0.625f, 0.625f);
            ItemTransform ground = ItemHandler.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransform fixed = ItemHandler.create(0.0f, 90.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            return new ItemTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private static ItemTransforms getRoofTransforms() {
            ItemTransform thirdperson_left = ItemHandler.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform thirdperson_right = ItemHandler.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform firstperson_left = ItemHandler.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform firstperson_right = ItemHandler.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform head = ItemTransform.f_111754_;
            ItemTransform gui = ItemHandler.create(30.0f, 315.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.52f, 0.52f, 0.52f);
            ItemTransform ground = ItemHandler.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransform fixed = ItemHandler.create(0.0f, 90.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            return new ItemTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private static ItemTransforms getFloorTransforms() {
            ItemTransform thirdperson_left = ItemHandler.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform thirdperson_right = ItemHandler.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform firstperson_left = ItemHandler.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform firstperson_right = ItemHandler.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform head = ItemTransform.f_111754_;
            ItemTransform gui = ItemHandler.create(30.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f, 0.625f, 0.625f);
            ItemTransform ground = ItemHandler.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransform fixed = ItemHandler.create(0.0f, 90.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            return new ItemTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private static ItemTransforms getFrameTransforms() {
            ItemTransform thirdperson_left = ItemHandler.create(75.0f, 45.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform thirdperson_right = ItemHandler.create(75.0f, 45.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform firstperson_left = ItemHandler.create(0.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform firstperson_right = ItemHandler.create(0.0f, 45.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform head = ItemTransform.f_111754_;
            ItemTransform gui = ItemHandler.create(30.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f, 0.625f, 0.625f);
            ItemTransform ground = ItemHandler.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransform fixed = ItemHandler.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            return new ItemTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private static ItemTransforms getRailingTransforms(boolean tall) {
            ItemTransform thirdperson_left = ItemHandler.create(75.0f, 45.0f, 0.0f, -3.5f, 0.0f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform thirdperson_right = ItemHandler.create(75.0f, 225.0f, 0.0f, -3.5f, 0.0f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform firstperson_left = ItemHandler.create(0.0f, 45.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform firstperson_right = ItemHandler.create(0.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform head = ItemTransform.f_111754_;
            ItemTransform gui = tall ? ItemHandler.create(30.0f, 315.0f, 0.0f, 0.25f, 2.75f, 0.0f, 0.55f, 0.4f, 0.4f) : ItemHandler.create(30.0f, 315.0f, 0.0f, 0.75f, -0.75f, 0.0f, 0.625f, 0.625f, 0.625f);
            ItemTransform ground = ItemHandler.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransform fixed = ItemHandler.create(0.0f, 90.0f, 0.0f, 0.0f, 0.0f, -2.75f, 0.5f, 0.5f, 0.5f);
            return new ItemTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private static ItemTransform create(float rX, float rY, float rZ, float tX, float tY, float tZ, float sX, float sY, float sZ) {
            Vector3f rotation = new Vector3f(rX, rY, rZ);
            Vector3f translation = new Vector3f(tX, tY, tZ);
            translation.mul(0.0625f);
            translation.set(Mth.m_14036_((float)translation.x, (float)-5.0f, (float)5.0f), Mth.m_14036_((float)translation.y, (float)-5.0f, (float)5.0f), Mth.m_14036_((float)translation.z, (float)-5.0f, (float)5.0f));
            Vector3f scale = new Vector3f(sX, sY, sZ);
            scale.set(Mth.m_14036_((float)scale.x, (float)-4.0f, (float)4.0f), Mth.m_14036_((float)scale.y, (float)-4.0f, (float)4.0f), Mth.m_14036_((float)scale.z, (float)-4.0f, (float)4.0f));
            return new ItemTransform(rotation, translation, scale);
        }
    }

    private static class BlockHandler {
        static BlockHandler INSTANCE = new BlockHandler();

        private BlockHandler() {
        }

        List<BakedModel> getList(BlockState state, ModelData data, RenderType layer) {
            ArrayList<BakedModel> list = new ArrayList<BakedModel>();
            if (state.m_60734_() instanceof BlockPlatformBase) {
                CompoundTag nbtTag;
                EnumPlatformType platformType = ((BlockPlatformBase)state.m_60734_()).getPlatformType();
                Direction facing = (Direction)state.m_61143_((Property)BlockPlatformBase.FACING);
                EnumSubType subType = BlockPlatformBase.getPlatformSubType(state);
                ItemStack itemBaseFrame = TextureInfoHelper.DEFAULT_TEXTURE;
                ItemStack itemBaseCover = TextureInfoHelper.DEFAULT_TEXTURE;
                EnumPlatformType railType = null;
                ItemStack itemRailFrame = TextureInfoHelper.DEFAULT_TEXTURE;
                ItemStack itemRailCover = TextureInfoHelper.DEFAULT_TEXTURE;
                EnumTorchType torch = EnumTorchType.NONE;
                byte support = 0;
                boolean linkedToFloor = false;
                String edgeType = null;
                Pair coveringData = null;
                if (data.has(ModelProperties.NBTProperty) && (nbtTag = (CompoundTag)data.get(ModelProperties.NBTProperty)) != null) {
                    EnumCovering covering;
                    ItemBlockPlatform platform;
                    Item item;
                    ItemStack itemRail;
                    if (nbtTag.m_128441_("frame_texture_item")) {
                        itemBaseFrame = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("frame_texture_item"));
                    }
                    if (nbtTag.m_128441_("cover_texture_item")) {
                        itemBaseCover = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("cover_texture_item"));
                    }
                    if (nbtTag.m_128441_("rail_item") && !(itemRail = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("rail_item"))).m_41619_() && (item = itemRail.m_41720_()) instanceof ItemBlockPlatform && (platform = (ItemBlockPlatform)item).getPlatformType().isAddon()) {
                        railType = platform.getPlatformType();
                        itemRailFrame = ItemBlockPlatform.getFrameTextureStack(itemRail);
                        itemRailCover = ItemBlockPlatform.getCoverTextureStack(itemRail);
                    }
                    if (nbtTag.m_128441_("torch")) {
                        torch = EnumTorchType.byIndex(nbtTag.m_128445_("torch"));
                    }
                    if (nbtTag.m_128441_("support")) {
                        support = nbtTag.m_128445_("support");
                    }
                    if (nbtTag.m_128441_("linkedToFloor")) {
                        linkedToFloor = nbtTag.m_128471_("linkedToFloor");
                    }
                    if (nbtTag.m_128441_("edge_type")) {
                        edgeType = nbtTag.m_128461_("edge_type");
                    }
                    if (nbtTag.m_128441_("covering") && (covering = EnumCovering.byName(nbtTag.m_128461_("covering"))) != EnumCovering.NONE && nbtTag.m_128441_("covering_item")) {
                        String texture = ModelPlatform.getTextureForRenderLayer(ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("covering_item")), layer);
                        coveringData = Pair.of((Object)((Object)covering), (Object)texture);
                    }
                }
                String particle = CacheBuilder.INSTANCE.getTexture(itemBaseCover);
                String[] textures = new String[4];
                textures[0] = ModelPlatform.getTextureForRenderLayer(itemBaseFrame, layer);
                textures[1] = ModelPlatform.getTextureForRenderLayer(itemBaseCover, layer);
                if (railType != null) {
                    textures[2] = ModelPlatform.getTextureForRenderLayer(itemRailFrame, layer);
                    textures[3] = ModelPlatform.getTextureForRenderLayer(itemRailCover, layer);
                }
                switch (platformType) {
                    case FLAT: {
                        ModelPlatform.addParts_Flat(list, subType, textures, particle, facing, railType, coveringData);
                        break;
                    }
                    case FLOOR: {
                        ModelPlatform.addParts_Floor(list, subType, textures, particle, facing, support, coveringData);
                        break;
                    }
                    case FRAME: {
                        ModelPlatform.add(list, "frame/bar", textures[1], facing, particle);
                        ModelPlatform.add(list, "frame/support", textures[0], facing, particle);
                        if (torch != null && torch != EnumTorchType.NONE && layer == RenderType.m_110451_()) {
                            ModelPlatform.add(list, "frame/brazier_base", Parts.getBrazierTexture(), facing, particle);
                            ModelPlatform.add(list, "frame/brazier_fill", Parts.getBrazierFillTexture(torch), facing, particle);
                        }
                        if (coveringData == null || !((EnumCovering)((Object)coveringData.getLeft())).renderOnRails()) break;
                        ModelPlatform.addCover(list, "frame", "", facing, coveringData);
                        break;
                    }
                    case RAMP: 
                    case STAIRS: 
                    case STEPS: {
                        ModelPlatform.addParts_Ramps(list, platformType, subType, textures, particle, facing, railType, support, coveringData);
                        break;
                    }
                    case SHINGLES: 
                    case TILES: {
                        boolean skylight = ClientFunction.isTranslucent((BlockState)UseContext.getBlockPlacementStateFor((ItemStack)itemBaseCover));
                        if (subType.getStyleType() == EnumSubType.EnumStyle.EDGE) {
                            boolean diwhy = !ClientFunction.isSolid((BlockState)UseContext.getBlockPlacementStateFor((ItemStack)itemBaseFrame));
                            ModelPlatform.addParts_RoofCaps(list, platformType, edgeType, textures, particle, facing, railType, skylight, diwhy, coveringData);
                            break;
                        }
                        ModelPlatform.addParts_Roofs(list, platformType, subType, edgeType, textures, particle, facing, railType, support, skylight, coveringData);
                        break;
                    }
                    case RISE: {
                        ModelPlatform.addParts_Rise(list, subType, textures, particle, facing, false, linkedToFloor, coveringData);
                        break;
                    }
                    case RAIL: {
                        ModelPlatform.addParts_Rise(list, subType, textures, particle, facing, true, linkedToFloor, coveringData);
                    }
                }
            }
            return list;
        }
    }

    private static class Baked
    extends CompositeBakedModel {
        private static final BakedModel INSTANCE = new Baked();

        private Baked() {
        }

        public TextureAtlasSprite getParticleIcon(@Nonnull ModelData data) {
            CompoundTag nbtTag;
            ItemStack materialItem = ItemStack.f_41583_;
            if (data.has(ModelProperties.NBTProperty) && (nbtTag = (CompoundTag)data.get(ModelProperties.NBTProperty)) != null && nbtTag.m_128441_("cover_texture_item")) {
                materialItem = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("cover_texture_item"));
            }
            if (materialItem.m_41619_()) {
                materialItem = new ItemStack((ItemLike)Blocks.f_50058_);
            }
            return CacheBuilder.INSTANCE.getTextureSprite(materialItem);
        }

        public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
            return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110466_(), RenderType.m_110463_(), RenderType.m_110451_()});
        }

        protected List<BakedModel> handleBlockState(BlockState state, Direction side, RandomSource rand, ModelData data, RenderType layer) {
            return CacheBuilder.INSTANCE.getOrBuildModelList(state, data, layer, () -> BlockHandler.INSTANCE.getList(state, data, layer));
        }

        protected BakedModel handleItemState(BakedModel model, ItemStack stack, Level world, LivingEntity entity) {
            return ItemHandler.INSTANCE.getModel(stack, model);
        }
    }

    private static class Geometry
    implements IUnbakedGeometry<Geometry> {
        private static final Geometry INSTANCE = new Geometry();

        private Geometry() {
        }

        public BakedModel bake(IGeometryBakingContext owner, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            CacheBuilder.INSTANCE.preBakeSetup(bakery, spriteGetter);
            return Baked.INSTANCE;
        }
    }
}

