/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.base;

import earth.terrarium.adastra.common.blockentities.base.EnergyContainerMachineBlockEntity;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RecipeMachineBlockEntity<T extends Recipe<Container>>
extends EnergyContainerMachineBlockEntity {
    @Nullable
    protected T recipe;
    protected int cookTime;
    protected int cookTimeTotal;
    protected final RecipeManager.CachedCheck<Container, T> quickCheck;

    public RecipeMachineBlockEntity(BlockPos pos, BlockState state, int containerSize, Supplier<RecipeType<T>> recipeType) {
        super(pos, state, containerSize);
        this.quickCheck = RecipeManager.m_220267_(recipeType.get());
    }

    @Override
    public void internalServerTick(ServerLevel level, long time, BlockState state, BlockPos pos) {
        super.internalServerTick(level, time, state, pos);
        if (this.recipe != null && this.canFunction()) {
            this.recipeTick(level, (WrappedBlockEnergyContainer)this.getEnergyStorage());
        }
        if (time % 5L == 0L && this.shouldAutomaticallyUpdateLitState()) {
            this.setLit(this.cookTimeTotal > 0 && this.recipe != null && this.canFunction());
        }
    }

    public boolean shouldAutomaticallyUpdateLitState() {
        return true;
    }

    @Override
    public boolean shouldUpdate() {
        return this.recipe == null;
    }

    public abstract void recipeTick(ServerLevel var1, WrappedBlockEnergyContainer var2);

    public boolean canCraft() {
        return this.recipe != null && this.recipe.m_5818_((Container)this, this.level());
    }

    public abstract void craft();

    public void updateSlots() {
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.cookTime = tag.m_128451_("CookTime");
        this.cookTimeTotal = tag.m_128451_("CookTimeTotal");
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("CookTime", this.cookTime);
        tag.m_128405_("CookTimeTotal", this.cookTimeTotal);
    }

    public void clearRecipe() {
        this.recipe = null;
        this.cookTime = 0;
        this.cookTimeTotal = 0;
    }

    public int cookTime() {
        return this.cookTime;
    }

    public int cookTimeTotal() {
        return this.cookTimeTotal;
    }
}

