/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.util.TriFunction;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;

public class QuarkItemFrameItem
extends ZetaItem {
    private final TriFunction<? extends HangingEntity, Level, BlockPos, Direction> entityProvider;

    public QuarkItemFrameItem(String name, ZetaModule module, TriFunction<? extends HangingEntity, Level, BlockPos, Direction> entityProvider) {
        super(name, module, new Item.Properties());
        this.entityProvider = entityProvider;
        CreativeTabManager.addToCreativeTabNextTo((ResourceKey)CreativeModeTabs.f_256791_, (ItemLike)this, (ItemLike)Items.f_151063_, (boolean)false);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        BlockPos placeLocation = pos.m_121945_(facing);
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (player != null && !this.canPlace(player, facing, stack, placeLocation)) {
            return InteractionResult.FAIL;
        }
        Level world = context.m_43725_();
        HangingEntity frame = this.entityProvider.apply(world, placeLocation, facing);
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            EntityType.m_20620_((Level)world, (Player)player, (Entity)frame, (CompoundTag)tag);
        }
        if (frame.m_7088_()) {
            if (!world.f_46443_) {
                world.m_220400_((Entity)player, GameEvent.f_157810_, frame.m_20182_());
                frame.m_7084_();
                world.m_7967_((Entity)frame);
            }
            stack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    protected boolean canPlace(Player player, Direction facing, ItemStack stack, BlockPos pos) {
        return !player.m_9236_().m_151570_(pos) && player.m_36204_(pos, facing, stack);
    }
}

