/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.network;

import com.faboslav.friendsandfoes.common.network.base.NetworkDirection;
import com.faboslav.friendsandfoes.common.network.base.Packet;
import com.faboslav.friendsandfoes.common.network.base.PacketHandler;
import com.faboslav.friendsandfoes.common.platform.PacketChannelManager;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;

public final class NetworkChannel {
    private final ResourceLocation channel;

    public NetworkChannel(String modid, String channel) {
        this.channel = new ResourceLocation(modid, channel);
        PacketChannelManager.registerChannel(this.channel);
    }

    public <T extends Packet<T>> void registerPacket(NetworkDirection direction, ResourceLocation id, PacketHandler<T> handler, Class<T> packetClass) {
        if (direction == NetworkDirection.CLIENT_TO_SERVER) {
            PacketChannelManager.registerC2SPacket(this.channel, id, handler, packetClass);
        } else {
            PacketChannelManager.registerS2CPacket(this.channel, id, handler, packetClass);
        }
    }

    public <T extends Packet<T>> void sendToServer(T packet) {
        PacketChannelManager.sendToServer(this.channel, packet);
    }

    public <T extends Packet<T>> void sendToPlayer(T packet, Player player) {
        PacketChannelManager.sendToPlayer(this.channel, packet, player);
    }

    public <T extends Packet<T>> void sendToPlayers(T packet, Collection<? extends Player> players) {
        players.forEach(player -> this.sendToPlayer(packet, (Player)player));
    }

    public <T extends Packet<T>> void sendToAllPlayers(T packet, MinecraftServer server) {
        this.sendToPlayers(packet, server.m_6846_().m_11314_());
    }

    public <T extends Packet<T>> void sendToPlayersInLevel(T packet, Level world) {
        this.sendToPlayers(packet, world.m_6907_());
    }

    public <T extends Packet<T>> void sendToAllLoaded(T packet, Level world, BlockPos pos) {
        ChunkSource chunkSource;
        LevelChunk chunk = world.m_46745_(pos);
        if (chunk != null && (chunkSource = world.m_7726_()) instanceof ServerChunkCache) {
            ServerChunkCache serverCache = (ServerChunkCache)chunkSource;
            serverCache.f_8325_.m_183262_(chunk.m_7697_(), false).forEach(player -> this.sendToPlayer(packet, (Player)player));
        }
    }

    public <T extends Packet<T>> void sendToPlayersInRange(T packet, Level world, BlockPos pos, double range) {
        for (Player player : world.m_6907_()) {
            if (!(player.m_20183_().m_123331_((Vec3i)pos) <= range)) continue;
            this.sendToPlayer(packet, player);
        }
    }
}

