/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare;

import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;

public final class GlareTeleportToOwnerTask
extends Behavior<GlareEntity> {
    private LivingEntity owner;

    public GlareTeleportToOwnerTask() {
        super((Map)ImmutableMap.of());
    }

    protected boolean shouldRun(ServerLevel world, GlareEntity glare) {
        LivingEntity owner = glare.m_269323_();
        return owner != null && !owner.m_5833_() && !glare.m_21523_() && !glare.m_21827_() && !glare.m_20159_() && !(glare.m_20280_((Entity)owner) < 1024.0);
    }

    protected void run(ServerLevel world, GlareEntity glare, long time) {
        this.owner = glare.m_269323_();
        this.tryTeleport(glare);
    }

    private void tryTeleport(GlareEntity glare) {
        BlockPos blockPos = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int xOffset = this.getRandomInt(glare, -3, 3);
            int yOffset = this.getRandomInt(glare, -1, 1);
            int zOffset = this.getRandomInt(glare, -3, 3);
            boolean teleportResult = this.tryTeleportTo(glare, blockPos.m_123341_() + xOffset, blockPos.m_123342_() + yOffset, blockPos.m_123343_() + zOffset);
            if (!teleportResult) continue;
            return;
        }
    }

    private boolean tryTeleportTo(GlareEntity glare, int x, int y, int z) {
        if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(glare, new BlockPos(x, y, z))) {
            return false;
        }
        glare.m_7678_((double)x + 0.5, y, (double)z + 0.5, glare.m_146908_(), glare.m_146909_());
        glare.m_21573_().m_26573_();
        return true;
    }

    private boolean canTeleportTo(GlareEntity glare, BlockPos pos) {
        BlockPos blockPos = pos.m_121996_((Vec3i)glare.m_20183_());
        return glare.m_9236_().m_45756_((Entity)glare, glare.m_20191_().m_82338_(blockPos));
    }

    private int getRandomInt(GlareEntity glare, int min, int max) {
        return glare.m_217043_().m_188503_(max - min + 1) + min;
    }
}

