/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.brewery.Brewery;
import net.satisfy.brewery.block.entity.BeerKegFlowerPotBlockEntity;
import net.satisfy.brewery.block.entity.BrewstationBlockEntity;
import net.satisfy.brewery.block.entity.SiloBlockEntity;
import net.satisfy.brewery.registry.ObjectRegistry;

public class BlockEntityRegistry {
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"brewery", (ResourceKey)Registries.f_256922_);
    public static final RegistrySupplier<BlockEntityType<BrewstationBlockEntity>> BREWINGSTATION_BLOCK_ENTITY = BlockEntityRegistry.create("brewingstation", () -> BlockEntityType.Builder.m_155273_(BrewstationBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.WOODEN_BREWINGSTATION.get(), (Block)ObjectRegistry.COPPER_BREWINGSTATION.get(), (Block)ObjectRegistry.NETHERITE_BREWINGSTATION.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<BeerKegFlowerPotBlockEntity>> BEER_MUG_FLOWER_POT_BLOCK_ENTITY = BlockEntityRegistry.create("beer_mug", () -> BlockEntityType.Builder.m_155273_(BeerKegFlowerPotBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.BEER_MUG.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<SiloBlockEntity>> SILO = BlockEntityRegistry.create("silo", () -> BlockEntityType.Builder.m_155273_(SiloBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.SILO_WOOD.get(), (Block)ObjectRegistry.SILO_COPPER.get()}).m_58966_(null));

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> create(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(path, type);
    }

    public static void init() {
        Brewery.LOGGER.debug("Registering Mod BlockEntities for brewery");
        BLOCK_ENTITY_TYPES.register();
    }
}

