/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.item;

import dev.architectury.extensions.injected.InjectedBucketItemExtension;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoodenBucket
extends Item
implements DispensibleContainerItem,
InjectedBucketItemExtension {
    private final Fluid content;

    public WoodenBucket(Fluid fluid, Item.Properties properties) {
        super(properties);
        this.content = fluid;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        BlockHitResult blockHitResult = WoodenBucket.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)(this.content == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (blockHitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (blockHitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        BlockPos blockPos = blockHitResult.m_82425_();
        Direction direction = blockHitResult.m_82434_();
        BlockPos blockPos2 = blockPos.m_121945_(direction);
        if (level.m_7966_(player, blockPos) && player.m_36204_(blockPos2, direction, itemStack)) {
            BlockPos blockPos3;
            if (this.content == Fluids.f_76191_) {
                BlockState blockState = level.m_8055_(blockPos);
                Block block = blockState.m_60734_();
                if (block instanceof BucketPickup) {
                    BucketPickup bucketPickup = (BucketPickup)block;
                    if (level.m_6425_(blockPos).m_76152_() != Fluids.f_76193_) {
                        return InteractionResultHolder.m_19100_((Object)itemStack);
                    }
                    ItemStack itemStack2 = bucketPickup.m_142598_((LevelAccessor)level, blockPos, blockState);
                    if (!itemStack2.m_41619_()) {
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                        bucketPickup.m_142298_().ifPresent(soundEvent -> player.m_5496_(soundEvent, 1.0f, 1.0f));
                        level.m_142346_((Entity)player, GameEvent.f_157816_, blockPos);
                        ItemStack itemStack3 = new ItemStack((ItemLike)ObjectRegistry.WOODEN_WATER_BUCKET.get());
                        if (!level.f_46443_) {
                            CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, itemStack2);
                        }
                        itemStack.m_41774_(1);
                        if (itemStack.m_41619_()) {
                            return InteractionResultHolder.m_19092_((Object)itemStack3, (boolean)level.m_5776_());
                        }
                        if (!player.m_150109_().m_36054_(itemStack3)) {
                            player.m_36176_(itemStack3, false);
                        }
                        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
                    }
                }
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            BlockState blockState = level.m_8055_(blockPos);
            BlockPos blockPos4 = blockPos3 = blockState.m_60734_() instanceof LiquidBlockContainer && this.content == Fluids.f_76193_ ? blockPos : blockPos2;
            if (this.m_142073_(player, level, blockPos3, blockHitResult)) {
                this.m_142131_(player, level, itemStack, blockPos3);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, blockPos3, itemStack);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19092_((Object)WoodenBucket.getEmptySuccessItem(itemStack, player), (boolean)level.m_5776_());
            }
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public static ItemStack getEmptySuccessItem(ItemStack itemStack, Player player) {
        return !player.m_150110_().f_35937_ ? new ItemStack((ItemLike)ObjectRegistry.WOODEN_BUCKET.get()) : itemStack;
    }

    public boolean m_142073_(@Nullable Player player, Level level, BlockPos blockPos, @Nullable BlockHitResult blockHitResult) {
        boolean bl2;
        if (!(this.content instanceof FlowingFluid)) {
            return false;
        }
        BlockState blockState = level.m_8055_(blockPos);
        Block block = blockState.m_60734_();
        boolean bl = blockState.m_60722_(this.content);
        boolean bl3 = bl2 = blockState.m_60795_() || bl || block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).m_6044_((BlockGetter)level, blockPos, blockState, this.content);
        if (!bl2) {
            return blockHitResult != null && this.m_142073_(player, level, blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_()), null);
        }
        if (level.m_6042_().f_63857_() && this.content.m_205067_(FluidTags.f_13131_)) {
            int i = blockPos.m_123341_();
            int j = blockPos.m_123342_();
            int k = blockPos.m_123343_();
            level.m_5594_(player, blockPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer && this.content == Fluids.f_76193_) {
            ((LiquidBlockContainer)block).m_7361_((LevelAccessor)level, blockPos, blockState, ((FlowingFluid)this.content).m_76068_(false));
            this.playEmptySound(player, (LevelAccessor)level, blockPos);
            return true;
        }
        if (!level.f_46443_ && bl && !blockState.m_278721_()) {
            level.m_46961_(blockPos, true);
        }
        if (!level.m_7731_(blockPos, this.content.m_76145_().m_76188_(), 11) && !blockState.m_60819_().m_76170_()) {
            return false;
        }
        this.playEmptySound(player, (LevelAccessor)level, blockPos);
        return true;
    }

    protected void playEmptySound(@Nullable Player player, LevelAccessor levelAccessor, BlockPos blockPos) {
        SoundEvent soundEvent = this.content.m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
        levelAccessor.m_5594_(player, blockPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        levelAccessor.m_142346_((Entity)player, GameEvent.f_157769_, blockPos);
    }
}

