/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.entity;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.satisfy.meadow.core.entity.WoolySheepVar;
import net.satisfy.meadow.core.registry.EntityTypeRegistry;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.TagRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoolySheepEntity
extends Animal
implements Shearable {
    private static final EntityDataAccessor<Byte> DATA_WOOL_TYPE = SynchedEntityData.m_135353_(WoolySheepEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(WoolySheepEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private EatBlockGoal eatBlockGoal;
    private int eatAnimationTick;

    public WoolySheepEntity(EntityType<? extends Animal> type, Level level) {
        super(type, level);
        this.setWoolType((byte)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, (double)0.23f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_WOOL_TYPE, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public void m_7380_(CompoundTag c) {
        super.m_7380_(c);
        c.m_128379_("Sheared", this.isSheared());
        c.m_128344_("WoolType", this.getWoolType());
        c.m_128405_("Variant", this.getTypeVariant());
    }

    public void m_7378_(CompoundTag c) {
        super.m_7378_(c);
        this.setSheared(c.m_128471_("Sheared"));
        this.setWoolType(c.m_128445_("WoolType"));
        this.setTypeVariant(c.m_128451_("Variant"));
    }

    protected void m_8099_() {
        this.eatBlockGoal = new EatBlockGoal((Mob)this);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)this.eatBlockGoal);
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.m_8107_();
    }

    public void m_8024_() {
        this.eatAnimationTick = this.eatBlockGoal.m_25213_();
        super.m_8024_();
    }

    public void m_8035_() {
        super.m_8035_();
        this.setSheared(false);
    }

    public void m_7822_(byte b) {
        if (b == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.m_7822_(b);
        }
    }

    public float getHeadEatPositionScale(float f) {
        if (this.eatAnimationTick <= 0) {
            return 0.0f;
        }
        if (this.eatAnimationTick >= 4 && this.eatAnimationTick <= 36) {
            return 1.0f;
        }
        return this.eatAnimationTick < 4 ? ((float)this.eatAnimationTick - f) / 4.0f : -((float)(this.eatAnimationTick - 40) - f) / 4.0f;
    }

    public float getHeadEatAngleScale(float f) {
        if (this.eatAnimationTick > 4 && this.eatAnimationTick <= 36) {
            float g = ((float)(this.eatAnimationTick - 4) - f) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.m_14031_((float)(g * 28.7f));
        }
        return this.eatAnimationTick > 0 ? 0.62831855f : this.m_146909_() * ((float)Math.PI / 180);
    }

    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_204117_(TagRegistry.SHEARS)) {
            if (!this.m_9236_().f_46443_ && this.m_6220_()) {
                this.m_5851_(SoundSource.PLAYERS);
                this.m_146852_(GameEvent.f_157781_, (Entity)player);
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    public void m_5851_(SoundSource source) {
        if (!this.m_9236_().f_46443_ && this.m_6220_()) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, source, 1.0f, 1.0f);
            this.setSheared(true);
            WoolySheepVar variant = this.getVariant();
            int count = 1 + this.f_19796_.m_188503_(3);
            for (int i = 0; i < count; ++i) {
                Item woolItem = WoolySheepEntity.getWoolItemByVariant(variant);
                ItemStack woolStack = new ItemStack((ItemLike)woolItem);
                ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), woolStack);
                itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
                this.m_9236_().m_7967_((Entity)itemEntity);
            }
        }
    }

    public static Item getWoolItemByVariant(WoolySheepVar variant) {
        return switch (variant) {
            default -> throw new IncompatibleClassChangeError();
            case WoolySheepVar.FLECKED -> ((Block)ObjectRegistry.FLECKED_WOOL.get()).m_5456_();
            case WoolySheepVar.PATCHED -> ((Block)ObjectRegistry.PATCHED_WOOL.get()).m_5456_();
            case WoolySheepVar.ROCKY -> ((Block)ObjectRegistry.ROCKY_WOOL.get()).m_5456_();
            case WoolySheepVar.INKY -> ((Block)ObjectRegistry.INKY_WOOL.get()).m_5456_();
            case WoolySheepVar.FUZZY -> Items.f_41870_;
            case WoolySheepVar.LONG_NOSED -> ((Block)ObjectRegistry.HIGHLAND_WOOL.get()).m_5456_();
        };
    }

    @Nullable
    public WoolySheepEntity getBreedOffspring(ServerLevel level, AgeableMob mob) {
        WoolySheepEntity sheep = (WoolySheepEntity)((EntityType)EntityTypeRegistry.WOOLY_SHEEP.get()).m_20615_((Level)level);
        if (sheep != null) {
            RandomSource random = level.m_213780_();
            WoolySheepVar var = this.getVariant();
            if (random.m_188499_() && mob instanceof WoolySheepEntity) {
                WoolySheepEntity varSheep = (WoolySheepEntity)mob;
                var = varSheep.getVariant();
            }
            sheep.setVariant(var);
        }
        return sheep;
    }

    @NotNull
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        WoolySheepVar variant;
        if (spawnGroupData instanceof ShearableVarSheepGroupData) {
            ShearableVarSheepGroupData data = (ShearableVarSheepGroupData)((Object)spawnGroupData);
            variant = data.variant;
        } else {
            variant = WoolySheepVar.getRandomVariant((LevelAccessor)levelAccessor, this.m_20183_(), mobSpawnType.equals((Object)MobSpawnType.SPAWN_EGG));
            spawnGroupData = new ShearableVarSheepGroupData(variant);
        }
        this.setVariant(variant);
        return Objects.requireNonNull(super.m_6518_(levelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag));
    }

    public void setVariant(WoolySheepVar variant) {
        this.setTypeVariant(variant.getId() & 0xFF | this.getTypeVariant() & 0xFFFFFF00);
    }

    @NotNull
    public WoolySheepVar getVariant() {
        return WoolySheepVar.byId(this.getTypeVariant() & 0xFF);
    }

    private void setTypeVariant(int i) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)i);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public byte getWoolType() {
        return (byte)((Byte)this.f_19804_.m_135370_(DATA_WOOL_TYPE) & 0xF);
    }

    public void setWoolType(byte woolType) {
        this.f_19804_.m_135381_(DATA_WOOL_TYPE, (Object)woolType);
    }

    public boolean isSheared() {
        return ((Byte)this.f_19804_.m_135370_(DATA_WOOL_TYPE) & 0x10) != 0;
    }

    public void setSheared(boolean bl) {
        byte b = (Byte)this.f_19804_.m_135370_(DATA_WOOL_TYPE);
        if (bl) {
            this.f_19804_.m_135381_(DATA_WOOL_TYPE, (Object)((byte)(b | 0x10)));
        } else {
            this.f_19804_.m_135381_(DATA_WOOL_TYPE, (Object)((byte)(b & 0xFFFFFFEF)));
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12341_;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(SoundEvents.f_12345_, 0.15f, 1.0f);
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return SoundEvents.f_12343_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12342_;
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.isSheared() && !this.m_6162_();
    }

    public static class ShearableVarSheepGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final WoolySheepVar variant;

        public ShearableVarSheepGroupData(WoolySheepVar variant) {
            super(true);
            this.variant = variant;
        }
    }
}

