/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.core.block.LineConnectingBlock;
import net.satisfy.meadow.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class DoormatBlock
extends LineConnectingBlock {
    private static final VoxelShape SHAPE_MIDDLE = Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0);
    private static final VoxelShape SHAPE_SINGLE = Block.m_49796_((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)1.0, (double)13.0);
    private static final VoxelShape SHAPE_RIGHT = Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)15.0, (double)1.0, (double)13.0);
    private static final VoxelShape SHAPE_LEFT = Block.m_49796_((double)1.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0);
    private static final Map<Direction, Map<GeneralUtil.LineConnectingType, VoxelShape>> SHAPES = new EnumMap<Direction, Map<GeneralUtil.LineConnectingType, VoxelShape>>(Direction.class);

    public DoormatBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        GeneralUtil.LineConnectingType type = (GeneralUtil.LineConnectingType)((Object)state.m_61143_((Property)TYPE));
        return SHAPES.get(facing).get((Object)type);
    }

    static {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            EnumMap<GeneralUtil.LineConnectingType, VoxelShape> shapesForDirection = new EnumMap<GeneralUtil.LineConnectingType, VoxelShape>(GeneralUtil.LineConnectingType.class);
            shapesForDirection.put(GeneralUtil.LineConnectingType.MIDDLE, GeneralUtil.rotateShape(Direction.NORTH, direction, SHAPE_MIDDLE));
            shapesForDirection.put(GeneralUtil.LineConnectingType.LEFT, GeneralUtil.rotateShape(Direction.NORTH, direction, SHAPE_LEFT));
            shapesForDirection.put(GeneralUtil.LineConnectingType.RIGHT, GeneralUtil.rotateShape(Direction.NORTH, direction, SHAPE_RIGHT));
            shapesForDirection.put(GeneralUtil.LineConnectingType.NONE, GeneralUtil.rotateShape(Direction.NORTH, direction, SHAPE_SINGLE));
            SHAPES.put(direction, shapesForDirection);
        }
    }
}

