/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.kube;

import com.almostreliable.lootjs.LootJS;
import com.almostreliable.lootjs.core.LootEntry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;

public class LootEntryWrapper {
    public static LootEntry of(Object o) {
        CharSequence cs;
        String string;
        if (o instanceof LootEntry) {
            LootEntry entry = (LootEntry)o;
            return entry;
        }
        if (o instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)o;
            return new LootEntry(new LootEntry.RandomIngredientGenerator(ingredient));
        }
        if (o instanceof CharSequence && ((string = (cs = (CharSequence)o).toString()).startsWith("#") || string.startsWith("@"))) {
            return LootEntryWrapper.of(IngredientJS.of((Object)string));
        }
        OutputItem outputItem = OutputItem.of((Object)o);
        int weight = Double.isNaN(outputItem.getChance()) ? 1 : (int)outputItem.getChance();
        return new LootEntry(outputItem.item).withWeight(weight);
    }

    public static LootEntry of(ItemStack in, int count) {
        return LootEntryWrapper.of(in.kjs$withCount(count));
    }

    public static LootEntry of(ItemStack in, CompoundTag nbt) {
        return LootEntryWrapper.of(in.kjs$withNBT(nbt));
    }

    public static LootEntry of(ItemStack in, int count, CompoundTag nbt) {
        return LootEntryWrapper.of(in.kjs$withCount(count).kjs$withNBT(nbt));
    }

    public static LootEntry ofJson(JsonObject json) {
        try {
            LootPoolEntryContainer container = (LootPoolEntryContainer)LootJS.FUNCTION_GSON.fromJson((JsonElement)json, LootPoolEntryContainer.class);
            return new LootEntry(new LootEntry.VanillaWrappedLootEntry(container));
        }
        catch (Exception e) {
            LootJS.LOG.error("Failed to parse loot entry: " + String.valueOf(json));
            return new LootEntry(ItemStack.f_41583_);
        }
    }

    public static LootEntry withChance(Object o, int chance) {
        return LootEntryWrapper.of(o).withChance(chance);
    }
}

