/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.property.PropertyBoolean;
import brentmaas.buildguide.common.property.PropertyEnum;
import brentmaas.buildguide.common.property.PropertyMinimumInt;
import brentmaas.buildguide.common.property.PropertyNonzeroInt;
import brentmaas.buildguide.common.property.PropertyPositiveFloat;
import brentmaas.buildguide.common.screen.AbstractScreenHandler;
import brentmaas.buildguide.common.shape.IShapeBuffer;
import brentmaas.buildguide.common.shape.Shape;

public class ShapePolygon
extends Shape {
    private String[] directionNames = new String[]{"X", "Y", "Z"};
    private String[] rotationNames = new String[]{"0\u00b0", "90\u00b0", "180\u00b0", "270\u00b0"};
    private static final int[] rotXX = new int[]{1, 0, -1, 0};
    private static final int[] rotXY = new int[]{0, -1, 0, 1};
    private static final int[] rotYX = new int[]{0, 1, 0, -1};
    private PropertyMinimumInt propertySides = new PropertyMinimumInt(3, new AbstractScreenHandler.Translatable("property.buildguide.sides", new Object[0]), () -> this.update(), 3);
    private PropertyPositiveFloat propertyRadius = new PropertyPositiveFloat(3.0f, new AbstractScreenHandler.Translatable("property.buildguide.radius", new Object[0]), () -> this.update());
    private PropertyEnum<direction> propertyDir = new PropertyEnum<direction>(direction.X, new AbstractScreenHandler.Translatable("property.buildguide.direction", new Object[0]), () -> this.update(), this.directionNames);
    private PropertyEnum<rotation> propertyRot = new PropertyEnum<rotation>(rotation.ROT0, new AbstractScreenHandler.Translatable("property.buildguide.rotation", new Object[0]), () -> this.update(), this.rotationNames);
    private PropertyNonzeroInt propertyDepth = new PropertyNonzeroInt(1, new AbstractScreenHandler.Translatable("property.buildguide.depth", new Object[0]), () -> this.update());
    private PropertyBoolean propertyEvenMode = new PropertyBoolean(false, new AbstractScreenHandler.Translatable("property.buildguide.evenmode", new Object[0]), () -> this.update());

    public ShapePolygon() {
        this.properties.add(this.propertySides);
        this.properties.add(this.propertyRadius);
        this.properties.add(this.propertyDir);
        this.properties.add(this.propertyRot);
        this.properties.add(this.propertyDepth);
        this.properties.add(this.propertyEvenMode);
    }

    @Override
    protected void updateShape(IShapeBuffer buffer) throws InterruptedException {
        int n = (Integer)this.propertySides.value;
        float r = ((Float)this.propertyRadius.value).floatValue();
        int rot = ((rotation)((Object)this.propertyRot.value)).ordinal();
        double offset = (Boolean)this.propertyEvenMode.value != false ? 0.5 : 0.0;
        switch (((direction)((Object)this.propertyDir.value)).ordinal()) {
            case 0: {
                this.setOriginOffset(0.0, offset, offset);
                break;
            }
            case 1: {
                this.setOriginOffset(offset, 0.0, offset);
                break;
            }
            case 2: {
                this.setOriginOffset(offset, offset, 0.0);
            }
        }
        int maxR = (int)Math.ceil(((double)r + offset) / Math.cos(Math.PI / (double)n));
        for (int a = -maxR; a <= maxR; ++a) {
            for (int b = -maxR; b <= maxR; ++b) {
                int i;
                double dr;
                double theta = Math.atan2((double)b - offset, (double)a - offset) + Math.PI;
                if (theta < 0.0) {
                    theta += Math.PI * 2;
                }
                if (!((dr = ((double)a - offset) * Math.cos((double)(2 * (i = (int)((double)n * theta / 2.0 / Math.PI + 0.5))) * Math.PI / (double)n - Math.PI) + ((double)b - offset) * Math.sin((double)(2 * i) * Math.PI / (double)n - Math.PI) - (double)r + 1.0E-10) >= -0.5) || !(dr < 0.5)) continue;
                block12: for (int h = (Integer)this.propertyDepth.value > 0 ? 0 : (Integer)this.propertyDepth.value + 1; h < ((Integer)this.propertyDepth.value > 0 ? (Integer)this.propertyDepth.value : 1); ++h) {
                    switch (((direction)((Object)this.propertyDir.value)).ordinal()) {
                        case 0: {
                            this.addShapeCube(buffer, h, a * rotXX[rot] + b * rotYX[rot], b * rotXX[rot] + a * rotXY[rot]);
                            continue block12;
                        }
                        case 1: {
                            this.addShapeCube(buffer, a * rotXX[rot] + b * rotYX[rot], h, b * rotXX[rot] + a * rotXY[rot]);
                            continue block12;
                        }
                        case 2: {
                            this.addShapeCube(buffer, b * rotXX[rot] + a * rotXY[rot], a * rotXX[rot] + b * rotYX[rot], h);
                        }
                    }
                }
            }
        }
    }

    private static enum direction {
        X,
        Y,
        Z;

    }

    private static enum rotation {
        ROT0,
        ROT90,
        ROT180,
        ROT270;

    }
}

