/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.property.PropertyBoolean;
import brentmaas.buildguide.common.property.PropertyEnum;
import brentmaas.buildguide.common.property.PropertyNonzeroInt;
import brentmaas.buildguide.common.property.PropertyPositiveFloat;
import brentmaas.buildguide.common.screen.AbstractScreenHandler;
import brentmaas.buildguide.common.shape.IShapeBuffer;
import brentmaas.buildguide.common.shape.Shape;

public class ShapeParabola
extends Shape {
    private static final int[] rotXX = new int[]{1, 0, -1, 0};
    private static final int[] rotXY = new int[]{0, -1, 0, 1};
    private static final int[] rotYX = new int[]{0, 1, 0, -1};
    private String[] directionNames = new String[]{"X", "Y", "Z"};
    private String[] rotationNames = new String[]{"0\u00b0", "90\u00b0", "180\u00b0", "270\u00b0"};
    private PropertyEnum<direction> propertyDir = new PropertyEnum<direction>(direction.X, new AbstractScreenHandler.Translatable("property.buildguide.direction", new Object[0]), () -> this.update(), this.directionNames);
    private PropertyEnum<rotation> propertyRot = new PropertyEnum<rotation>(rotation.ROT0, new AbstractScreenHandler.Translatable("property.buildguide.rotation", new Object[0]), () -> this.update(), this.rotationNames);
    private PropertyPositiveFloat propertyHalfwidth = new PropertyPositiveFloat(3.0f, new AbstractScreenHandler.Translatable("property.buildguide.halfwidth", new Object[0]), () -> this.update());
    private PropertyPositiveFloat propertyHeight = new PropertyPositiveFloat(3.0f, new AbstractScreenHandler.Translatable("property.buildguide.height", new Object[0]), () -> this.update());
    private PropertyNonzeroInt propertyDepth = new PropertyNonzeroInt(1, new AbstractScreenHandler.Translatable("property.buildguide.depth", new Object[0]), () -> this.update());
    private PropertyBoolean propertyEvenMode = new PropertyBoolean(false, new AbstractScreenHandler.Translatable("property.buildguide.evenmode", new Object[0]), () -> this.update());

    public ShapeParabola() {
        this.properties.add(this.propertyDir);
        this.properties.add(this.propertyRot);
        this.properties.add(this.propertyHalfwidth);
        this.properties.add(this.propertyHeight);
        this.properties.add(this.propertyDepth);
        this.properties.add(this.propertyEvenMode);
    }

    @Override
    protected void updateShape(IShapeBuffer buffer) throws InterruptedException {
        float hw = ((Float)this.propertyHalfwidth.value).floatValue();
        float h = ((Float)this.propertyHeight.value).floatValue();
        double fac = (double)h / (double)hw / (double)hw;
        int rot = ((rotation)((Object)this.propertyRot.value)).ordinal();
        double offset = (Boolean)this.propertyEvenMode.value != false ? 0.5 : 0.0;
        switch (((direction)((Object)this.propertyDir.value)).ordinal()) {
            case 0: {
                this.setOriginOffset(0.0, offset * (double)rotYX[rot], offset * (double)rotXX[rot]);
                break;
            }
            case 1: {
                this.setOriginOffset(offset * (double)rotYX[rot], 0.0, offset * (double)rotXX[rot]);
                break;
            }
            case 2: {
                this.setOriginOffset(offset * (double)rotXX[rot], offset * (double)rotYX[rot], 0.0);
            }
        }
        for (int a = (int)Math.floor((double)(-hw) + offset); a <= (int)Math.ceil((double)hw + offset); ++a) {
            int b = 0;
            while ((float)b < h) {
                if (fac * ((double)a - offset) * ((double)a - offset) >= (double)b && (fac * ((double)a - offset - Math.signum((double)a - offset)) * ((double)a - offset - Math.signum((double)a - offset)) < (double)b || fac * ((double)a - offset) * ((double)a - offset) < (double)(b + 1))) {
                    block12: for (int s = (Integer)this.propertyDepth.value > 0 ? 0 : (Integer)this.propertyDepth.value + 1; s < ((Integer)this.propertyDepth.value > 0 ? (Integer)this.propertyDepth.value : 1); ++s) {
                        switch (((direction)((Object)this.propertyDir.value)).ordinal()) {
                            case 0: {
                                this.addShapeCube(buffer, s, b * rotXX[rot] + a * rotYX[rot], a * rotXX[rot] + b * rotXY[rot]);
                                continue block12;
                            }
                            case 1: {
                                this.addShapeCube(buffer, b * rotXX[rot] + a * rotYX[rot], s, a * rotXX[rot] + b * rotXY[rot]);
                                continue block12;
                            }
                            case 2: {
                                this.addShapeCube(buffer, a * rotXX[rot] + b * rotXY[rot], b * rotXX[rot] + a * rotYX[rot], s);
                            }
                        }
                    }
                }
                ++b;
            }
        }
    }

    private static enum direction {
        X,
        Y,
        Z;

    }

    private static enum rotation {
        ROT0,
        ROT90,
        ROT180,
        ROT270;

    }
}

