/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.property.PropertyBoolean;
import brentmaas.buildguide.common.property.PropertyEnum;
import brentmaas.buildguide.common.property.PropertyNonzeroInt;
import brentmaas.buildguide.common.screen.AbstractScreenHandler;
import brentmaas.buildguide.common.shape.IShapeBuffer;
import brentmaas.buildguide.common.shape.Shape;

public class ShapeCuboid
extends Shape {
    private String[] wallsNames = new String[]{"XYZ", "X", "Y", "Z", "XY", "XZ", "YZ", "-"};
    private PropertyNonzeroInt propertyX = new PropertyNonzeroInt(3, new AbstractScreenHandler.Translatable("X", new Object[0]), () -> this.update());
    private PropertyNonzeroInt propertyY = new PropertyNonzeroInt(3, new AbstractScreenHandler.Translatable("Y", new Object[0]), () -> this.update());
    private PropertyNonzeroInt propertyZ = new PropertyNonzeroInt(3, new AbstractScreenHandler.Translatable("Z", new Object[0]), () -> this.update());
    private PropertyEnum<walls> propertyWalls = new PropertyEnum<walls>(walls.ALL, new AbstractScreenHandler.Translatable("property.buildguide.walls", new Object[0]), () -> this.update(), this.wallsNames);
    private PropertyBoolean propertyCentredOrigin = new PropertyBoolean(false, new AbstractScreenHandler.Translatable("property.buildguide.centredorigin", new Object[0]), () -> this.update());

    public ShapeCuboid() {
        this.properties.add(this.propertyX);
        this.properties.add(this.propertyY);
        this.properties.add(this.propertyZ);
        this.properties.add(this.propertyWalls);
        this.properties.add(this.propertyCentredOrigin);
    }

    @Override
    protected void updateShape(IShapeBuffer buffer) throws InterruptedException {
        int z;
        int y;
        int x;
        int upperZ;
        int upperY;
        int upperX;
        int lowerZ;
        int lowerY;
        int lowerX;
        int dx = (Integer)this.propertyX.value;
        int dy = (Integer)this.propertyY.value;
        int dz = (Integer)this.propertyZ.value;
        walls w = (walls)((Object)this.propertyWalls.value);
        boolean centredOrigin = (Boolean)this.propertyCentredOrigin.value;
        if (centredOrigin) {
            lowerX = -Math.abs(dx) + 1;
            lowerY = -Math.abs(dy) + 1;
            lowerZ = -Math.abs(dz) + 1;
            upperX = Math.abs(dx);
            upperY = Math.abs(dy);
            upperZ = Math.abs(dz);
        } else {
            lowerX = dx > 0 ? 0 : dx + 1;
            lowerY = dy > 0 ? 0 : dy + 1;
            lowerZ = dz > 0 ? 0 : dz + 1;
            upperX = dx > 0 ? dx : 1;
            upperY = dy > 0 ? dy : 1;
            upperZ = dz > 0 ? dz : 1;
        }
        for (x = lowerX; x < upperX; ++x) {
            this.addShapeCube(buffer, x, lowerY, lowerZ);
            if (upperY - lowerY > 1) {
                this.addShapeCube(buffer, x, upperY - 1, lowerZ);
            }
            if (upperZ - lowerZ > 1) {
                this.addShapeCube(buffer, x, lowerY, upperZ - 1);
            }
            if (upperY - lowerY <= 1 || upperZ - lowerZ <= 1) continue;
            this.addShapeCube(buffer, x, upperY - 1, upperZ - 1);
        }
        for (y = lowerY + 1; y < upperY - 1; ++y) {
            this.addShapeCube(buffer, lowerX, y, lowerZ);
            if (upperX - lowerX > 1) {
                this.addShapeCube(buffer, upperX - 1, y, lowerZ);
            }
            if (upperZ - lowerZ > 1) {
                this.addShapeCube(buffer, lowerX, y, upperZ - 1);
            }
            if (upperX - lowerX <= 1 || upperZ - lowerZ <= 1) continue;
            this.addShapeCube(buffer, upperX - 1, y, upperZ - 1);
        }
        for (int z2 = lowerZ + 1; z2 < upperZ - 1; ++z2) {
            this.addShapeCube(buffer, lowerX, lowerY, z2);
            if (upperX - lowerX > 1) {
                this.addShapeCube(buffer, upperX - 1, lowerY, z2);
            }
            if (upperY - lowerY > 1) {
                this.addShapeCube(buffer, lowerX, upperY - 1, z2);
            }
            if (upperX - lowerX <= 1 || upperY - lowerY <= 1) continue;
            this.addShapeCube(buffer, upperX - 1, upperY - 1, z2);
        }
        if (w == walls.ALL || w == walls.X || w == walls.XY || w == walls.XZ) {
            for (y = lowerY + 1; y < upperY - 1; ++y) {
                for (z = lowerZ + 1; z < upperZ - 1; ++z) {
                    this.addShapeCube(buffer, lowerX, y, z);
                    if (upperX - lowerX <= 1) continue;
                    this.addShapeCube(buffer, upperX - 1, y, z);
                }
            }
        }
        if (w == walls.ALL || w == walls.Y || w == walls.XY || w == walls.YZ) {
            for (x = lowerX + 1; x < upperX - 1; ++x) {
                for (z = lowerZ + 1; z < upperZ - 1; ++z) {
                    this.addShapeCube(buffer, x, lowerY, z);
                    if (upperY - lowerY <= 1) continue;
                    this.addShapeCube(buffer, x, upperY - 1, z);
                }
            }
        }
        if (w == walls.ALL || w == walls.Z || w == walls.XZ || w == walls.YZ) {
            for (x = lowerX + 1; x < upperX - 1; ++x) {
                for (int y2 = lowerY + 1; y2 < upperY - 1; ++y2) {
                    this.addShapeCube(buffer, x, y2, lowerZ);
                    if (upperZ - lowerZ <= 1) continue;
                    this.addShapeCube(buffer, x, y2, upperZ - 1);
                }
            }
        }
    }

    private static enum walls {
        ALL,
        X,
        Y,
        Z,
        XY,
        XZ,
        YZ,
        NONE;

    }
}

