/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.property.PropertyBoolean;
import brentmaas.buildguide.common.property.PropertyInt;
import brentmaas.buildguide.common.property.PropertyPositiveFloat;
import brentmaas.buildguide.common.property.PropertyRunnable;
import brentmaas.buildguide.common.screen.AbstractScreenHandler;
import brentmaas.buildguide.common.shape.IShapeBuffer;
import brentmaas.buildguide.common.shape.Shape;
import brentmaas.buildguide.common.shape.ShapeSet;

public class ShapeCatenary
extends Shape {
    private static final double eps = 0.001;
    private PropertyInt propertyDx = new PropertyInt(3, new AbstractScreenHandler.Translatable("property.buildguide.delta", "X"), () -> this.update());
    private PropertyInt propertyDy = new PropertyInt(0, new AbstractScreenHandler.Translatable("property.buildguide.delta", "Y"), () -> this.update());
    private PropertyInt propertyDz = new PropertyInt(0, new AbstractScreenHandler.Translatable("property.buildguide.delta", "Z"), () -> this.update());
    private PropertyRunnable propertySetEndpoint = new PropertyRunnable(() -> {
        ShapeSet.Origin pos = BuildGuide.shapeHandler.getPlayerPosition();
        this.propertyDx.setValue(pos.x - this.shapeSet.getOriginX());
        this.propertyDy.setValue(pos.y - this.shapeSet.getOriginY());
        this.propertyDz.setValue(pos.z - this.shapeSet.getOriginZ());
        this.update();
    }, new AbstractScreenHandler.Translatable("property.buildguide.setendpoint", new Object[0]));
    private PropertyPositiveFloat propertyAddLength = new PropertyPositiveFloat(1.0f, new AbstractScreenHandler.Translatable("property.buildguide.addlength", new Object[0]), () -> this.update());
    private PropertyBoolean propertyInvert = new PropertyBoolean(false, new AbstractScreenHandler.Translatable("property.buildguide.invert", new Object[0]), () -> this.update());

    public ShapeCatenary() {
        this.properties.add(this.propertyDx);
        this.properties.add(this.propertyDy);
        this.properties.add(this.propertyDz);
        this.properties.add(this.propertySetEndpoint);
        this.properties.add(this.propertyAddLength);
        this.properties.add(this.propertyInvert);
    }

    @Override
    protected void updateShape(IShapeBuffer buffer) throws Exception {
        double dr = Math.sqrt((Integer)this.propertyDx.value * (Integer)this.propertyDx.value + (Integer)this.propertyDz.value * (Integer)this.propertyDz.value);
        int dy = (Integer)this.propertyDy.value;
        float ds = ((Float)this.propertyAddLength.value).floatValue();
        boolean inv = (Boolean)this.propertyInvert.value;
        if (dr >= 1.0) {
            double chi;
            double s = Math.sqrt(dr * dr + (double)(dy * dy)) + (double)ds;
            double a = 1.0;
            while (true) {
                double d;
                chi = 2.0 * a * Math.sinh(dr / 2.0 / a) - Math.sqrt(s * s - (double)(dy * dy));
                if (!(Math.abs(d) > 0.001)) break;
                double dchi = 2.0 * Math.sinh(dr / 2.0 / a) - dr / a * Math.cosh(dr / 2.0 / a);
                a = Math.max(a - chi / dchi, a / 2.0);
            }
            if (!Double.isFinite(a)) {
                throw new IllegalStateException(BuildGuide.screenHandler.translate("error.buildguide.invalidvalue"));
            }
            double rl = 0.0;
            while (true) {
                double d;
                chi = a * Math.cosh(rl / a) + (double)dy - a * Math.cosh((rl + dr) / a);
                if (!(Math.abs(d) > 0.001)) break;
                double dchi = Math.sinh(rl / a) - Math.sinh((rl + dr) / a);
                rl -= chi / dchi;
            }
            int d = Math.max(Math.abs((Integer)this.propertyDx.value), Math.abs((Integer)this.propertyDz.value));
            double dx = (double)((Integer)this.propertyDx.value).intValue() / (double)d;
            double dz = (double)((Integer)this.propertyDz.value).intValue() / (double)d;
            double fac = Math.sqrt(dx * dx + dz * dz);
            int h = (int)((double)Math.min(0, dy) - a * Math.cosh(rl / a));
            for (int i = 0; i <= d; ++i) {
                for (int j = h; j <= Math.max(0, dy); ++j) {
                    if (i == 0 && j > 0 || i == d && j > dy || !(a * Math.cosh(((double)i * fac + rl) / a) - a * Math.cosh(rl / a) >= (double)j - 0.5 && a * Math.cosh(((double)i * fac + rl) / a) - a * Math.cosh(rl / a) < (double)j + 0.5 || a * Math.cosh((((double)i - 0.5) * fac + rl) / a) - a * Math.cosh(rl / a) >= (double)j && a * Math.cosh((((double)i + 0.5) * fac + rl) / a) - a * Math.cosh(rl / a) < (double)j) && (!(a * Math.cosh((((double)i + 0.5) * fac + rl) / a) - a * Math.cosh(rl / a) >= (double)j) || !(a * Math.cosh((((double)i - 0.5) * fac + rl) / a) - a * Math.cosh(rl / a) < (double)j))) continue;
                    this.addShapeCube(buffer, inv ? (int)(dx * (double)(d - i) + Math.signum(dx) * 0.5) : (int)(dx * (double)i + Math.signum(dx) * 0.5), inv ? dy - j : j, inv ? (int)(dz * (double)(d - i) + Math.signum(dz) * 0.5) : (int)(dz * (double)i + Math.signum(dz) * 0.5));
                }
            }
        } else {
            for (int i = (int)((double)(-ds / 2.0f) - 0.5 + (double)(dy >= 0 ? 0 : dy)); i <= (dy >= 0 ? dy : 0); ++i) {
                this.addShapeCube(buffer, 0, i, 0);
            }
        }
    }
}

