/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.State;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public abstract class AbstractStateManager {
    private static final String PERSISTENCE_EXTENSION = ".dat";
    private HashMap<String, State> stateStore = new HashMap();
    private File persistenceFolder;

    public AbstractStateManager(File gameDirectory) {
        this.persistenceFolder = new File(gameDirectory, "buildguide");
        if (!this.persistenceFolder.exists() || !this.persistenceFolder.isDirectory()) {
            this.persistenceFolder.mkdir();
        }
    }

    private String getKey() {
        String host = this.getWorldName();
        if (host == null) {
            host = this.getServerAddress();
        }
        if (host == null) {
            host = "unknown";
        }
        return host + "@" + this.getDimensionKey();
    }

    public boolean isStatePresent(String key) {
        return this.stateStore.containsKey(key);
    }

    public boolean isStatePresent() {
        return this.isStatePresent(this.getKey());
    }

    public State getState() {
        String key = this.getKey();
        if (!this.isStatePresent(key)) {
            this.stateStore.put(key, new State());
            File persistenceFile = this.getPersistenceFile(key);
            if (((Boolean)BuildGuide.config.persistenceEnabled.value).booleanValue() && persistenceFile.exists()) {
                try {
                    this.stateStore.get(key).loadPersistence(persistenceFile);
                }
                catch (IOException e) {
                    BuildGuide.logHandler.sendChatMessage("Build Guide persistence failed to load: " + e.getMessage());
                    BuildGuide.logHandler.error(e.getMessage() + "\n" + String.valueOf(e.getStackTrace()));
                }
            }
        }
        return this.stateStore.get(key);
    }

    private File getPersistenceFile(String key) {
        String safeKey = key.replace("/", ".").replace("<", ".").replace(">", ".").replace(":", ".").replace("\"", ".").replace("\\", ".").replace("|", ".").replace("?", ".").replace("*", ".");
        return new File(this.persistenceFolder, safeKey + PERSISTENCE_EXTENSION);
    }

    public void savePersistence() throws IOException {
        String key = this.getKey();
        this.stateStore.get(key).savePersistence(this.getPersistenceFile(key));
    }

    protected abstract String getWorldName();

    protected abstract String getServerAddress();

    protected abstract String getDimensionKey();
}

