/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.bridge_maker.elements.blocks.bridge_maker;

import de.geheimagentnr1.bridge_maker.elements.blocks.ModBlocksRegisterFactory;
import de.geheimagentnr1.bridge_maker.elements.blocks.bridge_maker.BridgeMakerMenu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BridgeMakerEntity
extends BaseContainerBlockEntity {
    private static final int CONTAINER_SIZE = 27;
    @NotNull
    private final NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    @NotNull
    private final List<BlockState> blockStates = new ArrayList<BlockState>(Arrays.asList(new BlockState[27]));
    @NotNull
    private boolean[] setBlocks = new boolean[27];

    public BridgeMakerEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super(ModBlocksRegisterFactory.BRIDGE_MAKER_ENTITY, pos, state);
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)Util.m_137492_((String)"container", (ResourceLocation)BuiltInRegistries.f_256975_.m_7981_((Object)ModBlocksRegisterFactory.BRIDGE_MAKER)));
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int containerId, @NotNull Inventory inventory) {
        return new BridgeMakerMenu(containerId, inventory, (Container)this);
    }

    public int m_6643_() {
        return 27;
    }

    public int m_6893_() {
        return 1;
    }

    public boolean m_7983_() {
        return this.itemStacks.stream().allMatch(ItemStack::m_41619_);
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        return (ItemStack)this.itemStacks.get(index);
    }

    @NotNull
    BlockState getBlockStateForSlot(int index) {
        return this.blockStates.get(index) == null || this.blockStates.get(index).m_60734_() != ((BlockItem)((ItemStack)this.itemStacks.get(index)).m_41720_()).m_40614_() ? ((BlockItem)((ItemStack)this.itemStacks.get(index)).m_41720_()).m_40614_().m_49966_() : this.blockStates.get(index);
    }

    boolean[] getSetBlocks() {
        return this.setBlocks;
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        ItemStack stack = ContainerHelper.m_18969_(this.itemStacks, (int)index, (int)count);
        if (!stack.m_41619_()) {
            this.blockStates.set(index, null);
            this.m_6596_();
        }
        return stack;
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        this.blockStates.set(index, null);
        return ContainerHelper.m_18966_(this.itemStacks, (int)index);
    }

    public void m_6836_(int index, @NotNull ItemStack stack) {
        this.itemStacks.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    void setItem(int index, @NotNull ItemStack stack, BlockState state) {
        this.blockStates.set(index, state);
        this.m_6836_(index, stack);
    }

    void setSetBocksArray(@NotNull boolean[] _setBlocks) {
        this.setBlocks = _setBlocks;
        this.m_6596_();
    }

    public boolean m_6542_(@NotNull Player player) {
        if (Objects.requireNonNull(this.f_58857_).m_7702_(this.f_58858_) == this) {
            return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
        }
        return false;
    }

    public void m_6211_() {
        this.itemStacks.clear();
        this.blockStates.clear();
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        ListTag blockStatesNbt;
        super.m_142466_(nbt);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.itemStacks);
        byte[] setBlocksByte = nbt.m_128463_("setBlocks");
        if (setBlocksByte.length == this.setBlocks.length) {
            for (int i = 0; i < this.setBlocks.length; ++i) {
                this.setBlocks[i] = setBlocksByte[i] == 1;
            }
        }
        if ((blockStatesNbt = (ListTag)nbt.m_128423_("blockStates")) != null) {
            for (Tag blockStatesElementNbt : blockStatesNbt) {
                if (blockStatesElementNbt.m_7060_() != 10) continue;
                CompoundTag blockStateNbt = (CompoundTag)blockStatesElementNbt;
                byte index = blockStateNbt.m_128445_("Index");
                this.blockStates.set(index, NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)blockStateNbt));
            }
        }
    }

    public void m_183515_(@NotNull CompoundTag nbt) {
        ContainerHelper.m_18976_((CompoundTag)nbt, this.itemStacks, (boolean)false);
        byte[] setBlocksByte = new byte[this.setBlocks.length];
        for (int i = 0; i < this.setBlocks.length; ++i) {
            setBlocksByte[i] = (byte)(this.setBlocks[i] ? 1 : 0);
        }
        nbt.m_128382_("setBlocks", setBlocksByte);
        ListTag blockStatesNbt = new ListTag();
        for (int i = 0; i < this.blockStates.size(); ++i) {
            if (this.blockStates.get(i) == null) continue;
            CompoundTag blockStateNbt = NbtUtils.m_129202_((BlockState)this.blockStates.get(i));
            blockStateNbt.m_128344_("Index", (byte)i);
            blockStatesNbt.add((Object)blockStateNbt);
        }
        nbt.m_128365_("blockStates", (Tag)blockStatesNbt);
    }
}

