/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.bridge_maker.elements.blocks.bridge_maker;

import de.geheimagentnr1.bridge_maker.elements.blocks.bridge_maker.BridgeMakerEntity;
import de.geheimagentnr1.minecraft_forge_api.elements.blocks.BlockItemInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class BridgeMaker
extends BaseEntityBlock
implements BlockItemInterface {
    @NotNull
    public static final String registry_name = "bridge_maker";

    public BridgeMaker() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56743_));
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new BridgeMakerEntity(pos, state);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult blockHitResult) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_5833_()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BridgeMakerEntity) {
            BridgeMakerEntity bridgeMakerEntity = (BridgeMakerEntity)blockEntity;
            player.m_5893_((MenuProvider)bridgeMakerEntity);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)context.m_7820_().m_122424_());
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block neighbarBlock, @NotNull BlockPos neighborPos, boolean isMoving) {
        if (!level.m_5776_()) {
            boolean isPowered;
            boolean bl = isPowered = level.m_277086_(pos) > 0;
            if (isPowered != (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(isPowered)), 3);
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof BridgeMakerEntity) {
                    BridgeMakerEntity bridgeMakerEntity = (BridgeMakerEntity)blockEntity;
                    bridgeMakerEntity.setSetBocksArray(isPowered ? this.power(bridgeMakerEntity, state, pos, level) : this.unpower(bridgeMakerEntity, bridgeMakerEntity.getSetBlocks(), state, pos, level));
                }
            }
        }
    }

    private boolean[] power(@NotNull BridgeMakerEntity bridgeMakerEntity, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull Level level) {
        boolean[] setBlocks = new boolean[bridgeMakerEntity.m_6643_()];
        ArrayList<Block> replacableBlocks = new ArrayList<Block>(Arrays.asList(Blocks.f_50016_, Blocks.f_49991_, Blocks.f_49990_));
        BlockPos nextPos = pos;
        for (int i = 0; i < bridgeMakerEntity.m_6643_(); ++i) {
            setBlocks[i] = false;
            if (!replacableBlocks.contains(level.m_8055_(nextPos = nextPos.m_121945_((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_))).m_60734_()) || bridgeMakerEntity.m_8020_(i).m_41619_()) continue;
            level.m_7731_(nextPos, bridgeMakerEntity.getBlockStateForSlot(i), 3);
            BlockItem.m_40582_((Level)level, null, (BlockPos)nextPos, (ItemStack)bridgeMakerEntity.m_8020_(i));
            bridgeMakerEntity.setItem(i, ItemStack.f_41583_, null);
            setBlocks[i] = true;
        }
        return setBlocks;
    }

    private boolean[] unpower(@NotNull BridgeMakerEntity bridgeMakerEntity, boolean[] setBlocks, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull Level level) {
        int i;
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        int containerSize = bridgeMakerEntity.m_6643_();
        BlockState[] blockStates = new BlockState[containerSize];
        BlockPos nextPos = pos;
        BlockPos collectPos = pos;
        for (i = 0; i < containerSize; ++i) {
            nextPos = nextPos.m_121945_(facing);
            if (!setBlocks[i] || !bridgeMakerEntity.m_8020_(i).m_41619_()) continue;
            blockStates[i] = level.m_8055_(nextPos);
        }
        for (i = 0; i < containerSize; ++i) {
            if (level.m_8055_(collectPos = collectPos.m_121945_(facing)) == Blocks.f_50016_.m_49966_()) {
                blockStates[i] = null;
                continue;
            }
            if (!setBlocks[i] || !bridgeMakerEntity.m_8020_(i).m_41619_()) continue;
            ItemStack blockItemStack = null;
            List blockDrops = BridgeMaker.m_49869_((BlockState)blockStates[i], (ServerLevel)((ServerLevel)level), (BlockPos)collectPos, (BlockEntity)level.m_7702_(collectPos));
            for (ItemStack drop : blockDrops) {
                if (!(drop.m_41720_() instanceof BlockItem) || ((BlockItem)drop.m_41720_()).m_40614_() != blockStates[i].m_60734_()) continue;
                blockItemStack = drop;
                break;
            }
            if (blockItemStack == null) {
                blockItemStack = new ItemStack((ItemLike)blockStates[i].m_60734_().m_5456_());
            }
            if (blockItemStack.m_41720_() instanceof BlockItem) {
                bridgeMakerEntity.setItem(i, blockItemStack, blockStates[i]);
                level.m_7731_(collectPos, Blocks.f_50016_.m_49966_(), 3);
            }
            setBlocks[i] = false;
        }
        return setBlocks;
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_, BlockStateProperties.f_61448_});
    }
}

