/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.structures;

import com.minecolonies.api.util.Log;
import com.minecolonies.core.structures.MineColoniesStructures;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class EmptyColonyStructure
extends Structure {
    public static final Codec<EmptyColonyStructure> COLONY_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EmptyColonyStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)10).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.BOOL.optionalFieldOf("allow_cave", (Object)false).forGetter(structure -> structure.allowCave)).apply((Applicative)instance, EmptyColonyStructure::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private boolean allowCave;

    public EmptyColonyStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, boolean allowCave) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.allowCave = allowCave;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)MineColoniesStructures.EMPTY_COLONY.get();
    }

    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    private static boolean isFeatureChunk(Structure.GenerationContext context) {
        BlockPos blockPos = context.f_226628_().m_45615_();
        int landHeight = context.f_226622_().m_223235_(blockPos.m_123341_(), blockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
        NoiseColumn columnOfBlocks = context.f_226622_().m_214184_(blockPos.m_123341_(), blockPos.m_123343_(), context.f_226629_(), context.f_226624_());
        BlockState topBlock = columnOfBlocks.m_183556_(landHeight);
        return topBlock.m_60819_().m_76178_() && landHeight < 200;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        if (this.allowCave) {
            BlockPos.MutableBlockPos result = EmptyColonyStructure.isFeatureChunkCave(context);
            if (result != null) {
                Optional structurePiecesGenerator = JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)result, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
                if (structurePiecesGenerator.isPresent()) {
                    Log.getLogger().debug("New Empty colony at" + String.valueOf(result));
                }
                return structurePiecesGenerator;
            }
            return Optional.empty();
        }
        if (!EmptyColonyStructure.isFeatureChunk(context)) {
            return Optional.empty();
        }
        BlockPos blockpos = context.f_226628_().m_151394_(0);
        int topLandY = context.f_226622_().m_223221_(blockpos.m_123341_(), blockpos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
        Optional structurePiecesGenerator = JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)(blockpos = blockpos.m_6630_(topLandY)), (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
        if (structurePiecesGenerator.isPresent()) {
            Log.getLogger().debug("New Empty colony at" + String.valueOf(blockpos));
        }
        return structurePiecesGenerator;
    }

    private static BlockPos.MutableBlockPos isFeatureChunkCave(Structure.GenerationContext context) {
        BlockPos blockPos = context.f_226628_().m_45615_();
        ChunkPos chunkPos = new ChunkPos(blockPos);
        int currentY = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 10; ++i) {
            currentY += context.f_226626_().m_216339_(0, 30);
            for (int curChunkX = chunkPos.f_45578_ - 1; curChunkX <= chunkPos.f_45578_ + 1; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - 1; curChunkZ <= chunkPos.f_45579_ + 1; ++curChunkZ) {
                    BlockState state;
                    NoiseColumn blockView = context.f_226622_().m_214184_(mutable.m_123341_(), mutable.m_123343_(), context.f_226629_(), context.f_226624_());
                    mutable.m_122178_(curChunkX << 4, currentY, curChunkZ << 4);
                    if (!blockView.m_183556_(mutable.m_123342_()).m_60795_()) continue;
                    int airCount = 1;
                    while (mutable.m_123342_() > context.f_226622_().m_142062_() && (state = blockView.m_183556_(mutable.m_123342_())).m_60795_()) {
                        ++airCount;
                        mutable.m_122173_(Direction.DOWN);
                    }
                    mutable.m_142448_(currentY);
                    while (mutable.m_123342_() < context.f_226622_().m_142062_() + context.f_226622_().m_6331_() && (state = blockView.m_183556_(mutable.m_123342_())).m_60795_() && ++airCount < 32) {
                        mutable.m_122173_(Direction.UP);
                    }
                    if (airCount < 32) continue;
                    return mutable;
                }
            }
        }
        return null;
    }
}

