/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.fields;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.colony.buildingextensions.registry.BuildingExtensionDataManager;
import com.minecolonies.core.colony.buildings.modules.BuildingExtensionsModule;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class AssignFieldMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private int moduleID = 0;
    private FriendlyByteBuf fieldData;
    private boolean assign;

    public AssignFieldMessage() {
    }

    public AssignFieldMessage(IBuildingView building, IBuildingExtension field, boolean assign, int moduleID) {
        super(building);
        this.assign = assign;
        this.fieldData = BuildingExtensionDataManager.extensionToBuffer(field);
        this.moduleID = moduleID;
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.fieldData.resetReaderIndex();
        buf.writeBoolean(this.assign);
        buf.writeInt(this.moduleID);
        buf.writeBytes((ByteBuf)this.fieldData);
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.assign = buf.readBoolean();
        this.moduleID = buf.readInt();
        this.fieldData = new FriendlyByteBuf(Unpooled.buffer((int)buf.readableBytes()));
        buf.readBytes((ByteBuf)this.fieldData, buf.readableBytes());
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        IBuildingExtension parsedField = BuildingExtensionDataManager.bufferToExtension(this.fieldData);
        colony.getBuildingManager().getMatchingBuildingExtension(otherField -> otherField.equals(parsedField)).ifPresent(field -> {
            IBuildingModule patt2785$temp = building.getModule(this.moduleID);
            if (patt2785$temp instanceof BuildingExtensionsModule) {
                BuildingExtensionsModule fieldsModule = (BuildingExtensionsModule)patt2785$temp;
                if (this.assign) {
                    fieldsModule.assignExtension((IBuildingExtension)field);
                } else {
                    fieldsModule.freeExtension((IBuildingExtension)field);
                }
            }
        });
    }
}

