/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintTagUtils;
import com.ldtteam.structurize.placement.handlers.placement.PlacementError;
import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.items.ISupplyItem;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.client.gui.WindowSupplies;
import com.minecolonies.core.client.gui.WindowSupplyStory;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.items.AbstractItemMinecolonies;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSupplyChestDeployer
extends AbstractItemMinecolonies
implements ISupplyItem {
    private static final String SUPPLY_SHIP_STRUCTURE_NAME = "supplyship";
    private static final String SUPPLY_SHIP_STRUCTURE_NAME_NETHER = "nethership";
    private static final int SCAN_HEIGHT = 7;
    private static final int DEFAULT_WATER_LEVELS = 3;

    public ItemSupplyChestDeployer(Item.Properties properties) {
        super("supplychestdeployer", properties.m_41487_(1));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        if (!ctx.m_43722_().m_41784_().m_128441_("randkey")) {
            ctx.m_43722_().m_41783_().m_128356_("randkey", ctx.m_8083_().m_121878_());
        }
        if (ctx.m_43725_().f_46443_) {
            if (!((Boolean)MineColonies.getConfig().getServer().allowOtherDimColonies.get()).booleanValue() && !WorldUtil.isOverworldType(ctx.m_43725_())) {
                return InteractionResult.FAIL;
            }
            this.placeSupplyShip(ctx.m_43725_(), ctx.m_8083_().m_5484_(ctx.m_8125_(), 10).m_7494_(), ctx.m_43724_(), ctx.m_43722_());
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (!stack.m_41784_().m_128441_("randkey")) {
            stack.m_41783_().m_128356_("randkey", playerIn.m_20183_().m_121878_());
        }
        if (worldIn.f_46443_) {
            if (!((Boolean)MineColonies.getConfig().getServer().allowOtherDimColonies.get()).booleanValue() && !WorldUtil.isOverworldType(worldIn)) {
                MessageUtils.format("com.minecolonies.coremod.dimension.no", new Object[0]).sendTo(playerIn);
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
            }
            this.placeSupplyShip(worldIn, null, hand, stack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    private void placeSupplyShip(Level world, @Nullable BlockPos pos, InteractionHand hand, ItemStack itemInHand) {
        String name;
        String string = name = WorldUtil.isNetherType(world) ? SUPPLY_SHIP_STRUCTURE_NAME_NETHER : SUPPLY_SHIP_STRUCTURE_NAME;
        if (!itemInHand.m_41784_().m_128441_("sawstory")) {
            new WindowSupplyStory(pos, name, itemInHand, hand).open();
            return;
        }
        if (pos == null) {
            new WindowSupplies(pos, name).open();
            return;
        }
        new WindowSupplies(pos, name).open();
    }

    public static boolean canShipBePlaced(@NotNull Level world, @NotNull BlockPos pos, Blueprint ship, @NotNull List<PlacementError> placementErrorList, Player placer) {
        if (((Boolean)MineColonies.getConfig().getServer().noSupplyPlacementRestrictions.get()).booleanValue()) {
            return true;
        }
        int sizeX = ship.getSizeX();
        int sizeZ = ship.getSizeZ();
        int waterLevel = BlueprintTagUtils.getNumberOfGroundLevels((Blueprint)ship, (int)3);
        BlockPos zeroPos = pos.m_121996_((Vec3i)ship.getPrimaryBlockOffset());
        ArrayList<PlacementError> needsAirAbove = new ArrayList<PlacementError>();
        ArrayList<PlacementError> needsWaterList = new ArrayList<PlacementError>();
        for (int z = 0; z < sizeZ; ++z) {
            for (int x = 0; x < sizeX; ++x) {
                for (int y = 0; y <= Math.min(waterLevel + 7, ship.getSizeY() - 1); ++y) {
                    BlockPos worldPos = new BlockPos(zeroPos.m_123341_() + x, zeroPos.m_123342_() + y, zeroPos.m_123343_() + z);
                    BlockState state = ship.m_8055_(new BlockPos(x, y, z));
                    if (y < waterLevel) {
                        ItemSupplyChestDeployer.checkFluidAndNotInColony(world, worldPos, needsWaterList, placer, state);
                        continue;
                    }
                    if (!BlockUtils.isAnySolid((BlockState)world.m_8055_(worldPos)) || state.m_60734_() == ModBlocks.blockSubstitution.get()) continue;
                    needsAirAbove.add(new PlacementError(PlacementError.PlacementErrorType.NEEDS_AIR_ABOVE, worldPos));
                }
            }
        }
        if ((double)needsAirAbove.size() > (double)(sizeX * sizeZ) * 0.3333333333333333 || (double)needsWaterList.size() > (double)(sizeX * sizeZ) * 0.3333333333333333) {
            placementErrorList.addAll(needsAirAbove);
            placementErrorList.addAll(needsWaterList);
            return false;
        }
        return true;
    }

    private static void checkFluidAndNotInColony(Level world, BlockPos pos, @NotNull List<PlacementError> placementErrorList, Player placer, BlockState state) {
        boolean isOverworld = WorldUtil.isOverworldType(world);
        boolean isWater = PathfindingUtils.isWater((BlockGetter)world, pos);
        boolean notInAnyColony = ItemSupplyChestDeployer.hasPlacePermission(world, pos, placer);
        if (state.m_60734_() != ModBlocks.blockFluidSubstitution.get()) {
            if (!isWater && isOverworld) {
                placementErrorList.add(new PlacementError(PlacementError.PlacementErrorType.NOT_WATER, pos));
            } else if (!world.m_8055_(pos).m_60819_().m_76152_().m_6212_((Fluid)Fluids.f_76195_) && !isOverworld) {
                placementErrorList.add(new PlacementError(PlacementError.PlacementErrorType.NOT_WATER, pos));
            }
        }
        if (!notInAnyColony) {
            placementErrorList.add(new PlacementError(PlacementError.PlacementErrorType.INSIDE_COLONY, pos));
        }
    }

    private static boolean hasPlacePermission(Level world, BlockPos pos, Player placer) {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, pos);
        return colony == null || colony.getPermissions().hasPermission(placer, Action.PLACE_BLOCKS);
    }
}

