/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults.workers;

import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.core.generation.CustomRecipeProvider;
import com.minecolonies.core.generation.defaults.workers.DefaultRecipeLootProvider;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class DefaultCrusherCraftingProvider
extends CustomRecipeProvider {
    private static final String CRUSHER = ModJobs.CRUSHER_ID.m_135815_();

    public DefaultCrusherCraftingProvider(@NotNull PackOutput packOutput) {
        super(packOutput);
    }

    @NotNull
    public String m_6055_() {
        return "DefaultCrusherCraftingProvider";
    }

    @Override
    protected void registerRecipes(@NotNull Consumer<FinishedRecipe> consumer) {
        Rule noGildedHammer = builder -> builder.maxResearchId(ResearchConstants.CRUSHING_11);
        Rule withGildedHammer = builder -> builder.minResearchId(ResearchConstants.CRUSHING_11);
        Rule withTheDepths = builder -> builder.minResearchId(ResearchConstants.THE_DEPTHS);
        Rule gravelLoot = builder -> builder.lootTable(DefaultRecipeLootProvider.LOOT_TABLE_GRAVEL);
        this.crush(consumer, "bonemeal1", new ItemStack((ItemLike)Items.f_42500_), new ItemStack((ItemLike)Items.f_42499_, 3), noGildedHammer);
        this.crush(consumer, "bonemeal2", new ItemStack((ItemLike)Items.f_42500_), new ItemStack((ItemLike)Items.f_42499_, 5), withGildedHammer);
        this.crush(consumer, "bonemeal3", new ItemStack((ItemLike)Items.f_42262_), new ItemStack((ItemLike)Items.f_42499_, 9), new Rule[0]);
        this.crush(consumer, "gravel1", new ItemStack((ItemLike)Items.f_42594_, 2), new ItemStack((ItemLike)Items.f_41832_), noGildedHammer);
        this.crush(consumer, "gravel2", new ItemStack((ItemLike)Items.f_42594_), new ItemStack((ItemLike)Items.f_41832_), withGildedHammer);
        this.crush(consumer, "sand1", new ItemStack((ItemLike)Items.f_41832_, 2), new ItemStack((ItemLike)Items.f_41830_), noGildedHammer, gravelLoot);
        this.crush(consumer, "sand2", new ItemStack((ItemLike)Items.f_41832_), new ItemStack((ItemLike)Items.f_41830_), withGildedHammer, gravelLoot);
        this.crush(consumer, "clay1", new ItemStack((ItemLike)Items.f_41830_, 2), new ItemStack((ItemLike)Items.f_41983_), noGildedHammer);
        this.crush(consumer, "clay2", new ItemStack((ItemLike)Items.f_41830_), new ItemStack((ItemLike)Items.f_41983_), withGildedHammer);
        this.crush(consumer, "clay_ball", new ItemStack((ItemLike)Items.f_41983_), new ItemStack((ItemLike)Items.f_42461_, 4), new Rule[0]);
        this.crush(consumer, "cobble", new ItemStack((ItemLike)Items.f_151048_, 2), new ItemStack((ItemLike)Items.f_42594_), withTheDepths, noGildedHammer);
        this.crush(consumer, "cobble2", new ItemStack((ItemLike)Items.f_151048_), new ItemStack((ItemLike)Items.f_42594_), withTheDepths, withGildedHammer);
        this.crush(consumer, "tuff", new ItemStack((ItemLike)Items.f_151035_, 2), new ItemStack((ItemLike)Items.f_151048_), withTheDepths, noGildedHammer);
        this.crush(consumer, "tuff2", new ItemStack((ItemLike)Items.f_151035_), new ItemStack((ItemLike)Items.f_151048_), withTheDepths, withGildedHammer);
    }

    private void crush(@NotNull Consumer<FinishedRecipe> consumer, @NotNull String name, @NotNull ItemStack input, @NotNull ItemStack output, Rule ... rules) {
        CustomRecipeProvider.CustomRecipeBuilder builder = CustomRecipeProvider.CustomRecipeBuilder.create(CRUSHER, "custom", name).inputs(List.of(new ItemStorage(input))).result(output);
        for (Rule rule : rules) {
            rule.accept(builder);
        }
        builder.build(consumer);
    }

    private static interface Rule
    extends Consumer<CustomRecipeProvider.CustomRecipeBuilder> {
    }
}

