/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.citizen;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.entity.CustomGoalSelector;
import com.minecolonies.api.entity.ai.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.ai.combat.threat.ThreatTable;
import com.minecolonies.api.entity.ai.statemachine.AIOneTimeEventTarget;
import com.minecolonies.api.entity.ai.statemachine.states.CitizenAIState;
import com.minecolonies.api.entity.ai.statemachine.states.EntityState;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenColonyHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenExperienceHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenInventoryHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenJobHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSleepHandler;
import com.minecolonies.api.entity.citizen.happiness.ExpirationBasedHappinessModifier;
import com.minecolonies.api.entity.citizen.happiness.StaticHappinessSupplier;
import com.minecolonies.api.eventbus.events.colony.citizens.CitizenDiedModEvent;
import com.minecolonies.api.eventbus.events.colony.citizens.CitizenRemovedModEvent;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.inventory.container.ContainerCitizenInventory;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.DamageSourceKeys;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.WindowInteraction;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.colony.eventhooks.citizenEvents.CitizenDiedEvent;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.colony.jobs.JobKnight;
import com.minecolonies.core.colony.jobs.JobNetherWorker;
import com.minecolonies.core.colony.jobs.JobRanger;
import com.minecolonies.core.datalistener.DiseasesListener;
import com.minecolonies.core.debug.DebugPlayerManager;
import com.minecolonies.core.entity.ai.minimal.EntityAICitizenChild;
import com.minecolonies.core.entity.ai.minimal.EntityAIFloat;
import com.minecolonies.core.entity.ai.minimal.EntityAIInteractToggleAble;
import com.minecolonies.core.entity.ai.minimal.LookAtEntityGoal;
import com.minecolonies.core.entity.ai.minimal.LookAtEntityInteractGoal;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIBasic;
import com.minecolonies.core.entity.ai.workers.CitizenAI;
import com.minecolonies.core.entity.ai.workers.guard.AbstractEntityAIGuard;
import com.minecolonies.core.entity.citizen.CitizenCombatTracker;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenColonyHandler;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenExperienceHandler;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenInventoryHandler;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenJobHandler;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenSleepHandler;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.entity.pathfinding.navigation.MovementHandler;
import com.minecolonies.core.event.EventHandler;
import com.minecolonies.core.event.TextureReloadListener;
import com.minecolonies.core.network.messages.client.ItemParticleEffectMessage;
import com.minecolonies.core.network.messages.client.VanillaParticleMessage;
import com.minecolonies.core.network.messages.client.colony.ColonyViewCitizenViewMessage;
import com.minecolonies.core.network.messages.client.colony.PlaySoundForCitizenMessage;
import com.minecolonies.core.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.core.util.TeleportHelper;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityCitizen
extends AbstractEntityCitizen
implements IThreatTableEntity {
    private static final int CALL_HELP_CD = 100;
    private static final float GUARD_BLOCK_DAMAGE = 0.5f;
    private static final double MAX_SPEED_FACTOR = 0.5;
    private static final int CALL_TO_HELP_AMOUNT = 2;
    private int citizenId = 0;
    private ICitizenData citizenData;
    private ICitizenExperienceHandler citizenExperienceHandler;
    private ICitizenInventoryHandler citizenInventoryHandler;
    private ICitizenColonyHandler citizenColonyHandler;
    private ICitizenJobHandler citizenJobHandler;
    private ICitizenSleepHandler citizenSleepHandler;
    private final CitizenCombatTracker combatTracker;
    private boolean child = false;
    private int callForHelpCooldown = 0;
    private float lastDistanceWalked = 0.0f;
    private ICitizenDataView citizenDataView;
    private ILocation location = null;
    private ChunkPos lastChunk;
    private final ThreatTable threatTable = new ThreatTable<EntityCitizen>(this);
    private int interactionCooldown = 0;
    private ITickRateStateMachine<IState> citizenAI = new TickRateStateMachine<CitizenAIState>(CitizenAIState.IDLE, e -> {}, 5);
    private int maxAir = 300;
    private boolean isGlowing;
    private double cachedActionSaturationDecrease;

    public EntityCitizen(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
        this.f_21345_ = new CustomGoalSelector(this.f_21345_);
        this.f_21346_ = new CustomGoalSelector(this.f_21346_);
        this.citizenExperienceHandler = new CitizenExperienceHandler(this);
        this.citizenInventoryHandler = new CitizenInventoryHandler(this);
        this.citizenColonyHandler = new CitizenColonyHandler(this);
        this.citizenJobHandler = new CitizenJobHandler(this);
        this.citizenSleepHandler = new CitizenSleepHandler(this);
        this.combatTracker = new CitizenCombatTracker(this);
        this.f_21342_ = new MovementHandler((Mob)this);
        this.m_21530_();
        this.m_20340_((Boolean)MineColonies.getConfig().getServer().alwaysRenderNameTag.get());
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.INIT, () -> true, this::initialize, 40));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.ACTIVE_CLIENT, () -> {
            this.citizenColonyHandler.updateColonyClient();
            return false;
        }, () -> null, 1));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.ACTIVE_CLIENT, this::shouldBeInactive, () -> EntityState.INACTIVE, 20));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.ACTIVE_CLIENT, this::refreshCitizenDataView, () -> null, 20));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.ACTIVE_SERVER, this::updateHealing, () -> null, 100));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.ACTIVE_SERVER, this::updateVisualData, () -> null, 200));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.ACTIVE_SERVER, this::onServerUpdateHandlers, () -> null, 20));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.ACTIVE_SERVER, this::onTickDecrements, () -> null, 1));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.ACTIVE_SERVER, this::shouldBeInactive, () -> EntityState.INACTIVE, 20));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.ACTIVE_SERVER, () -> {
            this.citizenAI.tick();
            return false;
        }, () -> null, 1));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.ACTIVE_SERVER, this::decreaseIdleSaturation, () -> null, 1200));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.INACTIVE, () -> ((EntityCitizen)this).m_6084_(), () -> EntityState.INIT, 100));
    }

    private boolean shouldBeInactive() {
        if (this.citizenData == null && this.citizenDataView == null) {
            return true;
        }
        return !this.m_6084_();
    }

    private EntityState initialize() {
        if (CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).f_46443_) {
            IColonyView colonyView;
            this.citizenColonyHandler.updateColonyClient();
            if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)this.f_19853_.m_46472_())) != null) {
                this.citizenDataView = colonyView.getCitizen(this.citizenId);
                if (this.citizenDataView != null) {
                    this.initTasks();
                    return EntityState.ACTIVE_CLIENT;
                }
            }
        } else {
            this.citizenColonyHandler.registerWithColony(this.citizenColonyHandler.getColonyId(), this.citizenId);
            if (this.citizenData != null && this.m_6084_() && this.citizenColonyHandler.getColonyOrRegister() != null) {
                this.initTasks();
                return EntityState.ACTIVE_SERVER;
            }
        }
        return null;
    }

    private void initTasks() {
        new CitizenAI(this);
        int priority = 0;
        this.f_21345_.m_25352_(priority, (Goal)new EntityAIFloat((Mob)this));
        this.f_21345_.m_25352_(priority, (Goal)new EntityAIInteractToggleAble(this, EntityAIInteractToggleAble.FENCE_TOGGLE, EntityAIInteractToggleAble.TRAP_TOGGLE, EntityAIInteractToggleAble.DOOR_TOGGLE));
        this.f_21345_.m_25352_(++priority, (Goal)new LookAtEntityInteractGoal((Mob)this, Player.class, 3.0f, 0.2f));
        this.f_21345_.m_25352_(++priority, (Goal)new LookAtEntityInteractGoal((Mob)this, EntityCitizen.class, 5.0f, 0.02f));
        this.f_21345_.m_25352_(++priority, (Goal)new LookAtEntityGoal((Mob)this, LivingEntity.class, 6.0f));
    }

    @NotNull
    public InteractionResult m_21499_(Player player, @NotNull InteractionHand hand) {
        IColonyView iColonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)player.f_19853_.m_46472_());
        if (iColonyView != null && !iColonyView.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
            return InteractionResult.FAIL;
        }
        if (!ItemStackUtils.isEmpty(player.m_21120_(hand)) && player.m_21120_(hand).m_150930_(Items.f_42656_)) {
            return super.m_21499_(player, hand);
        }
        InteractionResult result = this.directPlayerInteraction(player, hand);
        if (result != null) {
            return result;
        }
        if (CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).f_46443_ && iColonyView != null) {
            if (player.m_6144_() && !this.m_20145_()) {
                Network.getNetwork().sendToServer(new OpenInventoryMessage(iColonyView, this.m_7755_().getString(), this.m_19879_()));
            } else {
                ICitizenDataView citizenDataView = this.getCitizenDataView();
                if (citizenDataView != null && !this.m_20145_()) {
                    new WindowInteraction(citizenDataView).open();
                }
            }
        }
        if (!this.f_19853_.f_46443_ && this.getCitizenData() != null) {
            this.citizenData.setInteractedRecently(player.m_20148_());
            ColonyViewCitizenViewMessage message = new ColonyViewCitizenViewMessage((Colony)this.getCitizenData().getColony(), this.getCitizenData());
            Network.getNetwork().sendToPlayer(message, (ServerPlayer)player);
            if (DebugPlayerManager.hasDebugEnabled(player)) {
                this.getCitizenAI().setHistoryEnabled(true, 20);
                if (this.getCitizenJobHandler().getColonyJob() != null) {
                    this.getCitizenJobHandler().getWorkAI().getStateAI().setHistoryEnabled(true, 20);
                }
            } else {
                if (this.citizenData.getJob() != null) {
                    ((AbstractEntityAIBasic)this.citizenData.getJob().getWorkerAI()).setDelay(60);
                }
                this.getNavigation().m_26573_();
                this.m_21563_().m_148051_((Entity)player);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult directPlayerInteraction(Player player, InteractionHand hand) {
        boolean isSick;
        if (player.m_6144_()) {
            return null;
        }
        ItemStack usedStack = player.m_21120_(hand);
        if (((Boolean)MineColonies.getConfig().getServer().enableInDevelopmentFeatures.get()).booleanValue() && usedStack.m_41720_() instanceof BlockItem && ((BlockItem)usedStack.m_41720_()).m_40614_() instanceof AbstractBlockHut) {
            BuildingEntry entry = ((AbstractBlockHut)((BlockItem)usedStack.m_41720_()).m_40614_()).getBuildingEntry();
            for (BuildingEntry.ModuleProducer moduleProducer : entry.getModuleProducers()) {
                IBuildingModule iBuildingModule = BuildingEntry.produceModuleWithoutBuilding(moduleProducer.key);
                if (!(iBuildingModule instanceof WorkerBuildingModule)) continue;
                WorkerBuildingModule module = (WorkerBuildingModule)iBuildingModule;
                this.getCitizenJobHandler().setModelDependingOnJob(module.getJobEntry().produceJob(null));
                return InteractionResult.SUCCESS;
            }
        }
        if (this.isInteractionItem(usedStack) && this.interactionCooldown > 0) {
            if (!this.f_19853_.m_5776_()) {
                this.m_5496_(SoundEvents.f_12507_, 0.5f, (float)SoundUtils.getRandomPitch(this.m_217043_()));
                MessageUtils.format("com.minecolonies.coremod.interaction.notnow", this.getCitizenData().getName()).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(player);
            }
            return InteractionResult.PASS;
        }
        boolean bl = isSick = this.getCitizenData() != null && this.getCitizenData().getCitizenDiseaseHandler().isSick() || this.citizenDataView != null && this.citizenDataView.getVisibleStatus() == VisibleCitizenStatus.SICK;
        if (usedStack.m_41720_() == Items.f_42436_ && isSick) {
            usedStack.m_41774_(1);
            player.m_21008_(hand, usedStack);
            if (!this.f_19853_.m_5776_() && this.m_217043_().m_188503_(3) == 0) {
                this.getCitizenData().getCitizenDiseaseHandler().cure();
                this.m_5496_(SoundEvents.f_12275_, 1.0f, (float)SoundUtils.getRandomPitch(this.m_217043_()));
                Network.getNetwork().sendToTrackingEntity(new VanillaParticleMessage(this.m_20185_(), this.m_20186_(), this.m_20189_(), ParticleTypes.f_123748_), (Entity)this);
            }
            this.interactionCooldown = 6000;
            return InteractionResult.CONSUME;
        }
        if (usedStack.m_204117_(ModTags.poisonous_food)) {
            usedStack.m_41774_(1);
            player.m_21008_(hand, usedStack);
            if (!this.f_19853_.m_5776_() && this.getCitizenData().getCitizenDiseaseHandler().setDisease(DiseasesListener.getRandomDisease(this.m_217043_()))) {
                this.m_5496_(SoundEvents.f_12506_, 1.0f, (float)SoundUtils.getRandomPitch(this.m_217043_()));
                this.getCitizenData().markDirty(20);
                MessageUtils.format("com.minecolonies.coremod.interaction.poison", this.getCitizenData().getName()).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(player);
            }
            this.interactionCooldown = 400;
            return InteractionResult.CONSUME;
        }
        if (isSick) {
            return null;
        }
        if (ItemStackUtils.ISFOOD.test(usedStack) && usedStack.m_41720_() != Items.f_42436_) {
            if (this.m_6162_()) {
                this.childFoodInteraction(usedStack, player, hand);
            } else {
                this.eatFoodInteraction(usedStack, player, hand);
            }
            return InteractionResult.CONSUME;
        }
        if (usedStack.m_41720_() == Items.f_42517_ && this.m_6162_()) {
            usedStack.m_41774_(1);
            player.m_21008_(hand, usedStack);
            if (!this.f_19853_.m_5776_()) {
                this.getCitizenData().getCitizenSkillHandler().addXpToSkill(Skill.Intelligence, 50.0, this.getCitizenData());
            }
            this.interactionCooldown = 6000;
            return InteractionResult.CONSUME;
        }
        if (usedStack.m_41720_() == Items.f_41982_) {
            usedStack.m_41774_(1);
            player.m_21008_(hand, usedStack);
            if (!this.f_19853_.m_5776_()) {
                MessageUtils.format("com.minecolonies.coremod.interaction.ouch", this.getCitizenData().getName()).sendTo(player);
                EntityNavigationUtils.walkAwayFrom(this, player.m_20183_(), 5, 1.0);
                this.m_6862_(true);
            }
            this.interactionCooldown = 6000;
            return InteractionResult.CONSUME;
        }
        if (usedStack.m_41720_() == Items.f_42525_) {
            usedStack.m_41774_(1);
            player.m_21008_(hand, usedStack);
            if (!this.f_19853_.m_5776_()) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 3600));
            }
            this.interactionCooldown = 3600;
            return InteractionResult.CONSUME;
        }
        return null;
    }

    public boolean isInteractionItem(ItemStack stack) {
        return ItemStackUtils.ISFOOD.test(stack) || stack.m_41720_() == Items.f_42517_ || stack.m_41720_() == Items.f_42436_ || stack.m_41720_() == Items.f_41982_ || stack.m_41720_() == Items.f_42525_ || stack.m_204117_(ModTags.poisonous_food);
    }

    private void childFoodInteraction(ItemStack usedStack, Player player, InteractionHand hand) {
        if (usedStack.m_41611_().getString().toLowerCase(Locale.US).contains("cookie")) {
            this.interactionCooldown = 100;
            if (!this.f_19853_.m_5776_()) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 300));
                this.m_5496_(SoundEvents.f_11912_, 1.5f, (float)SoundUtils.getRandomPitch(this.m_217043_()));
                Network.getNetwork().sendToTrackingEntity(new ItemParticleEffectMessage(usedStack, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_20192_()), (Entity)this);
                ItemStackUtils.consumeFood(usedStack, this, player.m_150109_());
            }
        } else {
            player.m_150109_().m_36057_(usedStack);
            player.m_7197_(usedStack, true, true);
            if (!this.f_19853_.m_5776_()) {
                this.m_5496_(SoundEvents.f_12507_, 1.0f, (float)SoundUtils.getRandomPitch(this.m_217043_()));
                MessageUtils.format("com.minecolonies.coremod.interaction.nocookie", this.getCitizenData().getName()).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(player);
            }
        }
    }

    private void eatFoodInteraction(ItemStack usedStack, Player player, InteractionHand hand) {
        if (!this.f_19853_.m_5776_()) {
            this.m_5496_(SoundEvents.f_11912_, 1.5f, (float)SoundUtils.getRandomPitch(this.m_217043_()));
            Network.getNetwork().sendToTrackingEntity(new ItemParticleEffectMessage(usedStack, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_20192_()), (Entity)this);
            if (this.citizenData != null) {
                this.citizenData.getCitizenFoodHandler().addLastEaten(usedStack.m_41720_());
            }
            ItemStackUtils.consumeFood(usedStack, this, player.m_150109_());
        }
        this.interactionCooldown = 100;
    }

    @NotNull
    public String m_6302_() {
        return this.m_7755_().getString() + " (" + this.getCivilianID() + ")";
    }

    @Override
    public ICitizenDataView getCitizenDataView() {
        if (this.citizenDataView == null) {
            IColonyView colonyView;
            if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)this.f_19853_.m_46472_())) != null) {
                this.citizenDataView = colonyView.getCitizen(this.citizenId);
                return this.citizenDataView;
            }
        } else {
            return this.citizenDataView;
        }
        return null;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("colony", this.citizenColonyHandler.getColonyId());
        if (this.citizenData != null) {
            compound.m_128405_("citizen", this.citizenData.getId());
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("colony")) {
            this.citizenColonyHandler.setColonyId(compound.m_128451_("colony"));
            if (compound.m_128441_("citizen")) {
                this.citizenId = compound.m_128451_("citizen");
            }
        }
        this.m_20124_(Pose.STANDING);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.interactionCooldown > 0) {
            --this.interactionCooldown;
        }
    }

    public boolean refreshCitizenDataView() {
        IColonyView colonyView;
        if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)this.f_19853_.m_46472_())) != null) {
            this.citizenDataView = colonyView.getCitizen(this.citizenId);
            this.getNavigation().getPathingOptions().setCanUseRails(this.canPathOnRails());
            this.getNavigation().getPathingOptions().setCanClimbAdvanced(this.canClimbVines());
        }
        return false;
    }

    private boolean onTickDecrements() {
        this.decrementCallForHelpCooldown();
        this.decreaseWalkingSaturation();
        return false;
    }

    private boolean onServerUpdateHandlers() {
        this.citizenExperienceHandler.gatherXp();
        CitizenItemUtils.pickupItems(this);
        this.citizenData.setLastPosition(this.m_20183_());
        this.onLivingSoundUpdate();
        ChunkPos currentChunk = this.m_146902_();
        if (!Objects.equals(currentChunk, this.lastChunk)) {
            this.lastChunk = currentChunk;
            EventHandler.onEnteringChunkEntity(this, currentChunk);
        }
        return false;
    }

    public int m_6062_() {
        return this.maxAir;
    }

    private boolean updateVisualData() {
        this.m_20340_((Boolean)MineColonies.getConfig().getServer().alwaysRenderNameTag.get());
        if (!this.citizenColonyHandler.getColonyOrRegister().getTextureStyleId().equals(this.m_20088_().m_135370_(DATA_STYLE))) {
            this.m_20088_().m_135381_(DATA_STYLE, (Object)this.citizenColonyHandler.getColonyOrRegister().getTextureStyleId());
        }
        if (!this.citizenData.getTextureSuffix().equals(this.m_20088_().m_135370_(DATA_TEXTURE_SUFFIX))) {
            this.m_20088_().m_135381_(DATA_TEXTURE_SUFFIX, (Object)this.citizenData.getTextureSuffix());
        }
        return false;
    }

    private boolean updateHealing() {
        this.checkHeal();
        if (this.citizenData.getSaturation() <= 0.0) {
            if (this.m_21124_(MobEffects.f_19597_) == null) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 600));
            }
        } else {
            this.m_21195_(MobEffects.f_19597_);
        }
        return false;
    }

    private void decrementCallForHelpCooldown() {
        if (this.callForHelpCooldown > 0) {
            --this.callForHelpCooldown;
        }
    }

    public boolean canPathOnRails() {
        if (this.f_19853_.f_46443_) {
            IColonyView colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)this.f_19853_.m_46472_());
            if (colonyView != null) {
                return colonyView.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.RAILS) > 0.0;
            }
            return false;
        }
        return this.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.RAILS) > 0.0;
    }

    public boolean canClimbVines() {
        if (this.f_19853_.f_46443_) {
            IColonyView colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)this.f_19853_.m_46472_());
            if (colonyView != null) {
                return colonyView.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.VINES) > 0.0;
            }
            return false;
        }
        return this.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.VINES) > 0.0;
    }

    private void decreaseWalkingSaturation() {
        if (this.f_19787_ - this.lastDistanceWalked > 25.0f) {
            this.lastDistanceWalked = this.f_19787_;
            this.decreaseSaturationForContinuousAction();
        }
    }

    private void checkHeal() {
        if (this.getCitizenData() != null) {
            float f = this.m_21223_();
            float f2 = this.getCitizenData().getCitizenDiseaseHandler().isSick() ? this.m_21233_() / 3.0f : this.m_21233_();
            if (f < f2 && this.m_21188_() == null) {
                double limitDecrease = this.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SATLIMIT);
                double citizenSaturation = this.citizenData.getSaturation();
                double healAmount = citizenSaturation >= 20.0 + limitDecrease ? 2.0 * (1.0 + this.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.REGENERATION)) : (citizenSaturation < 6.0 ? 1.0 * (citizenSaturation / 20.0) / 2.0 : 1.0 * (1.0 + this.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.REGENERATION)));
                this.m_5634_((float)healAmount);
            }
        }
    }

    private void onLivingSoundUpdate() {
        if (WorldUtil.isDayTime(this.f_19853_) && !this.m_20067_()) {
            SoundUtils.playRandomSound(this.f_19853_, this.m_20183_(), this.citizenData);
        }
    }

    public boolean m_6162_() {
        return this.child;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_COLONY_ID, (Object)(this.citizenColonyHandler == null ? 0 : this.citizenColonyHandler.getColonyId()));
        this.f_19804_.m_135372_(DATA_CITIZEN_ID, (Object)this.citizenId);
    }

    @Override
    public void setRenderMetadata(String metadata) {
        super.setRenderMetadata(metadata);
        if (this.citizenJobHandler.getColonyJob() != null && ((Boolean)MineColonies.getConfig().getServer().enableInDevelopmentFeatures.get()).booleanValue()) {
            super.m_6593_((Component)Component.m_237113_((String)(this.citizenData.getName() + "[" + this.citizenJobHandler.getColonyJob().getNameTagDescription() + "]")));
        }
    }

    @Override
    public ILocation getLocation() {
        if (this.location == null) {
            this.location = StandardFactoryController.getInstance().getNewInstance(TypeConstants.ILOCATION, this, new Object[0]);
        }
        return this.location;
    }

    @Override
    public ICitizenData getCitizenData() {
        return this.citizenData;
    }

    @Override
    public ICivilianData getCivilianData() {
        return this.citizenData;
    }

    @Override
    public void setCivilianData(@Nullable ICivilianData data) {
        if (data != null) {
            this.citizenData = (ICitizenData)data;
            data.initEntityValues();
        }
    }

    @Override
    @NotNull
    public InventoryCitizen getInventoryCitizen() {
        return this.getCitizenData().getInventory();
    }

    @Override
    @NotNull
    public IItemHandler getItemHandlerCitizen() {
        return this.getInventoryCitizen();
    }

    @Override
    public void markDirty(int time) {
        if (this.citizenData != null) {
            this.citizenData.markDirty(time);
        }
    }

    @Override
    public void setIsChild(boolean isChild) {
        if (isChild && !this.child) {
            new EntityAICitizenChild(this);
        } else if (!isChild && this.child) {
            this.child = isChild;
            this.getCitizenJobHandler().setModelDependingOnJob(this.citizenJobHandler.getColonyJob());
        }
        this.child = isChild;
        this.m_20088_().m_135381_(DATA_IS_CHILD, (Object)isChild);
        this.m_6210_();
        this.markDirty(0);
    }

    @Override
    public void playMoveAwaySound() {
        if (this.citizenJobHandler.getColonyJob() != null) {
            SoundUtils.playSoundAtCitizenWith(this.f_19853_, this.m_20183_(), EventType.DANGER, this.getCitizenData());
        }
    }

    @Override
    public void decreaseSaturationForAction() {
        this.cachedActionSaturationDecrease += 0.05;
    }

    @Override
    public void decreaseSaturationForContinuousAction() {
        this.cachedActionSaturationDecrease += 0.005;
    }

    @Override
    public int getCivilianID() {
        return this.citizenId;
    }

    @Override
    public void setCitizenId(int id) {
        this.citizenId = id;
    }

    @Override
    public ICitizenExperienceHandler getCitizenExperienceHandler() {
        return this.citizenExperienceHandler;
    }

    @Override
    public ICitizenInventoryHandler getCitizenInventoryHandler() {
        return this.citizenInventoryHandler;
    }

    @Override
    public void setCitizenInventoryHandler(ICitizenInventoryHandler citizenInventoryHandler) {
        this.citizenInventoryHandler = citizenInventoryHandler;
    }

    @Override
    public ICitizenColonyHandler getCitizenColonyHandler() {
        return this.citizenColonyHandler;
    }

    @Override
    public void setCitizenColonyHandler(ICitizenColonyHandler citizenColonyHandler) {
        this.citizenColonyHandler = citizenColonyHandler;
    }

    @Override
    public ICitizenJobHandler getCitizenJobHandler() {
        return this.citizenJobHandler;
    }

    @Override
    public ICitizenSleepHandler getCitizenSleepHandler() {
        return this.citizenSleepHandler;
    }

    public void setVisibleStatusIfNone(VisibleCitizenStatus status) {
        if (this.getCitizenData().getStatus() == null) {
            this.getCitizenData().setVisibleStatus(status);
        }
    }

    @Override
    public float getRotationYaw() {
        return this.m_146908_();
    }

    @Override
    public float getRotationPitch() {
        return this.m_146909_();
    }

    @Override
    public boolean isDead() {
        return !this.m_6084_();
    }

    @Override
    public void setCitizenSleepHandler(ICitizenSleepHandler citizenSleepHandler) {
        this.citizenSleepHandler = citizenSleepHandler;
    }

    @Override
    public void setCitizenJobHandler(ICitizenJobHandler citizenJobHandler) {
        this.citizenJobHandler = citizenJobHandler;
    }

    @Override
    public void setCitizenExperienceHandler(ICitizenExperienceHandler citizenExperienceHandler) {
        this.citizenExperienceHandler = citizenExperienceHandler;
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource damageSource, float damage) {
        Player player;
        Entity entity = damageSource.m_7639_();
        if (entity instanceof Player && (player = (Player)entity).m_7500_() && player.m_21205_().m_41720_() == ModItems.scanAnalyzer) {
            CompoundTag tag = new CompoundTag();
            try {
                this.m_20223_(tag);
            }
            catch (Exception e) {
                Log.getLogger().warn("Error while saving:", (Throwable)e);
            }
            Entity.RemovalReason removalReason = this.m_146911_();
            Log.getLogger().warn("Entity:" + String.valueOf(this.m_7755_()) + " uuid:" + String.valueOf(this.m_20148_()) + " id:" + this.m_19879_() + " removed:" + this.m_213877_() + " colonyid:" + this.citizenColonyHandler.getColonyId() + " entitydata colony id:" + String.valueOf(this.m_20088_().m_135370_(DATA_COLONY_ID)) + " hascolony:" + (this.citizenColonyHandler.getColonyOrRegister() != null) + " registered:" + this.citizenColonyHandler.registered() + " world:" + String.valueOf(this.f_19853_) + " saved data:" + String.valueOf(tag) + " removalReason: " + String.valueOf(removalReason));
        }
        if (this.handleInWallDamage(damageSource)) {
            return false;
        }
        Entity sourceEntity = damageSource.m_7639_();
        if (!this.checkIfValidDamageSource(damageSource, damage)) {
            return false;
        }
        if (this.getCitizenJobHandler().getColonyJob() != null && this.getCitizenJobHandler().getColonyJob().ignoresDamage(damageSource)) {
            return false;
        }
        if (this.getCitizenColonyHandler().getColonyOrRegister() == null) {
            return super.m_6469_(damageSource, damage);
        }
        return this.handleDamagePerformed(damageSource, damage, sourceEntity);
    }

    private boolean handleInWallDamage(@NotNull DamageSource damageSource) {
        if (damageSource.m_269150_().m_203565_(DamageTypes.f_268612_)) {
            TeleportHelper.teleportCitizen(this, this.f_19853_, this.m_20183_());
            return true;
        }
        return damageSource.m_269150_().m_203565_(DamageTypes.f_268612_) && this.citizenSleepHandler.isAsleep() || Compatibility.isDynTreePresent() && damageSource.m_269150_().m_203565_(Compatibility.getDynamicTreeDamage()) || this.m_20147_();
    }

    private boolean checkIfValidDamageSource(DamageSource source, float damage) {
        Entity sourceEntity = source.m_7639_();
        if (sourceEntity instanceof EntityCitizen) {
            if (((EntityCitizen)sourceEntity).citizenColonyHandler.getColonyId() == this.citizenColonyHandler.getColonyId()) {
                return false;
            }
            IColony attackerColony = ((EntityCitizen)sourceEntity).citizenColonyHandler.getColonyOrRegister();
            if (attackerColony != null && this.citizenColonyHandler.getColonyOrRegister() != null && ((Boolean)MineColonies.getConfig().getServer().pvp_mode.get()).booleanValue()) {
                IPermissions permission = attackerColony.getPermissions();
                this.citizenColonyHandler.getColonyOrRegister().getPermissions().addPlayer(permission.getOwner(), permission.getOwnerName(), permission.getRank(4));
            }
        }
        if (sourceEntity instanceof Player) {
            if (sourceEntity instanceof ServerPlayer) {
                if (this.citizenColonyHandler.getColonyOrRegister().getRaiderManager().isRaided()) {
                    return false;
                }
                if (damage > 1.0f && !this.getCitizenColonyHandler().getColonyOrRegister().getPermissions().hasPermission((Player)sourceEntity, Action.HURT_CITIZEN)) {
                    return false;
                }
                if (this.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard) {
                    return IGuardBuilding.checkIfGuardShouldTakeDamage(this, (Player)sourceEntity);
                }
            } else {
                IColonyView colonyView = IColonyManager.getInstance().getColonyView(this.getCitizenColonyHandler().getColonyId(), (ResourceKey<Level>)this.f_19853_.m_46472_());
                return damage <= 1.0f || colonyView == null || colonyView.getPermissions().hasPermission((Player)sourceEntity, Action.HURT_CITIZEN);
            }
        }
        return true;
    }

    public float m_6113_() {
        return (float)Math.min(0.5, (double)super.m_6113_());
    }

    private boolean handleDamagePerformed(@NotNull DamageSource damageSource, float damage, Entity sourceEntity) {
        float damageInc = Math.min(damage, this.m_21233_() * 0.2f);
        if (this.citizenJobHandler.getColonyJob() instanceof JobNetherWorker && this.citizenData != null && damageSource.m_269150_().m_203565_(DamageSourceKeys.NETHER)) {
            damageInc = damage;
        }
        if (!(this.f_19853_.f_46443_ || this.m_20145_() || damageSource.m_269150_().m_203565_(DamageTypes.f_268671_))) {
            this.performMoveAway(sourceEntity);
        }
        this.m_21335_(damageSource.m_7639_());
        if (!this.f_19853_.f_46443_ && this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard && this.citizenData != null) {
            if (this.citizenJobHandler.getColonyJob() instanceof JobKnight && this.citizenColonyHandler.getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.BLOCK_ATTACKS) > 0.0 && this.m_217043_().m_188500_() < this.citizenColonyHandler.getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.BLOCK_ATTACKS)) {
                return false;
            }
            if (this.citizenData.getWorkBuilding() instanceof AbstractBuildingGuards && ((AbstractBuildingGuards)this.citizenData.getWorkBuilding()).shallRetrieveOnLowHealth() && (double)this.m_21223_() < (double)((int)this.m_21233_()) * 0.2) {
                damageInc = (float)((double)damageInc * (1.0 - this.citizenColonyHandler.getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.FLEEING_DAMAGE)));
            }
        }
        if (!super.m_6469_(damageSource, damageInc)) {
            return false;
        }
        if (damageSource.m_7639_() instanceof LivingEntity) {
            this.threatTable.addThreat((LivingEntity)damageSource.m_7639_(), (int)damageInc);
        }
        if (damageSource.m_269533_(DamageTypeTags.f_268745_) || damageSource.m_269533_(DamageTypeTags.f_268725_)) {
            return true;
        }
        if (!this.f_19853_.f_46443_) {
            CitizenItemUtils.updateArmorDamage(this, damageInc);
            if (this.citizenData != null) {
                this.getCitizenData().getCitizenHappinessHandler().addModifier(new ExpirationBasedHappinessModifier("damage", 2.0, new StaticHappinessSupplier(0.0), 1));
            }
        }
        return true;
    }

    private void performMoveAway(@Nullable Entity attacker) {
        if (!(attacker instanceof LivingEntity || this.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && !this.getCitizenJobHandler().getColonyJob().canAIBeInterrupted())) {
            EntityNavigationUtils.walkAwayFrom(this, this.m_20183_(), 5, 1.1);
            return;
        }
        if (attacker == null) {
            return;
        }
        if (this.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard) {
            this.callForHelp(attacker, 900);
            return;
        }
        this.citizenAI.addTransition(new AIOneTimeEventTarget<CitizenAIState>(CitizenAIState.FLEE));
        this.callForHelp(attacker, 90000);
        EntityNavigationUtils.walkAwayFrom(this, attacker.m_20183_(), 15, 1.1);
    }

    @Override
    public void callForHelp(Entity attacker, int guardHelpRange) {
        if (!(attacker instanceof LivingEntity) || this.callForHelpCooldown != 0) {
            return;
        }
        if (this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard && this.citizenJobHandler.getColonyJob(AbstractJobGuard.class).isAsleep()) {
            return;
        }
        this.callForHelpCooldown = 100;
        ArrayList<AbstractEntityCitizen> possibleGuards = new ArrayList<AbstractEntityCitizen>();
        for (ICitizenData entry : this.getCitizenColonyHandler().getColonyOrRegister().getCitizenManager().getCitizens()) {
            if (!entry.getEntity().isPresent() || !(entry.getJob() instanceof AbstractJobGuard) || entry.getId() == this.citizenData.getId() || BlockPosUtil.getDistanceSquared(entry.getEntity().get().m_20183_(), this.m_20183_()) >= (long)guardHelpRange || entry.getJob().getWorkerAI() == null) continue;
            ThreatTable table = ((EntityCitizen)entry.getEntity().get()).getThreatTable();
            table.addThreat((LivingEntity)attacker, 0);
            if (!((AbstractEntityAIGuard)entry.getJob().getWorkerAI()).canHelp(attacker.m_20183_())) continue;
            possibleGuards.add(entry.getEntity().get());
        }
        Collections.sort(possibleGuards, Comparator.comparingInt(guard -> (int)this.m_20183_().m_123331_((Vec3i)guard.m_20183_())));
        for (int i = 0; i < possibleGuards.size() && i <= 2; ++i) {
            ((AbstractEntityAIGuard)((AbstractEntityCitizen)possibleGuards.get(i)).getCitizenData().getJob().getWorkerAI()).startHelpCitizen((LivingEntity)attacker);
        }
    }

    protected void m_7324_(Entity entity) {
        AbstractEntityCitizen otherCitizen;
        if (!this.citizenSleepHandler.isAsleep()) {
            super.m_7324_(entity);
        }
        if (!this.f_19853_.f_46443_ && this.getCitizenData() != null && entity instanceof AbstractEntityCitizen && (otherCitizen = (AbstractEntityCitizen)entity).getCitizenData() != null) {
            this.getCitizenData().getCitizenDiseaseHandler().onCollission(otherCitizen.getCitizenData());
        }
    }

    @Override
    public void onPlayerCollide(Player player) {
        super.onPlayerCollide(player);
        if (this.citizenJobHandler.getColonyJob() != null && this.citizenJobHandler.getColonyJob().getWorkerAI() instanceof AbstractEntityAIBasic && !this.citizenJobHandler.getColonyJob().isGuard()) {
            ((AbstractEntityAIBasic)this.citizenJobHandler.getColonyJob().getWorkerAI()).setDelay(60);
        }
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.62f : 1.0f;
    }

    public void m_6667_(@NotNull DamageSource damageSource) {
        if (this.citizenColonyHandler.getColonyOrRegister() != null && this.getCitizenData() != null) {
            BlockPos gravePos;
            this.citizenColonyHandler.getColonyOrRegister().getRaiderManager().onLostCitizen(this.getCitizenData());
            this.citizenExperienceHandler.dropExperience();
            this.m_142687_(Entity.RemovalReason.KILLED);
            if (!(this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard)) {
                this.citizenColonyHandler.getColonyOrRegister().getCitizenManager().injectModifier(new ExpirationBasedHappinessModifier("death", 3.0, new StaticHappinessSupplier(0.0), 3));
            }
            this.triggerDeathAchievement(damageSource, this.citizenJobHandler.getColonyJob());
            if (!(this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard)) {
                this.citizenColonyHandler.getColonyOrRegister().getCitizenManager().updateCitizenMourn(this.citizenData, true);
            }
            this.getCitizenColonyHandler().getColonyOrRegister().getStatisticsManager().increment("death", this.getCitizenColonyHandler().getColonyOrRegister().getDay());
            if (!this.m_20145_()) {
                if (this.citizenColonyHandler.getColonyOrRegister().isCoordInColony(this.f_19853_, this.m_20183_())) {
                    gravePos = this.getCitizenColonyHandler().getColonyOrRegister().getGraveManager().createCitizenGrave(this.f_19853_, this.m_20183_(), this.citizenData);
                } else {
                    gravePos = null;
                    InventoryUtils.dropItemHandler((IItemHandler)this.citizenData.getInventory(), this.f_19853_, (int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_());
                }
            } else {
                gravePos = null;
            }
            if (this.getCitizenColonyHandler().getColonyOrRegister() != null && this.getCitizenData() != null) {
                MessageUtils.format(this.m_21231_().m_19293_()).append((Component)Component.m_237113_((String)"! ")).append((Component)Component.m_237110_((String)"block.blockhuttownhall.messagecolonistgravelocation", (Object[])new Object[]{BlockPosUtil.calcDirection(this.getCitizenColonyHandler().getColonyOrRegister().getCenter(), this.m_20183_()).getLongText()}).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)"message.positiondist", (Object[])new Object[]{this.m_146903_(), this.m_146904_(), this.m_146907_(), (int)BlockPosUtil.dist(this.m_20183_(), this.getCitizenColonyHandler().getColonyOrRegister().getCenter())}))))).append((Component)(!(this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard) ? Component.m_237110_((String)"com.minecolonies.coremod.mourning", (Object[])new Object[]{this.getCitizenData().getName()}) : Component.m_237119_())).append((Component)(gravePos != null ? Component.m_237115_((String)"com.minecolonies.coremod.gravespawned").m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)"message.positiondist", (Object[])new Object[]{gravePos.m_123341_(), gravePos.m_123342_(), gravePos.m_123343_(), (int)BlockPosUtil.dist(gravePos, this.getCitizenColonyHandler().getColonyOrRegister().getCenter())})))) : Component.m_237119_())).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(this.getCitizenColonyHandler().getColonyOrRegister()).forManagers();
            }
            if (this.citizenData.getJob() != null) {
                this.citizenData.getJob().onRemoval();
            }
            this.citizenColonyHandler.getColonyOrRegister().getCitizenManager().removeCivilian(this.getCitizenData());
            String deathCause = Component.m_237113_((String)damageSource.m_6157_((LivingEntity)this).getString()).getString().replaceFirst(this.m_5446_().getString(), "Citizen");
            this.citizenColonyHandler.getColonyOrRegister().getEventDescriptionManager().addEventDescription(new CitizenDiedEvent(this.m_20183_(), this.citizenData.getName(), deathCause));
            IMinecoloniesAPI.getInstance().getEventBus().post(new CitizenDiedModEvent(this.citizenData, damageSource));
        }
        super.m_6667_(damageSource);
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        super.m_142687_(reason);
        IMinecoloniesAPI.getInstance().getEventBus().post(new CitizenRemovedModEvent(this.citizenColonyHandler.getColony(), this.citizenId, reason));
    }

    private void triggerDeathAchievement(DamageSource source, IJob<?> job) {
        if (job != null) {
            job.triggerDeathAchievement(source, this);
        }
    }

    protected void m_5907_() {
        for (int i = 0; i < this.getInventoryCitizen().getSlots(); ++i) {
            ItemStack itemstack = this.getCitizenData().getInventory().getStackInSlot(i);
            if (ItemStackUtils.getSize(itemstack) <= 0) continue;
            CitizenItemUtils.entityDropItem(this, itemstack);
        }
    }

    @NotNull
    public Iterable<ItemStack> m_20158_() {
        if (this.citizenData != null) {
            return this.citizenData.getInventory().getIterableArmorAndHandInv();
        }
        if (this.citizenDataView != null) {
            return this.citizenDataView.getInventory().getIterableArmorAndHandInv();
        }
        return super.m_20158_();
    }

    @NotNull
    public ItemStack m_6844_(EquipmentSlot slotType) {
        switch (slotType.m_20743_()) {
            case HAND: {
                return super.m_6844_(slotType);
            }
            case ARMOR: {
                if (this.citizenData != null) {
                    return this.citizenData.getInventory().getArmorInSlot(slotType);
                }
                if (this.citizenDataView != null) {
                    return this.citizenDataView.getInventory().getArmorInSlot(slotType);
                }
                return super.m_6844_(slotType);
            }
        }
        return ItemStack.f_41583_;
    }

    public int m_21230_() {
        if (this.citizenJobHandler.getColonyJob() instanceof JobKnight) {
            return (int)((double)super.m_21230_() * (1.0 + this.citizenColonyHandler.getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MELEE_ARMOR)));
        }
        if (this.citizenJobHandler.getColonyJob() instanceof JobRanger) {
            return (int)((double)super.m_21230_() * (1.0 + this.citizenColonyHandler.getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARCHER_ARMOR)));
        }
        return super.m_21230_();
    }

    protected void m_7909_(float damage) {
        if (this.m_21120_(this.m_7655_()).m_41720_() instanceof ShieldItem) {
            if (this.m_21223_() > damage * 0.5f) {
                float blockDamage = CombatRules.m_19272_((float)(damage * 0.5f), (float)this.m_21230_(), (float)((float)this.m_21051_(Attributes.f_22285_).m_22135_()));
                this.m_21153_(this.m_21223_() - Math.max(0.5f, blockDamage));
            }
            CitizenItemUtils.damageItemInHand(this, this.m_7655_(), (int)(damage * 0.5f));
        }
        super.m_7909_(damage);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            ICitizenData data = this.getCitizenData();
            if (data == null) {
                return super.getCapability(capability, facing);
            }
            InventoryCitizen inv = data.getInventory();
            return LazyOptional.of(() -> inv);
        }
        return super.getCapability(capability, facing);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EntityCitizen) {
            EntityCitizen citizen = (EntityCitizen)obj;
            return citizen.citizenColonyHandler.getColonyId() == this.citizenColonyHandler.getColonyId() && citizen.citizenId == this.citizenId;
        }
        return false;
    }

    public int hashCode() {
        if (this.citizenColonyHandler == null) {
            return super.hashCode();
        }
        return Objects.hash(this.citizenId, this.citizenColonyHandler.getColonyId());
    }

    public void m_142467_(Entity.RemovalReason reason) {
        this.citizenColonyHandler.onCitizenRemoved();
        super.m_142467_(reason);
    }

    public void m_6593_(@Nullable Component name) {
        if (this.citizenData != null && this.citizenColonyHandler.getColonyOrRegister() != null && name != null) {
            this.citizenData.setName(name.getString());
            super.m_6593_(name);
        }
    }

    public void m_21373_() {
        super.m_21373_();
    }

    protected void m_7581_(ItemEntity itemEntity) {
    }

    public boolean m_8023_() {
        return true;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        if (player.m_5833_()) {
            return null;
        }
        return new ContainerCitizenInventory(id, inv, this.citizenColonyHandler.getColonyId(), this.citizenId);
    }

    @Override
    public void setTexture() {
        super.setTexture();
    }

    public void m_6210_() {
        boolean flag;
        EntityDimensions newSize;
        EntityDimensions afterEventSize;
        EntityDimensions oldSize = this.f_19815_;
        Pose pose = this.m_20089_();
        this.f_19815_ = afterEventSize = (newSize = this.m_6972_(pose));
        this.f_19816_ = this.m_6380_(pose, newSize);
        this.m_20090_();
        boolean bl = flag = (double)afterEventSize.f_20377_ <= 4.0 && (double)afterEventSize.f_20378_ <= 4.0;
        if (!this.m_9236_().f_46443_ && !this.f_19803_ && !this.f_19794_ && flag && (afterEventSize.f_20377_ > oldSize.f_20377_ || afterEventSize.f_20378_ > oldSize.f_20378_)) {
            Vec3 vec3 = this.m_20182_().m_82520_(0.0, (double)oldSize.f_20378_ / 2.0, 0.0);
            double d0 = (double)Math.max(0.0f, afterEventSize.f_20377_ - oldSize.f_20377_) + 1.0E-6;
            double d1 = (double)Math.max(0.0f, afterEventSize.f_20378_ - oldSize.f_20378_) + 1.0E-6;
            VoxelShape voxelshape = Shapes.m_83064_((AABB)AABB.m_165882_((Vec3)vec3, (double)d0, (double)d1, (double)d0));
            EntityDimensions finalEntitydimensions = afterEventSize;
            this.m_9236_().m_151418_((Entity)this, voxelshape, vec3, (double)afterEventSize.f_20377_, (double)afterEventSize.f_20378_, (double)afterEventSize.f_20377_).ifPresent(p_185956_ -> this.m_146884_(p_185956_.m_82520_(0.0, (double)(-finalEntitydimensions.f_20378_) / 2.0, 0.0)));
        }
    }

    @Override
    public void queueSound(@NotNull SoundEvent soundEvent, BlockPos pos, int length, int repetitions) {
        if (soundEvent == null || !ForgeRegistries.SOUND_EVENTS.containsKey(soundEvent.m_11660_())) {
            return;
        }
        Network.getNetwork().sendToPosition(new PlaySoundForCitizenMessage(this.m_19879_(), soundEvent, this.m_5720_(), pos, this.f_19853_, length, repetitions), new PacketDistributor.TargetPoint((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 16.0, this.f_19853_.m_46472_()));
    }

    @Override
    public void queueSound(@NotNull SoundEvent soundEvent, BlockPos pos, int length, int repetitions, float volume, float pitch) {
        if (soundEvent == null || !ForgeRegistries.SOUND_EVENTS.containsKey(soundEvent.m_11660_())) {
            return;
        }
        Network.getNetwork().sendToPosition(new PlaySoundForCitizenMessage(this.m_19879_(), soundEvent, this.m_5720_(), pos, this.f_19853_, volume, pitch, length, repetitions), new PacketDistributor.TargetPoint((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 16.0, this.f_19853_.m_46472_()));
    }

    public boolean isActive() {
        return this.f_19853_.f_46443_ ? this.entityStateController.getState() == EntityState.ACTIVE_CLIENT : this.entityStateController.getState() == EntityState.ACTIVE_SERVER;
    }

    @Override
    public ThreatTable getThreatTable() {
        return this.threatTable;
    }

    public ITickRateStateMachine<IState> getCitizenAI() {
        return this.citizenAI;
    }

    public boolean m_20162_() {
        if (this.citizenSleepHandler.isAsleep()) {
            return true;
        }
        return super.m_20162_();
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        super.m_7350_(dataAccessor);
        if (this.citizenColonyHandler != null) {
            this.citizenColonyHandler.onSyncDataUpdate(dataAccessor);
        }
        if (this.m_9236_().f_46443_ && dataAccessor == DATA_STYLE && !TextureReloadListener.TEXTURE_PACKS.contains(this.m_20088_().m_135370_(DATA_STYLE))) {
            this.m_20088_().m_135381_(DATA_STYLE, (Object)TextureReloadListener.TEXTURE_PACKS.get(0));
        }
    }

    public boolean m_142038_() {
        return this.isGlowing || super.m_142038_();
    }

    public void setGlowing(boolean isGlowing) {
        this.isGlowing = isGlowing;
    }

    public CombatTracker m_21231_() {
        return this.combatTracker;
    }

    public void setMaxAir(int maxAir) {
        this.maxAir = maxAir;
    }

    @Override
    public int getTeamId() {
        return this.citizenColonyHandler.getColonyId();
    }

    private boolean decreaseIdleSaturation() {
        if (this.citizenData != null && this.m_9236_() != null && !this.m_9236_().m_46462_() && !this.citizenSleepHandler.isAsleep()) {
            double decrease;
            int buildingLevel = this.citizenData.getHomeBuilding() == null ? 0 : this.citizenData.getHomeBuilding().getBuildingLevelEquivalent();
            switch (buildingLevel) {
                case 1: {
                    double d = 0.2;
                    break;
                }
                case 2: {
                    double d = 0.256;
                    break;
                }
                case 3: {
                    double d = 0.32;
                    break;
                }
                case 4: {
                    double d = 0.4;
                    break;
                }
                case 5: {
                    double d = 0.5;
                    break;
                }
                default: {
                    double d = decrease = 0.1;
                }
            }
            if (this.citizenData.getJob() != null) {
                decrease *= this.citizenData.getJob().getSaturationFactor();
            }
            if (this.cachedActionSaturationDecrease != 0.0) {
                decrease += Math.min(decrease / 2.0, this.cachedActionSaturationDecrease);
                this.cachedActionSaturationDecrease = 0.0;
            }
            if (this.citizenData.isChild()) {
                decrease /= 2.0;
            }
            this.citizenData.decreaseSaturation(decrease);
        }
        return false;
    }
}

