/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.crafting;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.IStateSupplier;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.StatsUtil;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.FurnaceUserModule;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.AbstractJobCrafter;
import com.minecolonies.core.entity.ai.workers.crafting.AbstractEntityAICrafting;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIRequestSmelter<J extends AbstractJobCrafter<?, J>, B extends AbstractBuilding>
extends AbstractEntityAICrafting<J, B> {
    private static final double BASE_XP_GAIN = 5.0;
    private BlockPos furnacePos = null;

    public AbstractEntityAIRequestSmelter(@NotNull J smelteryJob) {
        super(smelteryJob);
        super.registerTargets(new AIEventTarget<IStateSupplier<Object>>(AIBlockingEventType.EVENT, this::checkFurnaceFuel, this::getState, 200), new AIEventTarget<IStateSupplier<Object>>(AIBlockingEventType.EVENT, this::accelerateFurnaces, this::getState, 20), new AIEventTarget<AIWorkerState>(AIBlockingEventType.EVENT, this::checkForLeftOvers, AIWorkerState.RETRIEVING_UNRELATED_PRODUCT_FROM_FURNACE, 200), new AITarget<Object>(AIWorkerState.RETRIEVING_END_PRODUCT_FROM_FURNACE, this::retrieveProductFromFurnace, 20), new AITarget<Object>(AIWorkerState.RETRIEVING_UNRELATED_PRODUCT_FROM_FURNACE, this::retrieveUnrelatedProductFromFurnace, 20), new AITarget<Object>(AIWorkerState.FILL_UP_FURNACES, this::fillUpFurnace, 20), new AITarget<Object>(AIWorkerState.ADD_FUEL_TO_FURNACE, this::addFuelToFurnace, 20));
    }

    private boolean checkForLeftOvers() {
        BlockPos checkPos = this.getFurnaceToRetrieveUnrelatedInputFrom();
        if (checkPos != null) {
            this.furnacePos = checkPos;
            return true;
        }
        return false;
    }

    private boolean checkFurnaceFuel() {
        List<ItemStack> possibleFuels = this.getActivePossibleFuels();
        FurnaceUserModule module = this.building.getModule(BuildingModules.FURNACE);
        if (!InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels)) && InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels), 1) < 1 && !this.building.hasWorkerOpenRequestsOfType(this.worker.getCitizenData().getId(), TypeToken.of(StackList.class))) {
            this.worker.getCitizenData().createRequestAsync(new StackList(possibleFuels, "com.minecolonies.coremod.request.burnable", 64 * module.getFurnaces().size(), 1));
        }
        return false;
    }

    private boolean accelerateFurnaces() {
        int accelerationTicks = this.worker.getCitizenData().getCitizenSkillHandler().getLevel(this.getModuleForJob().getSecondarySkill()) / 10 * 2;
        Level world = this.building.getColony().getWorld();
        for (BlockPos pos : this.building.getModule(BuildingModules.FURNACE).getFurnaces()) {
            BlockEntity entity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos) || !((entity = world.m_7702_(pos)) instanceof FurnaceBlockEntity)) continue;
            FurnaceBlockEntity furnace = (FurnaceBlockEntity)entity;
            for (int i = 0; i < accelerationTicks; ++i) {
                if (!furnace.m_58425_()) continue;
                FurnaceBlockEntity.m_155013_((Level)furnace.m_58904_(), (BlockPos)entity.m_58899_(), (BlockState)entity.m_58900_(), (AbstractFurnaceBlockEntity)furnace);
            }
        }
        return false;
    }

    @Override
    protected int getExtendedCount(ItemStack stack) {
        if (this.currentRecipeStorage != null && this.currentRecipeStorage.getIntermediate() == Blocks.f_50094_) {
            int count = 0;
            for (BlockPos pos : this.building.getModule(BuildingModules.FURNACE).getFurnaces()) {
                BlockEntity entity = this.world.m_7702_(pos);
                if (!(entity instanceof FurnaceBlockEntity)) continue;
                FurnaceBlockEntity furnaceBlockEntity = (FurnaceBlockEntity)entity;
                ItemStack outputSlot = furnaceBlockEntity.m_8020_(0);
                ItemStack resultSlot = furnaceBlockEntity.m_8020_(2);
                if (ItemStackUtils.compareItemStacksIgnoreStackSize(stack, outputSlot).booleanValue()) {
                    count += outputSlot.m_41613_();
                    continue;
                }
                if (!ItemStackUtils.compareItemStacksIgnoreStackSize(stack, resultSlot).booleanValue()) continue;
                count += resultSlot.m_41613_();
            }
            return count;
        }
        return 0;
    }

    private IAIState addFuelToFurnace() {
        BlockEntity entity;
        List<ItemStack> possibleFuels = this.getActivePossibleFuels();
        if (!InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels))) {
            if (InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels), 1) >= 1) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels), 64);
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            this.furnacePos = null;
            return AIWorkerState.IDLE;
        }
        if (this.furnacePos == null) {
            return AIWorkerState.IDLE;
        }
        if (!this.walkToWorkPos(this.furnacePos)) {
            return this.getState();
        }
        if (WorldUtil.isBlockLoaded((LevelAccessor)this.world, this.furnacePos) && (entity = this.world.m_7702_(this.furnacePos)) instanceof FurnaceBlockEntity) {
            FurnaceBlockEntity furnace = (FurnaceBlockEntity)entity;
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels)) && ItemStackUtils.isEmpty(furnace.m_8020_(1))) {
                InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels), 64, (IItemHandler)new InvWrapper((Container)furnace), 1);
            }
        }
        this.furnacePos = null;
        return AIWorkerState.IDLE;
    }

    private IAIState retrieveProductFromFurnace() {
        int count;
        FurnaceBlockEntity furnaceBlockEntity;
        if (this.furnacePos == null || this.currentRecipeStorage == null || this.currentRequest == null) {
            return AIWorkerState.START_WORKING;
        }
        BlockEntity entity = this.world.m_7702_(this.furnacePos);
        if (!(entity instanceof FurnaceBlockEntity) || ItemStackUtils.isEmpty((furnaceBlockEntity = (FurnaceBlockEntity)entity).m_8020_(2))) {
            this.furnacePos = null;
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkToWorkPos(this.furnacePos)) {
            return this.getState();
        }
        this.furnacePos = null;
        ItemStack stack = furnaceBlockEntity.m_8020_(2).m_41777_();
        if (this.extractFromFurnaceSlot(furnaceBlockEntity, 2) && (count = stack.m_41613_()) > 0) {
            if (ItemStackUtils.compareItemStacksIgnoreStackSize(this.currentRecipeStorage.getPrimaryOutput(), stack).booleanValue()) {
                ItemStack requestStack = ((PublicCrafting)this.currentRequest.getRequest()).getStack().m_41777_();
                requestStack.m_41764_(count);
                this.currentRequest.addDelivery(requestStack);
                ((AbstractJobCrafter)this.job).setCraftCounter(((AbstractJobCrafter)this.job).getCraftCounter() + count);
                if (((AbstractJobCrafter)this.job).getMaxCraftingCount() == 0) {
                    ((AbstractJobCrafter)this.job).setMaxCraftingCount(((PublicCrafting)this.currentRequest.getRequest()).getCount());
                }
                if (((AbstractJobCrafter)this.job).getCraftCounter() >= ((AbstractJobCrafter)this.job).getMaxCraftingCount()) {
                    return this.finalizeCraftingTask();
                }
            } else {
                ((AbstractJobCrafter)this.job).getSecondaryOutputs().addTo((Object)new ItemStorage(stack), stack.m_41613_());
            }
        }
        return AIWorkerState.START_WORKING;
    }

    private IAIState retrieveUnrelatedProductFromFurnace() {
        int count;
        FurnaceBlockEntity furnaceBlockEntity;
        if (this.furnacePos == null) {
            return AIWorkerState.START_WORKING;
        }
        BlockEntity entity = this.world.m_7702_(this.furnacePos);
        if (!(entity instanceof FurnaceBlockEntity) || ItemStackUtils.isEmpty((furnaceBlockEntity = (FurnaceBlockEntity)entity).m_8020_(0)) || this.currentRecipeStorage != null && ItemStackUtils.compareItemStacksIgnoreStackSize(this.currentRecipeStorage.getCleanedInput().get(0).getItemStack(), furnaceBlockEntity.m_8020_(0)).booleanValue()) {
            this.furnacePos = null;
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkToWorkPos(this.furnacePos)) {
            return this.getState();
        }
        this.furnacePos = null;
        ItemStack stack = furnaceBlockEntity.m_8020_(0);
        if (this.extractFromFurnaceSlot(furnaceBlockEntity, 0) && (count = stack.m_41613_()) > 0) {
            ((AbstractJobCrafter)this.job).getSecondaryOutputs().addTo((Object)new ItemStorage(stack), stack.m_41613_());
            return AIWorkerState.INVENTORY_FULL;
        }
        return AIWorkerState.START_WORKING;
    }

    private IAIState fillUpFurnace() {
        int maxFurnaces;
        if (this.furnacePos == null || this.currentRecipeStorage == null) {
            return AIWorkerState.START_WORKING;
        }
        if (((AbstractJobCrafter)this.job).getMaxCraftingCount() == 0) {
            ((AbstractJobCrafter)this.job).setMaxCraftingCount(((PublicCrafting)this.currentRequest.getRequest()).getCount());
        }
        ItemStack inputStack = this.currentRecipeStorage.getCleanedInput().get(0).getItemStack();
        Predicate<ItemStack> smeltablePredicate = stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(inputStack, stack);
        int smeltableInInventory = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, inputStack));
        int smeltableInFurnaces = this.getExtendedCount(inputStack);
        int resultInFurnaces = this.getExtendedCount(this.currentRecipeStorage.getPrimaryOutput());
        int targetCount = ((AbstractJobCrafter)this.job).getMaxCraftingCount() - ((AbstractJobCrafter)this.job).getCraftCounter() - smeltableInFurnaces - resultInFurnaces - smeltableInInventory;
        if (((AbstractJobCrafter)this.job).getMaxCraftingCount() - ((AbstractJobCrafter)this.job).getCraftCounter() - smeltableInFurnaces - resultInFurnaces <= 0) {
            return AIWorkerState.START_WORKING;
        }
        if (smeltableInInventory == 0) {
            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(smeltablePredicate, targetCount);
            this.furnacePos = null;
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        int burningFurnaces = this.countOfBurningFurnaces();
        if (burningFurnaces > (maxFurnaces = this.getMaxUsableFurnaces())) {
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkToWorkPos(this.furnacePos)) {
            return this.getState();
        }
        int pendingCount = ((AbstractJobCrafter)this.job).getMaxCraftingCount() - ((AbstractJobCrafter)this.job).getCraftCounter() - smeltableInFurnaces - resultInFurnaces;
        if (pendingCount <= 0) {
            return AIWorkerState.START_WORKING;
        }
        int availableSmeltable = Math.min(pendingCount, smeltableInInventory);
        BlockEntity entity = this.world.m_7702_(this.furnacePos);
        this.furnacePos = null;
        if (entity instanceof FurnaceBlockEntity) {
            FurnaceBlockEntity furnace = (FurnaceBlockEntity)entity;
            if (this.worker.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                this.worker.m_21008_(InteractionHand.MAIN_HAND, inputStack.m_41777_());
            }
            if (ItemStackUtils.hasFuelInFurnaceAndNoSmeltable(furnace)) {
                int toTransfer = 0;
                int availableFurnaces = maxFurnaces - burningFurnaces;
                if (availableFurnaces >= 1) {
                    toTransfer = availableSmeltable > 64 * availableFurnaces ? 64 : (availableFurnaces == 1 ? availableSmeltable : Math.min(availableSmeltable / availableFurnaces + availableSmeltable % availableFurnaces, 64));
                }
                if (toTransfer > 0) {
                    CitizenItemUtils.hitBlockWithToolInHand(this.worker, this.furnacePos);
                    InventoryUtils.transferXInItemHandlerIntoSlotInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), smeltablePredicate, toTransfer, (IItemHandler)new InvWrapper((Container)furnace), 0);
                }
            }
        }
        return AIWorkerState.CRAFT;
    }

    @Override
    public IAIState executeCraftingAction(int toolSlot) {
        int burning;
        if (this.currentRecipeStorage == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.currentRecipeStorage.getIntermediate() != Blocks.f_50094_) {
            return super.executeCraftingAction(toolSlot);
        }
        if (this.building.getModule(BuildingModules.FURNACE).getFurnaces().isEmpty()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.bakery.nofurnace"), ChatPriority.BLOCKING));
            }
            this.setDelay(5);
            return AIWorkerState.START_WORKING;
        }
        if (!this.areFurnacesLoaded()) {
            return AIWorkerState.START_WORKING;
        }
        List<ItemStack> possibleFuels = this.getAllowedFuel();
        if (possibleFuels.isEmpty()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.furnaceuser.nofuel"), ChatPriority.BLOCKING));
            }
            return this.getState();
        }
        this.furnacePos = this.getFurnaceToRetrieveOutputFrom();
        if (this.furnacePos != null) {
            return AIWorkerState.RETRIEVING_END_PRODUCT_FROM_FURNACE;
        }
        this.furnacePos = this.getFurnaceToRetrieveUnrelatedInputFrom();
        if (this.furnacePos != null) {
            return AIWorkerState.RETRIEVING_UNRELATED_PRODUCT_FROM_FURNACE;
        }
        if (InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels), 1) > 1 || InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels))) {
            this.furnacePos = this.getFurnaceWithoutFuel();
            if (this.furnacePos != null) {
                return AIWorkerState.ADD_FUEL_TO_FURNACE;
            }
        }
        if ((burning = this.countOfBurningFurnaces()) > 0 && burning >= this.getMaxUsableFurnaces()) {
            this.setDelay(20);
            return this.getState();
        }
        this.furnacePos = this.getEmptyFurnaceWithFuel();
        if (this.furnacePos != null) {
            return AIWorkerState.FILL_UP_FURNACES;
        }
        return AIWorkerState.START_WORKING;
    }

    private BlockPos getEmptyFurnaceWithFuel() {
        FurnaceUserModule module = this.building.getModule(BuildingModules.FURNACE);
        for (BlockPos pos : module.getFurnaces()) {
            FurnaceBlockEntity furnaceBlockEntity;
            BlockEntity entity = this.world.m_7702_(pos);
            if (!(entity instanceof FurnaceBlockEntity) || !ItemStackUtils.isEmpty((furnaceBlockEntity = (FurnaceBlockEntity)entity).m_8020_(0)) || !ItemStackUtils.isEmpty(furnaceBlockEntity.m_8020_(2)) || ItemStackUtils.isEmpty(furnaceBlockEntity.m_8020_(1))) continue;
            return pos;
        }
        return null;
    }

    private BlockPos getFurnaceWithoutFuel() {
        for (BlockPos pos : this.building.getModule(BuildingModules.FURNACE).getFurnaces()) {
            FurnaceBlockEntity furnace;
            BlockEntity entity = this.world.m_7702_(pos);
            if (!(entity instanceof FurnaceBlockEntity) || (furnace = (FurnaceBlockEntity)entity).m_58425_() || !furnace.m_8020_(1).m_41619_()) continue;
            return pos;
        }
        return null;
    }

    private BlockPos getFurnaceToRetrieveOutputFrom() {
        for (BlockPos pos : this.building.getModule(BuildingModules.FURNACE).getFurnaces()) {
            FurnaceBlockEntity furnace;
            BlockEntity entity = this.world.m_7702_(pos);
            if (!(entity instanceof FurnaceBlockEntity) || (furnace = (FurnaceBlockEntity)entity).m_58425_() && !furnace.m_8020_(0).m_41619_()) continue;
            int countInResultSlot = 0;
            if (!ItemStackUtils.isEmpty(furnace.m_8020_(2)) && (countInResultSlot = furnace.m_8020_(2).m_41613_()) >= furnace.m_8020_(2).m_41741_()) {
                return pos;
            }
            if (countInResultSlot <= 0) continue;
            return pos;
        }
        return null;
    }

    private BlockPos getFurnaceToRetrieveUnrelatedInputFrom() {
        for (BlockPos pos : this.building.getModule(BuildingModules.FURNACE).getFurnaces()) {
            BlockEntity entity = this.world.m_7702_(pos);
            if (entity instanceof FurnaceBlockEntity) {
                FurnaceBlockEntity furnace = (FurnaceBlockEntity)entity;
                if (furnace.m_8020_(0).m_41619_() || this.currentRecipeStorage != null && ItemStackUtils.compareItemStacksIgnoreStackSize(furnace.m_8020_(0), this.currentRecipeStorage.getCleanedInput().get(0).getItemStack()).booleanValue()) continue;
                return pos;
            }
            this.building.getModule(BuildingModules.FURNACE).removeFromFurnaces(pos);
            return null;
        }
        return null;
    }

    private boolean extractFromFurnaceSlot(FurnaceBlockEntity furnace, int slot) {
        ItemStack stack = furnace.m_8020_(slot);
        Component name = stack.m_41786_();
        int count = stack.m_41613_();
        if (stack.m_41619_()) {
            return false;
        }
        boolean success = InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler((IItemHandler)new InvWrapper((Container)furnace), slot, (IItemHandler)this.worker.getInventoryCitizen());
        if (slot == 2 && success) {
            this.recordSmeltingBuildingStats(name, count);
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
        }
        return success;
    }

    private boolean areFurnacesLoaded() {
        for (BlockPos pos : this.building.getModule(BuildingModules.FURNACE).getFurnaces()) {
            if (WorldUtil.isBlockLoaded((LevelAccessor)this.world, pos)) continue;
            return false;
        }
        return true;
    }

    private int countOfBurningFurnaces() {
        int count = 0;
        Level world = this.building.getColony().getWorld();
        for (BlockPos pos : this.building.getModule(BuildingModules.FURNACE).getFurnaces()) {
            FurnaceBlockEntity furnace;
            BlockEntity entity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos) || !((entity = world.m_7702_(pos)) instanceof FurnaceBlockEntity) || !(furnace = (FurnaceBlockEntity)entity).m_58425_() || furnace.m_8020_(0).m_41619_()) continue;
            ++count;
        }
        return count;
    }

    private int getMaxUsableFurnaces() {
        int maxSkillFurnaces = this.worker.getCitizenData().getCitizenSkillHandler().getLevel(this.getModuleForJob().getPrimarySkill()) / 10 + 1;
        int count = 0;
        for (BlockPos pos : this.building.getModule(BuildingModules.FURNACE).getFurnaces()) {
            FurnaceBlockEntity furnace;
            BlockEntity entity = this.world.m_7702_(pos);
            if (!(entity instanceof FurnaceBlockEntity) || (furnace = (FurnaceBlockEntity)entity).m_8020_(1).m_41619_()) continue;
            ++count;
        }
        return Math.min(maxSkillFurnaces, count);
    }

    private List<ItemStack> getAllowedFuel() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStorage storage : this.building.getModule(BuildingModules.ITEMLIST_FUEL).getList()) {
            ItemStack stack = storage.getItemStack().m_41777_();
            stack.m_41764_(stack.m_41741_());
            list.add(stack);
        }
        return list;
    }

    private List<ItemStack> getActivePossibleFuels() {
        List<ItemStack> possibleFuels = this.getAllowedFuel();
        if (possibleFuels.isEmpty()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.furnaceuser.nofuel"), ChatPriority.IMPORTANT));
            }
            return ImmutableList.of();
        }
        if (this.currentRecipeStorage != null) {
            possibleFuels.removeIf(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.currentRecipeStorage.getPrimaryOutput()));
            possibleFuels.removeIf(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.currentRecipeStorage.getCleanedInput().get(0).getItemStack()));
        }
        return possibleFuels;
    }

    private static Predicate<ItemStack> isCorrectFuel(List<ItemStack> possibleFuels) {
        return item -> ItemStackUtils.compareItemStackListIgnoreStackSize(possibleFuels, item);
    }

    protected String getSmeltingStatName() {
        return "items_smelted_detail";
    }

    protected void recordSmeltingBuildingStats(Component hoverName, int count) {
        StatsUtil.trackStatByName((IBuilding)this.building, this.getSmeltingStatName(), hoverName, count);
    }
}

