/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.minimal;

import com.minecolonies.api.entity.other.AbstractFastMinecoloniesEntity;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.ColonyConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class EntityAIInteractToggleAble
extends Goal {
    private static final int DEFAULT_HEIGHT_TO_CHECK = 2;
    private static final int LENGTH_TO_CHECK = 2;
    private static final double MIN_DISTANCE = 4.0;
    private static final double MAX_DISTANCE = 5.0;
    public static final ToggleAble FENCE_TOGGLE = new FenceToggle();
    public static final ToggleAble TRAP_TOGGLE = new TrapToggle();
    public static final ToggleAble DOOR_TOGGLE = new DoorToggle();
    protected AbstractFastMinecoloniesEntity entity;
    private Map<BlockPos, Boolean> toggleAblePositions = new HashMap<BlockPos, Boolean>();
    private final List<ToggleAble> toggleAbles;
    private final List<ToggleAble> myToggled;
    private int updateTimer = 0;
    private int executeTimerSlow = 60;
    private final int offSet;

    public EntityAIInteractToggleAble(@NotNull AbstractFastMinecoloniesEntity entityIn, ToggleAble ... toggleAbles) {
        this.entity = entityIn;
        this.toggleAbles = Arrays.asList(toggleAbles);
        this.myToggled = new ArrayList<ToggleAble>();
        if (!(entityIn.m_21573_() instanceof GroundPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for EntityAIInteractToggleAble");
        }
        this.offSet = entityIn.f_19853_.f_46441_.m_188503_(20);
    }

    public boolean m_8036_() {
        if ((this.entity.hadHorizontalCollission() || this.entity.f_19863_ && !this.entity.m_20096_()) && this.updateTimer-- <= 0) {
            this.updateTimer = 10;
            return this.checkPath();
        }
        if (this.executeTimerSlow-- <= 0) {
            this.executeTimerSlow = 50;
            return this.checkPathBlocksBelow();
        }
        return false;
    }

    public void m_8056_() {
        super.m_8056_();
        this.updateTimer = 0;
    }

    private boolean checkPath() {
        @NotNull GroundPathNavigation pathnavigateground = (GroundPathNavigation)this.entity.m_21573_();
        Path path = pathnavigateground.m_26570_();
        this.checkPathBlocksCollided(path);
        return !this.toggleAblePositions.isEmpty();
    }

    private void checkPathBlocksCollided(Path path) {
        if (path == null || path.m_77392_()) {
            this.resetAll();
            return;
        }
        int maxLengthToCheck = Math.min(path.m_77399_() + 2, path.m_77398_());
        for (int i = Math.max(0, path.m_77399_() - 2); i < maxLengthToCheck; ++i) {
            if (i == path.m_77398_() - 1) {
                return;
            }
            Node current = path.m_77375_(i);
            Node next = path.m_77375_(i + 1);
            if (next.f_77271_ == current.f_77271_ && next.f_77272_ == current.f_77272_ && next.f_77273_ == current.f_77273_) continue;
            Direction dir = current.f_77271_ == next.f_77271_ && current.f_77273_ == next.f_77273_ ? Direction.EAST : BlockPosUtil.directionFromDelta(next.f_77271_ - current.f_77271_, 0, next.f_77273_ - current.f_77273_);
            for (int level = 0; level < this.getHeightToCheck(path, i); ++level) {
                this.checkPosAndAdd((Entity)this.entity, dir, new BlockPos(current.f_77271_, current.f_77272_ + level, current.f_77273_));
                this.checkPosAndAdd((Entity)this.entity, dir, new BlockPos(next.f_77271_, next.f_77272_ + level, next.f_77273_));
            }
        }
    }

    private void checkPosAndAdd(Entity entity, Direction dir, BlockPos pos) {
        VoxelShape collisionShape;
        if (this.toggleAblePositions.containsKey(pos)) {
            return;
        }
        BlockState state = entity.f_19853_.m_8055_(pos);
        if (this.entity.m_20275_(pos.m_123341_(), this.entity.m_20186_(), pos.m_123343_()) <= 4.0 && this.isValidBlockState(state) && (collisionShape = state.m_60812_((BlockGetter)entity.f_19853_, pos)).m_83288_((dir = dir.m_122427_()).m_122434_()) + 0.1 < (double)entity.m_20205_() && collisionShape.m_83297_(dir.m_122434_()) + 0.1 + (double)entity.m_20205_() > 1.0) {
            this.toggleAblePositions.put(pos, (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_));
        }
    }

    private boolean checkPathBlocksBelow() {
        @NotNull GroundPathNavigation pathnavigateground = (GroundPathNavigation)this.entity.m_21573_();
        Path path = pathnavigateground.m_26570_();
        if (path == null || path.m_77392_()) {
            this.resetAll();
            return false;
        }
        int maxLengthToCheck = Math.min(path.m_77399_() + 2, path.m_77398_());
        for (int i = Math.max(0, path.m_77399_() - 2); i < maxLengthToCheck; ++i) {
            Node pathpoint = path.m_77375_(i);
            for (int level = 0; level < this.getHeightToCheck(path, i); ++level) {
                BlockPos pos = new BlockPos(pathpoint.f_77271_, pathpoint.f_77272_ + level, pathpoint.f_77273_);
                if (!this.entity.m_20183_().equals((Object)pos) && !this.entity.m_20183_().m_7495_().equals((Object)pos)) continue;
                BlockState state = this.entity.f_19853_.m_8055_(pos);
                if (!(this.entity.m_20275_(pos.m_123341_(), this.entity.m_20186_(), pos.m_123343_()) <= 4.0) || !this.isValidBlockState(state)) continue;
                if (level > 0) {
                    this.toggleAblePositions.put(pos, (Boolean)this.entity.f_19853_.m_8055_(pos).m_61143_((Property)BlockStateProperties.f_61446_));
                    continue;
                }
                if (i >= path.m_77398_() - 1) continue;
                Node nextPoint = path.m_77375_(i + 1);
                if ((pos.m_123341_() != nextPoint.f_77271_ || pos.m_123342_() <= nextPoint.f_77272_ || pos.m_123343_() != nextPoint.f_77273_) && !(this.entity.m_20186_() - (double)pos.m_123342_() > 1.0)) continue;
                this.toggleAblePositions.put(pos, (Boolean)this.entity.f_19853_.m_8055_(pos).m_61143_((Property)BlockStateProperties.f_61446_));
            }
        }
        return !this.toggleAblePositions.isEmpty();
    }

    private int getHeightToCheck(Path path, int index) {
        if (path == null || index < 0 || index >= path.m_77398_()) {
            return 2;
        }
        Node current = path.m_77375_(index);
        int prevDist = 0;
        if (index > 0) {
            Node prev = path.m_77375_(index - 1);
            prevDist = prev.f_77272_ - current.f_77272_;
        }
        int nextDist = 0;
        if (index + 1 < path.m_77398_()) {
            Node next = path.m_77375_(index + 1);
            nextDist = next.f_77272_ - current.f_77272_;
        }
        return Math.max(2, 2 + Math.max(prevDist, nextDist));
    }

    public boolean m_8045_() {
        return !this.toggleAblePositions.isEmpty();
    }

    private void resetAll() {
        block0: for (BlockPos pos : this.toggleAblePositions.keySet()) {
            for (ToggleAble toggleAble : this.toggleAbles) {
                BlockState state;
                if (!toggleAble.isBlockToggleAble(state = this.entity.f_19853_.m_8055_(pos)) || toggleAble.onlyCloseYourOpens() && !this.myToggled.contains(toggleAble)) continue;
                toggleAble.toggleBlockClosed((Entity)this.entity, state, this.entity.f_19853_, pos);
                this.myToggled.remove(toggleAble);
                continue block0;
            }
        }
        this.toggleAblePositions.clear();
        this.myToggled.clear();
        this.updateTimer = 0;
    }

    private boolean isValidBlockState(BlockState state) {
        if (state.m_60734_() == Blocks.f_50016_) {
            return false;
        }
        for (ToggleAble toggleAble : this.toggleAbles) {
            if (!toggleAble.isBlockToggleAble(state) || !state.m_61138_((Property)BlockStateProperties.f_61446_)) continue;
            return true;
        }
        return false;
    }

    public void m_8037_() {
        BlockState state;
        if (--this.updateTimer >= 0) {
            return;
        }
        this.updateTimer = ColonyConstants.rand.nextInt(40 + this.offSet);
        if (!this.checkPath()) {
            return;
        }
        Iterator<BlockPos> it = this.toggleAblePositions.keySet().iterator();
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        block0: while (it.hasNext()) {
            BlockPos pos = it.next();
            state = this.entity.f_19853_.m_8055_(pos);
            if (!this.isValidBlockState(state)) {
                it.remove();
                continue;
            }
            if (this.entity.m_20275_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) > 5.0) {
                it.remove();
                BlockState blockState = this.entity.f_19853_.m_8055_(pos);
                for (ToggleAble toggleAble : this.toggleAbles) {
                    if (!toggleAble.isBlockToggleAble(blockState) || toggleAble.onlyCloseYourOpens() && !this.myToggled.contains(toggleAble)) continue;
                    toggleAble.toggleBlockClosed((Entity)this.entity, blockState, this.entity.f_19853_, pos);
                    this.myToggled.remove(toggleAble);
                    continue block0;
                }
                continue;
            }
            posList.add(pos);
        }
        if (!posList.isEmpty()) {
            BlockPos chosen = (BlockPos)posList.get(this.entity.f_19853_.f_46441_.m_188503_(posList.size()));
            state = this.entity.f_19853_.m_8055_(chosen);
            for (ToggleAble toggleAble : this.toggleAbles) {
                if (!toggleAble.isBlockToggleAble(state) || !toggleAble.canOpen(state)) continue;
                toggleAble.toggleBlock((Entity)this.entity, state, this.entity.f_19853_, chosen);
                this.myToggled.add(toggleAble);
                break;
            }
        }
    }

    public static abstract class ToggleAble {
        public abstract boolean isBlockToggleAble(BlockState var1);

        public boolean canOpen(BlockState state) {
            return this.isBlockToggleAble(state);
        }

        public boolean onlyCloseYourOpens() {
            return false;
        }

        public abstract void toggleBlock(Entity var1, BlockState var2, Level var3, BlockPos var4);

        public abstract void toggleBlockClosed(Entity var1, BlockState var2, Level var3, BlockPos var4);
    }

    private static class FenceToggle
    extends ToggleAble {
        private FenceToggle() {
        }

        @Override
        public boolean isBlockToggleAble(BlockState state) {
            return state.m_60734_() instanceof FenceGateBlock;
        }

        @Override
        public void toggleBlock(Entity entity, BlockState state, Level world, BlockPos pos) {
            WorldUtil.setBlockState((LevelAccessor)world, pos, (BlockState)state.m_61122_((Property)BlockStateProperties.f_61446_));
        }

        @Override
        public void toggleBlockClosed(Entity entity, BlockState state, Level world, BlockPos pos) {
            WorldUtil.setBlockState((LevelAccessor)world, pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(false)));
        }
    }

    private static class TrapToggle
    extends ToggleAble {
        private TrapToggle() {
        }

        @Override
        public boolean isBlockToggleAble(BlockState state) {
            return state.m_60734_() instanceof TrapDoorBlock;
        }

        @Override
        public boolean canOpen(BlockState state) {
            return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_) == false;
        }

        @Override
        public boolean onlyCloseYourOpens() {
            return true;
        }

        @Override
        public void toggleBlock(Entity entity, BlockState state, Level world, BlockPos pos) {
            WorldUtil.setBlockState((LevelAccessor)world, pos, (BlockState)state.m_61122_((Property)BlockStateProperties.f_61446_));
        }

        @Override
        public void toggleBlockClosed(Entity entity, BlockState state, Level world, BlockPos pos) {
            WorldUtil.setBlockState((LevelAccessor)world, pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(false)));
        }
    }

    private static class DoorToggle
    extends ToggleAble {
        private DoorToggle() {
        }

        @Override
        public boolean isBlockToggleAble(BlockState state) {
            return state.m_60734_() instanceof DoorBlock;
        }

        @Override
        public void toggleBlock(Entity entity, BlockState state, Level world, BlockPos pos) {
            if (state.m_60734_().getClass() == DoorBlock.class) {
                boolean isOpening = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_) == false;
                WorldUtil.setBlockState((LevelAccessor)world, pos, (BlockState)state.m_61124_((Property)FenceGateBlock.f_53341_, (Comparable)Boolean.valueOf(isOpening)), 10);
                BlockPos otherPos = state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_();
                BlockState otherState = world.m_8055_(otherPos);
                if (otherState.m_60734_().getClass() == DoorBlock.class) {
                    WorldUtil.setBlockState((LevelAccessor)world, otherPos, (BlockState)otherState.m_61124_((Property)FenceGateBlock.f_53341_, (Comparable)Boolean.valueOf(isOpening)), 10);
                }
                ((DoorBlock)state.m_60734_()).m_245755_(entity, world, pos, isOpening);
            } else {
                ((DoorBlock)state.m_60734_()).m_153165_(entity, world, state, pos, (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_) == false);
            }
        }

        @Override
        public void toggleBlockClosed(Entity entity, BlockState state, Level world, BlockPos pos) {
            ((DoorBlock)state.m_60734_()).m_153165_(entity, world, state, pos, false);
        }
    }
}

