/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.commands.commandTypes.IMCOPCommand;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;

public class CommandShowClaim
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        BlockPos pos = BlockPos.m_274446_((Position)((CommandSourceStack)context.getSource()).m_81371_());
        try {
            pos = BlockPosArgument.m_264582_(context, (String)"location");
        }
        catch (Exception exception) {
            // empty catch block
        }
        LevelChunk chunk = (LevelChunk)level.m_46865_(pos);
        BlockPos finalPos = pos;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> this.buildClaimCommandResult(chunk, finalPos, level), true);
        return 1;
    }

    private MutableComponent buildClaimCommandResult(LevelChunk chunk, BlockPos pos, ServerLevel level) {
        Map<Integer, Set<BlockPos>> buildingClaims;
        MutableComponent text = Component.m_237110_((String)"Claim data of chunk at: %sX %sZ\n", (Object[])new Object[]{pos.m_123341_(), pos.m_123343_()}).m_130940_(ChatFormatting.DARK_AQUA);
        List<Integer> staticColonyClaims = ColonyUtils.getStaticClaims(chunk);
        int owningColony = ColonyUtils.getOwningColony(chunk);
        if (!staticColonyClaims.isEmpty()) {
            text.m_7220_((Component)Component.m_237110_((String)"OwnerID:%s Direct colony claims:\n", (Object[])new Object[]{owningColony}).m_130940_(ChatFormatting.GOLD));
            for (int colonyID : staticColonyClaims) {
                IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)level.m_46472_());
                if (colony == null) {
                    text.m_7220_((Component)Component.m_237110_((String)"ID: %s Name: Unkown Colony\n", (Object[])new Object[]{colonyID}));
                    continue;
                }
                text.m_7220_((Component)Component.m_237110_((String)"ID: %s Name: %s\n", (Object[])new Object[]{colonyID, colony.getName()}));
            }
        }
        if (!(buildingClaims = ColonyUtils.getAllClaimingBuildings(chunk)).isEmpty()) {
            text.m_7220_((Component)Component.m_237115_((String)"Building claims:\n").m_130940_(ChatFormatting.GOLD));
            for (Map.Entry<Integer, Set<BlockPos>> entry : buildingClaims.entrySet()) {
                IColony colony = IColonyManager.getInstance().getColonyByDimension(entry.getKey(), (ResourceKey<Level>)level.m_46472_());
                for (BlockPos buildingPos : entry.getValue()) {
                    if (colony != null) {
                        IBuilding building = colony.getBuildingManager().getBuilding(buildingPos);
                        if (building != null) {
                            text.m_7220_((Component)Component.m_237110_((String)"ID: %s Building: %s Pos: %s\n", (Object[])new Object[]{entry.getKey(), Component.m_237115_((String)building.getBuildingDisplayName()), buildingPos}));
                            continue;
                        }
                        text.m_7220_((Component)Component.m_237110_((String)"ID: %s Building: Unknown pos: %s\n", (Object[])new Object[]{entry.getKey(), buildingPos}));
                        continue;
                    }
                    text.m_7220_((Component)Component.m_237110_((String)"ID: %s Building: Unknown Pos: %s\n", (Object[])new Object[]{entry.getKey(), buildingPos}));
                }
            }
        }
        return text;
    }

    @Override
    public String getName() {
        return "claiminfo";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("location", BlockPosArgument.m_118239_()).executes(this::checkPreConditionAndExecute))).executes(this::checkPreConditionAndExecute);
    }
}

