/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class BuildingArchery
extends AbstractBuilding {
    private static final String SCHEMATIC_NAME = "archery";
    private final List<BlockPos> shootingStands = new ArrayList<BlockPos>();
    private final List<BlockPos> shootingTargets = new ArrayList<BlockPos>();

    public BuildingArchery(@NotNull IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull Level world) {
        if (block == Blocks.f_50716_) {
            this.shootingTargets.add(pos);
        } else if (block == Blocks.f_50141_) {
            this.shootingStands.add(pos);
        }
        super.registerBlockPosition(block, pos, world);
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.shootingTargets.clear();
        this.shootingStands.clear();
        ListTag targetList = compound.m_128437_("archeryTargets", 10);
        this.shootingTargets.addAll(NBTUtils.streamCompound(targetList).map(targetCompound -> BlockPosUtil.read(targetCompound, "target")).collect(Collectors.toList()));
        ListTag standTagList = compound.m_128437_("archeryStands", 10);
        this.shootingStands.addAll(NBTUtils.streamCompound(standTagList).map(targetCompound -> BlockPosUtil.read(targetCompound, "stand")).collect(Collectors.toList()));
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        ListTag targetList = this.shootingTargets.stream().map(target -> BlockPosUtil.write(new CompoundTag(), "target", target)).collect(NBTUtils.toListNBT());
        compound.m_128365_("archeryTargets", (Tag)targetList);
        ListTag standTagList = this.shootingStands.stream().map(target -> BlockPosUtil.write(new CompoundTag(), "stand", target)).collect(NBTUtils.toListNBT());
        compound.m_128365_("archeryStands", (Tag)standTagList);
        return compound;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SCHEMATIC_NAME;
    }

    public BlockPos getRandomShootingStandPosition(RandomSource random) {
        List<BlockPos> tagged = this.getLocationsFromTag("work");
        if (!tagged.isEmpty()) {
            return tagged.get(random.m_188503_(tagged.size()));
        }
        if (!this.shootingStands.isEmpty()) {
            return this.shootingStands.get(random.m_188503_(this.shootingStands.size()));
        }
        return null;
    }

    public BlockPos getRandomShootingTarget(RandomSource random) {
        if (!this.shootingTargets.isEmpty()) {
            return this.shootingTargets.get(random.m_188503_(this.shootingTargets.size()));
        }
        return null;
    }
}

