/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.moduleviews;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.api.colony.buildings.modules.IAssignmentModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.modules.building.SpecialAssignmentModuleWindow;
import com.minecolonies.core.network.messages.server.colony.building.HireFireMessage;
import com.minecolonies.core.network.messages.server.colony.building.QuarryHiringModeMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class MinerAssignmentModuleView
extends AbstractBuildingModuleView
implements IAssignmentModuleView {
    private final Set<Integer> workerIDs = new HashSet<Integer>();
    private HiringMode hiringMode;

    @Override
    public List<Integer> getAssignedCitizens() {
        return new ArrayList<Integer>(this.workerIDs);
    }

    @Override
    public void addCitizen(@NotNull ICitizenDataView citizen) {
        this.workerIDs.add(citizen.getId());
        Network.getNetwork().sendToServer(new HireFireMessage(this.buildingView, true, citizen.getId(), this.getProducer().getRuntimeID()));
    }

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.workerIDs.clear();
        for (int i = 0; i < size; ++i) {
            this.workerIDs.add(buf.readInt());
        }
        this.hiringMode = HiringMode.values()[buf.readInt()];
        buf.readInt();
    }

    @Override
    public ResourceLocation getIconResourceLocation() {
        return new ResourceLocation("minecolonies", "textures/gui/modules/entity.png");
    }

    @Override
    public Component getDesc() {
        return Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.quarry.miners");
    }

    @Override
    public void removeCitizen(@NotNull ICitizenDataView citizen) {
        this.workerIDs.remove(citizen.getId());
        Network.getNetwork().sendToServer(new HireFireMessage(this.buildingView, false, citizen.getId(), this.getProducer().getRuntimeID()));
    }

    @Override
    public HiringMode getHiringMode() {
        return this.hiringMode;
    }

    @Override
    public void setHiringMode(HiringMode hiringMode) {
        this.hiringMode = hiringMode;
        Network.getNetwork().sendToServer(new QuarryHiringModeMessage(this.buildingView, hiringMode, this.getProducer().getRuntimeID()));
    }

    @Override
    public boolean canAssign(ICitizenDataView data) {
        for (IBuildingView bView : this.buildingView.getColony().getBuildings()) {
            MinerAssignmentModuleView view = bView.getModuleViewMatching(MinerAssignmentModuleView.class, m -> !m.buildingView.getId().equals(this.buildingView.getId()));
            if (view == null || !view.getAssignedCitizens().contains(data.getId())) continue;
            return false;
        }
        return !data.isChild() && data.getJobView() != null && data.getJobView().getEntry() == ModJobs.quarrier.get();
    }

    @Override
    public int getMaxInhabitants() {
        return 1;
    }

    @Override
    public BOWindow getWindow() {
        return new SpecialAssignmentModuleWindow(this, new ResourceLocation("minecolonies", "gui/layouthuts/layoutminerassignment.xml"));
    }

    @Override
    public boolean isFull() {
        return this.getAssignedCitizens().size() >= this.getMaxInhabitants();
    }

    @Override
    public JobEntry getJobEntry() {
        return (JobEntry)ModJobs.quarrier.get();
    }
}

