/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.jobs.IJobView;
import com.minecolonies.api.colony.jobs.registry.IJobDataManager;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenHappinessHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSkillHandler;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.interactionhandling.ServerCitizenInteraction;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenHappinessHandler;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenSkillHandler;
import java.time.Clock;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenDataView
implements ICitizenDataView {
    private static ItemStack cachedDisplaySantaHat = null;
    private static final String TAG_HELD_ITEM_SLOT = "HeldItemSlot";
    private static final ResourceLocation BLOCKING_RESOURCE = new ResourceLocation("minecolonies", "textures/icons/blocking.png");
    private static final ResourceLocation PENDING_RESOURCE = new ResourceLocation("minecolonies", "textures/icons/warning.png");
    private final int id;
    private final IColonyView colonyView;
    protected int entityId;
    protected String name;
    protected boolean female;
    protected boolean paused;
    protected boolean isChild;
    private IJobView jobView;
    protected int colonyId;
    private double saturation;
    private double happiness;
    private BlockPos position;
    private String job;
    @Nullable
    private BlockPos homeBuilding;
    @Nullable
    private BlockPos workBuilding;
    private InventoryCitizen inventory;
    private final Map<Component, IInteractionResponseHandler> citizenChatOptions = new LinkedHashMap<Component, IInteractionResponseHandler>();
    private List<IInteractionResponseHandler> sortedInteractions;
    private final CitizenSkillHandler citizenSkillHandler;
    private final CitizenHappinessHandler citizenHappinessHandler;
    private VisibleCitizenStatus statusIcon;
    @Nullable
    private BlockPos statusPosition;
    private Tuple<String, String> parents = new Tuple<String, String>("", "");
    private List<Integer> children = new ArrayList<Integer>();
    private List<Integer> siblings = new ArrayList<Integer>();
    private Integer partner;
    private final List<ResourceLocation> availableQuests = new ArrayList<ResourceLocation>();
    private final List<ResourceLocation> participatingQuests = new ArrayList<ResourceLocation>();
    protected UUID textureUUID;
    private boolean isSick;

    protected CitizenDataView(int id, IColonyView colonyView) {
        this.id = id;
        this.citizenSkillHandler = new CitizenSkillHandler();
        this.citizenHappinessHandler = new CitizenHappinessHandler();
        this.colonyView = colonyView;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isFemale() {
        return this.female;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public IColonyView getColony() {
        return this.colonyView;
    }

    @Override
    public boolean isChild() {
        return this.isChild;
    }

    @Override
    public void setPaused(boolean p) {
        this.paused = p;
    }

    @Override
    public String getJob() {
        return this.job;
    }

    @Override
    public MutableComponent getJobComponent() {
        return this.job.isEmpty() ? Component.m_237115_((String)"com.minecolonies.coremod.gui.townhall.citizens.unemployed") : Component.m_237115_((String)this.job);
    }

    @Override
    @Nullable
    public BlockPos getHomeBuilding() {
        return this.homeBuilding;
    }

    @Override
    @Nullable
    public BlockPos getWorkBuilding() {
        return this.workBuilding;
    }

    @Override
    public void setHomeBuilding(BlockPos homeBuilding) {
        this.homeBuilding = homeBuilding;
    }

    @Override
    public void setWorkBuilding(@Nullable BlockPos bp) {
        this.workBuilding = bp;
    }

    @Override
    public int getColonyId() {
        return this.colonyId;
    }

    @Override
    public double getHappiness() {
        return this.happiness;
    }

    @Override
    public double getSaturation() {
        return this.saturation;
    }

    @Override
    public double getHealth() {
        Entity entity = this.colonyView.getWorld().m_6815_(this.entityId);
        if (entity instanceof LivingEntity) {
            return ((LivingEntity)entity).m_21223_();
        }
        return 20.0;
    }

    @Override
    public double getMaxHealth() {
        Entity entity = this.colonyView.getWorld().m_6815_(this.entityId);
        if (entity instanceof LivingEntity) {
            return ((LivingEntity)entity).m_21233_();
        }
        return 20.0;
    }

    @Override
    public BlockPos getPosition() {
        return this.position;
    }

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        this.name = buf.m_130136_(Short.MAX_VALUE);
        this.female = buf.readBoolean();
        this.entityId = buf.readInt();
        this.paused = buf.readBoolean();
        this.isChild = buf.readBoolean();
        this.homeBuilding = buf.readBoolean() ? buf.m_130135_() : null;
        this.workBuilding = buf.readBoolean() ? buf.m_130135_() : null;
        this.saturation = buf.readDouble();
        this.happiness = buf.readDouble();
        this.citizenSkillHandler.read(buf.m_130260_());
        this.job = buf.m_130136_(Short.MAX_VALUE);
        this.colonyId = buf.readInt();
        CompoundTag compound = buf.m_130260_();
        this.inventory = new InventoryCitizen(this.name, true);
        this.inventory.read(compound);
        this.inventory.setHeldItem(InteractionHand.MAIN_HAND, compound.m_128451_(TAG_HELD_ITEM_SLOT));
        this.inventory.setHeldItem(InteractionHand.OFF_HAND, compound.m_128451_("OffhandHeldItemSlot"));
        this.position = buf.m_130135_();
        this.citizenChatOptions.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            CompoundTag compoundNBT = buf.m_130260_();
            ServerCitizenInteraction handler = (ServerCitizenInteraction)MinecoloniesAPIProxy.getInstance().getInteractionResponseHandlerDataManager().createFrom(this, compoundNBT);
            this.citizenChatOptions.put(handler.getInquiry(), handler);
        }
        this.sortedInteractions = new ArrayList<IInteractionResponseHandler>(this.citizenChatOptions.values());
        this.sortedInteractions.sort(Comparator.comparingInt(e -> -e.getPriority().getPriority()));
        this.citizenHappinessHandler.read(buf.m_130260_(), false);
        int statusindex = buf.readInt();
        this.statusIcon = statusindex >= 0 ? VisibleCitizenStatus.getForId(statusindex) : null;
        BlockPos blockPos = this.statusPosition = buf.readBoolean() ? buf.m_130135_() : null;
        if (buf.readBoolean()) {
            IColonyView colonyView = IColonyManager.getInstance().getColonyView(this.colonyId, (ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_());
            this.jobView = IJobDataManager.getInstance().createViewFrom(colonyView, this, buf);
        } else {
            this.jobView = null;
        }
        this.children.clear();
        this.siblings.clear();
        this.partner = buf.readInt();
        int siblingsSize = buf.readInt();
        for (int i = 0; i < siblingsSize; ++i) {
            this.siblings.add(buf.readInt());
        }
        int childrenSize = buf.readInt();
        for (int i = 0; i < childrenSize; ++i) {
            this.children.add(buf.readInt());
        }
        String parentA = buf.m_130277_();
        String parentB = buf.m_130277_();
        this.parents = new Tuple<String, String>(parentA, parentB);
        this.availableQuests.clear();
        this.participatingQuests.clear();
        int avSize = buf.readInt();
        for (int i = 0; i < avSize; ++i) {
            this.availableQuests.add(buf.m_130281_());
        }
        int partSize = buf.readInt();
        for (int i = 0; i < partSize; ++i) {
            this.participatingQuests.add(buf.m_130281_());
        }
        if (buf.readBoolean()) {
            this.textureUUID = buf.m_130259_();
        }
        this.isSick = buf.readBoolean();
    }

    @Override
    public IJobView getJobView() {
        return this.jobView;
    }

    @Override
    public InventoryCitizen getInventory() {
        return this.inventory;
    }

    @Override
    public List<IInteractionResponseHandler> getOrderedInteractions() {
        return this.sortedInteractions;
    }

    @Override
    @Nullable
    public IInteractionResponseHandler getSpecificInteraction(@NotNull Component component) {
        return this.citizenChatOptions.getOrDefault(component, null);
    }

    @Override
    public boolean hasBlockingInteractions() {
        if (this.sortedInteractions.isEmpty()) {
            return false;
        }
        for (IInteractionResponseHandler interaction : this.sortedInteractions) {
            if (interaction.getPriority().getPriority() < ChatPriority.IMPORTANT.getPriority()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasVisibleStatus() {
        if (this.statusIcon != null && this.statusIcon.shouldRender()) {
            return true;
        }
        if (this.sortedInteractions.isEmpty()) {
            return false;
        }
        for (IInteractionResponseHandler interaction : this.sortedInteractions) {
            if (interaction.getPriority().getPriority() < ChatPriority.CHITCHAT.getPriority()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPendingInteractions() {
        if (this.sortedInteractions.isEmpty()) {
            return false;
        }
        for (IInteractionResponseHandler interaction : this.sortedInteractions) {
            if (!interaction.isPrimary()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ICitizenSkillHandler getCitizenSkillHandler() {
        return this.citizenSkillHandler;
    }

    @Override
    public ICitizenHappinessHandler getHappinessHandler() {
        return this.citizenHappinessHandler;
    }

    @Override
    public ResourceLocation getStatusIcon() {
        if (this.statusIcon != null && this.statusIcon.shouldRender()) {
            return this.statusIcon.getIcon();
        }
        if (this.sortedInteractions == null || this.sortedInteractions.isEmpty()) {
            return null;
        }
        ResourceLocation icon = this.sortedInteractions.get(0).getInteractionIcon();
        if (icon == null) {
            if (this.hasBlockingInteractions()) {
                icon = BLOCKING_RESOURCE;
            } else if (this.hasVisibleStatus()) {
                icon = PENDING_RESOURCE;
            }
        }
        return icon;
    }

    @Override
    public VisibleCitizenStatus getVisibleStatus() {
        return this.statusIcon;
    }

    @Override
    @Nullable
    public BlockPos getStatusPosition() {
        return this.statusPosition;
    }

    @Override
    @Nullable
    public Integer getPartner() {
        return this.partner;
    }

    @Override
    public List<Integer> getChildren() {
        return new ArrayList<Integer>(this.children);
    }

    @Override
    public List<Integer> getSiblings() {
        return new ArrayList<Integer>(this.siblings);
    }

    @Override
    public Tuple<String, String> getParents() {
        return this.parents;
    }

    @Override
    public ResourceLocation getCustomTexture() {
        return null;
    }

    @Override
    public UUID getCustomTextureUUID() {
        return this.textureUUID;
    }

    @Override
    public void setJobView(IJobView jobView) {
        this.jobView = jobView;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ICitizenDataView data = (ICitizenDataView)o;
        return this.id == data.getId();
    }

    @Override
    public ItemStack getDisplayArmor(EquipmentSlot equipmentSlot) {
        ItemStack currentHat;
        if (cachedDisplaySantaHat == null) {
            cachedDisplaySantaHat = (Boolean)MineColonies.getConfig().getClient().holidayFeatures.get() != false && LocalDate.now(Clock.systemDefaultZone()).getMonth() == Month.DECEMBER ? new ItemStack((ItemLike)ModItems.santaHat) : ItemStack.f_41583_;
        }
        if ((currentHat = this.getInventory().getArmorInSlot(equipmentSlot)).m_41619_() && cachedDisplaySantaHat != null && cachedDisplaySantaHat != ItemStack.f_41583_ && equipmentSlot == EquipmentSlot.HEAD) {
            return cachedDisplaySantaHat;
        }
        return currentHat;
    }

    @Override
    public boolean isSick() {
        return this.isSick;
    }
}

