/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.townhall;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.colony.colonyEvents.descriptions.IBuildingEventDescription;
import com.minecolonies.api.colony.colonyEvents.descriptions.ICitizenEventDescription;
import com.minecolonies.api.colony.colonyEvents.descriptions.IColonyEventDescription;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.core.client.gui.townhall.WindowStatsPage;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingBuilderView;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.core.colony.eventhooks.citizenEvents.CitizenDiedEvent;
import com.minecolonies.core.network.messages.server.colony.WorkOrderChangeMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class WindowInfoPage
extends AbstractWindowTownHall {
    private final List<IWorkOrderView> workOrders = new ArrayList<IWorkOrderView>();
    private DropDownList intervalDropdown;
    public String selectedInterval = "com.minecolonies.coremod.gui.interval.alltime";

    public WindowInfoPage(BuildingTownHall.View building) {
        super(building, "layoutinfo.xml");
        this.updateWorkOrders();
        this.registerButton("plus", this::updatePriority);
        this.registerButton("minus", this::updatePriority);
        this.registerButton("delete", this::deleteWorkOrder);
        this.intervalDropdown = (DropDownList)this.findPaneOfTypeByID("intervals", DropDownList.class);
        this.intervalDropdown.setHandler(this::onDropDownListChanged);
        this.intervalDropdown.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return WindowStatsPage.INTERVAL.size();
            }

            public String getLabel(int index) {
                return Component.m_237115_((String)((String)WindowStatsPage.INTERVAL.keySet().toArray()[index])).getString();
            }
        });
        this.intervalDropdown.setSelectedIndex(new ArrayList<String>(WindowStatsPage.INTERVAL.keySet()).indexOf(this.selectedInterval));
    }

    private void onDropDownListChanged(DropDownList dropDownList) {
        String temp = (String)WindowStatsPage.INTERVAL.keySet().toArray()[dropDownList.getSelectedIndex()];
        if (!temp.equals(this.selectedInterval)) {
            this.selectedInterval = temp;
            this.fillEventsList();
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.fillWorkOrderList();
        this.fillEventsList();
    }

    private void fillEventsList() {
        ArrayList<Object> events;
        int interval = WindowStatsPage.INTERVAL.get(this.selectedInterval);
        if (interval < 0) {
            events = new ArrayList<IColonyEventDescription>(((ITownHallView)this.buildingView).getColonyEvents());
        } else {
            events = new ArrayList();
            for (IColonyEventDescription event : ((ITownHallView)this.buildingView).getColonyEvents()) {
                if (event.getDay() < ((ITownHallView)this.buildingView).getColony().getDay() - interval) continue;
                events.add(event);
            }
        }
        ((ScrollingList)this.findPaneOfTypeByID("eventsList", ScrollingList.class)).setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return events.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                Text nameLabel = (Text)rowPane.findPaneOfTypeByID("name", Text.class);
                Text actionLabel = (Text)rowPane.findPaneOfTypeByID("action", Text.class);
                IColonyEventDescription event = (IColonyEventDescription)events.get(index);
                if (event instanceof CitizenDiedEvent) {
                    actionLabel.setText(Component.m_237113_((String)((CitizenDiedEvent)event).getDeathCause()));
                } else {
                    actionLabel.setText(Component.m_237113_((String)event.getName()));
                }
                if (event instanceof ICitizenEventDescription) {
                    nameLabel.setText(Component.m_237113_((String)((ICitizenEventDescription)event).getCitizenName()));
                } else if (event instanceof IBuildingEventDescription) {
                    IBuildingEventDescription buildEvent = (IBuildingEventDescription)event;
                    nameLabel.setText(MessageUtils.format(buildEvent.getBuildingName(), new Object[0]).append((Component)Component.m_237113_((String)(" " + buildEvent.getLevel()))).create());
                    ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(nameLabel.getText())).hoverPane((Pane)nameLabel).build();
                }
                ((Text)rowPane.findPaneOfTypeByID("pos", Text.class)).setText(Component.m_237113_((String)(event.getEventPos().m_123341_() + " " + event.getEventPos().m_123342_() + " " + event.getEventPos().m_123343_())));
                ((Button)rowPane.findPaneOfTypeByID("addfakeplayer", Button.class)).hide();
            }
        });
    }

    private void updateWorkOrders() {
        this.workOrders.clear();
        this.workOrders.addAll(((ITownHallView)this.buildingView).getColony().getWorkOrders().stream().filter(wo -> wo.shouldShowIn(this.buildingView)).collect(Collectors.toList()));
        this.sortWorkOrders();
    }

    private void sortWorkOrders() {
        this.workOrders.sort(Comparator.comparing(IWorkOrder::getPriority, Comparator.reverseOrder()));
    }

    private void updatePriority(@NotNull Button button) {
        int id = Integer.parseInt(((Text)button.getParent().findPaneOfTypeByID("hiddenId", Text.class)).getTextAsString());
        String buttonLabel = button.getID();
        for (int i = 0; i < this.workOrders.size(); ++i) {
            IWorkOrderView workOrder = this.workOrders.get(i);
            if (workOrder.getID() != id) continue;
            if (buttonLabel.equals("plus") && i > 0) {
                workOrder.setPriority(this.workOrders.get(i - 1).getPriority() + 1);
                Network.getNetwork().sendToServer(new WorkOrderChangeMessage(this.buildingView, id, false, workOrder.getPriority()));
            } else if (buttonLabel.equals("minus") && i <= this.workOrders.size()) {
                workOrder.setPriority(this.workOrders.get(i + 1).getPriority() - 1);
                Network.getNetwork().sendToServer(new WorkOrderChangeMessage(this.buildingView, id, false, workOrder.getPriority()));
            }
            this.sortWorkOrders();
            ((ScrollingList)this.window.findPaneOfTypeByID("workOrderList", ScrollingList.class)).refreshElementPanes();
            return;
        }
    }

    private void deleteWorkOrder(@NotNull Button button) {
        int id = Integer.parseInt(((Text)button.getParent().findPaneOfTypeByID("hiddenId", Text.class)).getTextAsString());
        for (int i = 0; i < this.workOrders.size(); ++i) {
            if (this.workOrders.get(i).getID() != id) continue;
            this.workOrders.remove(i);
            break;
        }
        Network.getNetwork().sendToServer(new WorkOrderChangeMessage(this.buildingView, id, true, 0));
        ((ScrollingList)this.window.findPaneOfTypeByID("workOrderList", ScrollingList.class)).refreshElementPanes();
    }

    private void fillWorkOrderList() {
        ScrollingList workOrderList = (ScrollingList)this.findPaneOfTypeByID("workOrderList", ScrollingList.class);
        workOrderList.enable();
        workOrderList.show();
        workOrderList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowInfoPage.this.workOrders.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                IWorkOrderView workOrder = WindowInfoPage.this.workOrders.get(index);
                String claimingCitizen = "";
                int numElements = this.getElementCount();
                if (index == 0) {
                    ((Button)rowPane.findPaneOfTypeByID("minus", Button.class)).setVisible(numElements != 1);
                    ((Button)rowPane.findPaneOfTypeByID("plus", Button.class)).hide();
                } else if (index == numElements - 1) {
                    ((Button)rowPane.findPaneOfTypeByID("minus", Button.class)).hide();
                } else {
                    ((Button)rowPane.findPaneOfTypeByID("minus", Button.class)).show();
                    ((Button)rowPane.findPaneOfTypeByID("plus", Button.class)).show();
                }
                for (IBuildingView buildingView : ((ITownHallView)WindowInfoPage.this.buildingView).getColony().getBuildings()) {
                    if (!buildingView.getPosition().equals((Object)workOrder.getClaimedBy()) || !(buildingView instanceof AbstractBuildingBuilderView)) continue;
                    claimingCitizen = ((AbstractBuildingBuilderView)buildingView).getWorkerName();
                    break;
                }
                Text workOrderTextPanel = (Text)rowPane.findPaneOfTypeByID("work", Text.class);
                ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(workOrder.getDisplayName())).hoverPane((Pane)workOrderTextPanel).build();
                workOrderTextPanel.setText(Component.m_237113_((String)workOrder.getDisplayName().getString().replace("\n", ": ")));
                ((Text)rowPane.findPaneOfTypeByID("assignee", Text.class)).setText(Component.m_237113_((String)claimingCitizen));
                ((Text)rowPane.findPaneOfTypeByID("hiddenId", Text.class)).setText(Component.m_237113_((String)Integer.toString(workOrder.getID())));
            }
        });
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.updateWorkOrders();
    }

    @Override
    protected String getWindowId() {
        return "infopage";
    }
}

