/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.ButtonHandler;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.View;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.modules.IWindowModule;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class TabsWindowModule
implements IWindowModule {
    private static final int TAB_X_OFFSET = 12;
    private static final int TAB_Y_OFFSET = 10;
    private static final int TAB_WIDTH = 32;
    private static final int TAB_HEIGHT = 26;
    private static final int TAB_Y_SPACING = 2;
    private static final int TAB_ICON_WIDTH = 20;
    private static final int TAB_ICON_HEIGHT = 20;
    private static final int TAB_ICON_OFFSET_X = 5;
    private static final int TAB_ICON_OFFSET_Y = 3;
    private final AbstractWindowSkeleton parent;
    private final Random iconRandom;
    private int tabXOffset = 12;
    private int tabYOffset = 10;
    private int tabYSpacing = 2;

    public TabsWindowModule(AbstractWindowSkeleton parent, Random iconRandom) {
        this.parent = parent;
        this.iconRandom = iconRandom;
    }

    public void setTabXOffset(int tabXOffset) {
        this.tabXOffset = tabXOffset;
    }

    public void setTabYOffset(int tabYOffset) {
        this.tabYOffset = tabYOffset;
    }

    public void setTabYSpacing(int tabYSpacing) {
        this.tabYSpacing = tabYSpacing;
    }

    public void renderTabButton(int index, TabImageSide side, ResourceLocation icon, @Nullable MutableComponent hoverText, ButtonHandler handler) {
        View view = new View();
        view.setID(icon.m_135815_() + "_view");
        view.setPosition(side.getXPosition.apply(this.parent, this.tabXOffset).intValue(), this.tabYOffset + (26 + this.tabYSpacing) * index);
        view.setSize(32, 26);
        ButtonImage image = new ButtonImage();
        image.setImage(side.getImage(this.iconRandom), false);
        image.setSize(32, 26);
        image.setHandler(handler);
        ButtonImage iconImage = new ButtonImage();
        iconImage.setID(icon.m_135815_());
        iconImage.setImage(icon, false);
        iconImage.setSize(20, 20);
        iconImage.setPosition(5, 3);
        iconImage.setHandler(handler);
        this.parent.addChild((Pane)view);
        view.addChild((Pane)image);
        view.addChild((Pane)iconImage);
        if (hoverText != null) {
            ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(hoverText)).hoverPane((Pane)view).build();
        }
    }

    public static enum TabImageSide {
        LEFT("left", 4, (v, tabXOffset) -> -(32 - tabXOffset)),
        RIGHT("right", 4, (v, tabXOffset) -> v.getWidth() - tabXOffset);

        private final String side;
        private final int imageCount;
        private final BiFunction<BOWindow, Integer, Integer> getXPosition;

        private TabImageSide(String side, int imageCount, BiFunction<BOWindow, Integer, Integer> getXPosition) {
            this.side = side;
            this.imageCount = imageCount;
            this.getXPosition = getXPosition;
        }

        public ResourceLocation getImage(Random random) {
            return new ResourceLocation("minecolonies", String.format("textures/gui/modules/tab_%s_side%d.png", this.side, random.nextInt(this.imageCount) + 1));
        }
    }
}

