/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.citizen;

import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.citizen.AbstractWindowCitizen;
import com.minecolonies.core.client.gui.modules.RequestTreeWindowModule;
import com.minecolonies.core.network.messages.server.colony.UpdateRequestStateMessage;
import com.minecolonies.core.network.messages.server.colony.citizen.TransferItemsToCitizenRequestMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequestWindowCitizen
extends AbstractWindowCitizen {
    public static final ResourceLocation WINDOW_ID = new ResourceLocation("minecolonies", "gui/citizen/requests.xml");
    @Nullable
    private final IRequest<?> autoOpenRequest;
    private final RequestTreeWindowModule requestTreeModule;

    public RequestWindowCitizen(ICitizenDataView citizen) {
        this(citizen, (IRequest<?>)null);
    }

    public RequestWindowCitizen(ICitizenDataView citizen, @Nullable IRequest<?> autoOpenRequest) {
        super(citizen, WINDOW_ID);
        this.autoOpenRequest = autoOpenRequest;
        this.requestTreeModule = this.registerLayoutModule(CitizenRequestTreeWindowModule::new, citizen, 33, 29);
    }

    @Override
    public void onOpened() {
        super.onOpened();
        if (this.autoOpenRequest != null) {
            this.requestTreeModule.openDetails(this.autoOpenRequest);
        }
    }

    private static class CitizenRequestTreeWindowModule
    extends RequestTreeWindowModule
    implements RequestTreeWindowModule.IRequestTreeSupportsFulfill {
        private final ICitizenDataView citizenDataView;
        private final IBuildingView buildingView;
        private final boolean isCreative;
        private final Inventory inventory;

        private CitizenRequestTreeWindowModule(AbstractWindowSkeleton parent, ICitizenDataView citizenDataView) {
            super(parent, citizenDataView.getColony());
            this.citizenDataView = citizenDataView;
            this.buildingView = citizenDataView.getColony().getBuilding(citizenDataView.getWorkBuilding());
            this.isCreative = Minecraft.m_91087_().f_91074_.m_7500_();
            this.inventory = Minecraft.m_91087_().f_91074_.m_150109_();
        }

        @Override
        protected Collection<IRequest<?>> getOpenRequests() {
            IRequest<?> request;
            if (this.buildingView == null) {
                return List.of();
            }
            ArrayList requests = new ArrayList();
            for (IToken token : (Collection)this.buildingView.getOpenRequestsByCitizen().getOrDefault(this.citizenDataView.getId(), Collections.emptyList())) {
                if (token == null || (request = this.colony.getRequestManager().getRequestForToken(token)) == null) continue;
                requests.add(request);
            }
            for (IToken token : (Collection)this.buildingView.getOpenRequestsByCitizen().getOrDefault(-1, Collections.emptyList())) {
                if (token == null || (request = this.colony.getRequestManager().getRequestForToken(token)) == null) continue;
                requests.add(request);
            }
            return requests;
        }

        @Override
        public void onFulfill(@NotNull IRequest<?> request) {
            ItemStack itemStack;
            Object obj = request.getRequest();
            if (!(obj instanceof IDeliverable)) {
                return;
            }
            IDeliverable deliverable = (IDeliverable)obj;
            Predicate<ItemStack> requestPredicate = deliverable::matches;
            int amount = deliverable.getCount();
            int count = InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((Container)this.inventory), deliverable::matches);
            if (!this.isCreative && count <= 0) {
                return;
            }
            if (this.isCreative) {
                itemStack = request.getDisplayStacks().stream().findFirst().orElse(ItemStack.f_41583_);
            } else {
                List<Integer> slots = InventoryUtils.findAllSlotsInItemHandlerWith((IItemHandler)new InvWrapper((Container)this.inventory), requestPredicate);
                int invSize = this.inventory.m_6643_() - 5;
                int slot = -1;
                for (Integer possibleSlot : slots) {
                    if (possibleSlot >= invSize) continue;
                    slot = possibleSlot;
                    break;
                }
                if (slot == -1) {
                    MessageUtils.format("<%s> ", new Object[0]).append("com.minecolonies.coremod.general.canttakeequipped", this.citizenDataView.getName()).withPriority(MessageUtils.MessagePriority.IMPORTANT).sendTo(new Player[]{Minecraft.m_91087_().f_91074_});
                    return;
                }
                itemStack = this.inventory.m_8020_(slot);
            }
            if (this.citizenDataView.getWorkBuilding() != null) {
                this.colony.getBuilding(this.citizenDataView.getWorkBuilding()).onRequestedRequestComplete(this.colony.getRequestManager(), request);
            }
            int quantity = this.isCreative ? amount : Math.min(amount, count);
            Network.getNetwork().sendToServer(new TransferItemsToCitizenRequestMessage(this.colony, this.citizenDataView, itemStack, quantity));
            ItemStack copy = itemStack.m_41777_();
            copy.m_41764_(quantity);
            Network.getNetwork().sendToServer(new UpdateRequestStateMessage(this.colony, (IToken<?>)request.getId(), RequestState.OVERRULED, copy));
        }
    }
}

