/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.research.costs;

import com.google.gson.JsonObject;
import com.minecolonies.api.research.IResearchCost;
import com.minecolonies.api.research.ModResearchCosts;
import com.minecolonies.core.util.GsonHelper;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class TagItemCost
implements IResearchCost {
    private static final String JSON_PROP_TAG = "tag";
    private static final String JSON_PROP_QUANTITY = "quantity";
    private final TagKey<Item> tag;
    private final int count;

    public TagItemCost(CompoundTag compound) {
        this.tag = ForgeRegistries.ITEMS.tags().createTagKey(new ResourceLocation(compound.m_128461_("cost-tag")));
        this.count = compound.m_128451_("cost-count");
    }

    public TagItemCost(JsonObject json) {
        this.tag = ForgeRegistries.ITEMS.tags().createTagKey(GsonHelper.getAsResourceLocation(json, JSON_PROP_TAG));
        this.count = Math.max(GsonHelper.m_13824_((JsonObject)json, (String)JSON_PROP_QUANTITY, (int)1), 1);
    }

    @Override
    public ModResearchCosts.ResearchCostEntry getType() {
        return (ModResearchCosts.ResearchCostEntry)ModResearchCosts.tagItemCost.get();
    }

    @Override
    public List<Item> getItems() {
        return ForgeRegistries.ITEMS.tags().getTag(this.tag).stream().toList();
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public Component getTranslatedName() {
        return Component.m_237115_((String)String.format("com.minecolonies.coremod.research.tags.%s", this.tag.f_203868_()));
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("cost-count", this.count);
        compound.m_128359_("cost-tag", this.tag.f_203868_().toString());
        return compound;
    }
}

