/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.mobs;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.colonyEvents.IColonyCampFireRaidEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.enchants.ModEnchants;
import com.minecolonies.api.entity.CustomGoalSelector;
import com.minecolonies.api.entity.ai.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMonster;
import com.minecolonies.api.entity.mobs.RaiderMobUtils;
import com.minecolonies.api.entity.mobs.RaiderType;
import com.minecolonies.api.entity.pathfinding.registry.IPathNavigateRegistry;
import com.minecolonies.api.items.IChiefSwordItem;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.DamageSourceKeys;
import com.minecolonies.core.entity.pathfinding.navigation.AbstractAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.navigation.PathingStuckHandler;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityMinecoloniesRaider
extends AbstractEntityMinecoloniesMonster
implements IThreatTableEntity,
Enemy {
    private static final float HP_PERCENT_PER_DMG = 0.03f;
    private static final int MAX_SCALED_DAMAGE = 7;
    private static final float MIN_THORNS_DAMAGE = 30.0f;
    private static final int THORNS_CHANCE = 5;
    private static final int COLONY_SET_RAIDED_CHANCE = 20;
    private static final int ENV_DAMAGE_COOLDOWN = 30;
    protected AbstractAdvancedPathNavigate newNavigator;
    private IColony colony;
    private int chiefSpeedCooldown = 0;
    private long worldTimeAtSpawn = 0L;
    private int currentTick = 0;
    private int eventID = 0;
    private boolean isRegistered = false;
    private int invulTime = 40;
    private int envDmgCooldown = 0;
    private boolean tempEnvDamageImmunity = true;
    private int collisionCounter = 0;
    private double difficulty = 1.0;
    private ChunkPos lastChunkPos = null;

    public AbstractEntityMinecoloniesRaider(EntityType<? extends AbstractEntityMinecoloniesRaider> type, Level world) {
        this(type, world, 1);
    }

    public AbstractEntityMinecoloniesRaider(EntityType<? extends AbstractEntityMinecoloniesRaider> type, Level world, int textureCount) {
        super(type, world, textureCount);
        this.m_21530_();
        this.f_21345_ = new CustomGoalSelector(this.f_21345_);
        this.f_21346_ = new CustomGoalSelector(this.f_21346_);
        this.f_21364_ = 5;
        this.m_20331_(true);
        RaiderMobUtils.setEquipment(this);
    }

    @Override
    @NotNull
    public AbstractAdvancedPathNavigate getNavigation() {
        if (this.newNavigator == null) {
            this.newNavigator = IPathNavigateRegistry.getInstance().getNavigateFor((Mob)this);
            this.f_21344_ = this.newNavigator;
            this.newNavigator.m_7008_(true);
            this.newNavigator.setSwimSpeedFactor(this.getSwimSpeedFactor());
            this.newNavigator.getPathingOptions().setEnterDoors(true);
            this.newNavigator.getPathingOptions().withDropCost(1.0);
            this.newNavigator.getPathingOptions().withJumpCost(1.0);
            this.newNavigator.getPathingOptions().setPassDanger(true);
            PathingStuckHandler stuckHandler = PathingStuckHandler.createStuckHandler().withTakeDamageOnStuck(0.4f).withBuildLeafBridges().withChanceToByPassMovingAway(0.2).withPlaceLadders();
            if (((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().raidersbreakblocks.get()).booleanValue()) {
                stuckHandler.withBlockBreaks();
                stuckHandler.withCompleteStuckBlockBreak(6);
            }
            this.newNavigator.setStuckHandler(stuckHandler);
        }
        return this.newNavigator;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return this.shouldDespawn() || this.m_9236_() != null && this.m_9236_().isAreaLoaded(this.m_20183_(), 3) && this.getColony() == null;
    }

    @Override
    public abstract RaiderType getRaiderType();

    private boolean shouldDespawn() {
        return this.worldTimeAtSpawn != 0L && this.m_9236_().m_46467_() - this.worldTimeAtSpawn >= 36000L;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        compound.m_128356_("time", this.worldTimeAtSpawn);
        compound.m_128405_("colony", this.colony == null ? 0 : this.colony.getID());
        compound.m_128405_("mc_event_id", this.eventID);
        super.m_7380_(compound);
    }

    @Override
    @Nullable
    public Entity changeDimension(@NotNull ServerLevel serverWorld, @NotNull ITeleporter teleporter) {
        return null;
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        int colonyId;
        this.worldTimeAtSpawn = compound.m_128454_("time");
        this.eventID = compound.m_128451_("mc_event_id");
        if (compound.m_128441_("colony") && (colonyId = compound.m_128451_("colony")) != 0) {
            this.setColony(IColonyManager.getInstance().getColonyByWorld(colonyId, this.m_9236_()));
        }
        if (this.colony == null || this.eventID == 0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        super.m_7378_(compound);
    }

    @Override
    public void m_8107_() {
        if (!this.m_6084_()) {
            return;
        }
        this.m_21203_();
        if (this.invulTime > 0) {
            --this.invulTime;
        } else {
            this.m_20331_(false);
        }
        if (this.collisionCounter > 0) {
            --this.collisionCounter;
        }
        if (this.envDmgCooldown > 0) {
            --this.envDmgCooldown;
        }
        if (this.m_9236_().f_46443_) {
            super.m_8107_();
            return;
        }
        if (++this.currentTick % (this.f_19796_.m_188503_(20) + 1) == 0) {
            if (this.worldTimeAtSpawn == 0L) {
                this.worldTimeAtSpawn = this.m_9236_().m_46467_();
            }
            if (this.m_146902_() != this.lastChunkPos) {
                this.lastChunkPos = this.m_146902_();
                if (this.f_19796_.m_188503_(20) <= 0) {
                    this.onEnterChunk(this.lastChunkPos);
                }
            }
            if (this.shouldDespawn()) {
                this.m_6667_(this.m_9236_().m_269111_().m_269079_(DamageSourceKeys.DESPAWN));
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            if (!this.isRegistered) {
                this.registerWithColony();
            }
            if (--this.chiefSpeedCooldown <= 0) {
                this.chiefSpeedCooldown = 120;
                if (!this.m_21205_().m_41619_() && this.m_21205_().m_41720_() instanceof IChiefSwordItem && this.difficulty > 2.0) {
                    for (AbstractEntityMinecoloniesRaider entity : RaiderMobUtils.getBarbariansCloseToEntity((Entity)this, 7.0)) {
                        if (entity.m_21023_(MobEffects.f_19596_)) continue;
                        entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60, 1));
                    }
                }
            }
        }
        if (this.isRegistered) {
            super.m_8107_();
        }
    }

    private void onEnterChunk(ChunkPos newChunkPos) {
        LevelChunk chunk = this.colony.getWorld().m_6325_(newChunkPos.f_45578_, newChunkPos.f_45579_);
        int owningColonyId = ColonyUtils.getOwningColony(chunk);
        if (owningColonyId != 0 && this.colony.getID() != owningColonyId) {
            IColony tempColony = IColonyManager.getInstance().getColonyByWorld(owningColonyId, this.f_19853_);
            tempColony.getRaiderManager().setPassThroughRaid();
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        RaiderMobUtils.setEquipment(this);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        if (!this.f_19853_.f_46443_ && this.colony != null && this.eventID > 0) {
            this.colony.getEventManager().unregisterEntity((Entity)this, this.eventID);
        }
        super.m_142687_(reason);
    }

    public IColony getColony() {
        return this.colony;
    }

    public void registerWithColony() {
        if (this.colony == null || this.eventID == 0 || this.f_20890_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        RaiderMobUtils.setMobAttributes(this, this.getColony());
        this.colony.getEventManager().registerEntity((Entity)this, this.eventID);
        this.isRegistered = true;
    }

    public void m_6667_(@NotNull DamageSource cause) {
        super.m_6667_(cause);
        if (!this.m_9236_().f_46443_ && this.getColony() != null) {
            this.getColony().getEventManager().onEntityDeath((LivingEntity)this, this.eventID);
        }
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource damageSource, float damage) {
        if (!(damageSource.m_7639_() instanceof LivingEntity) || damageSource.m_7639_() instanceof FakePlayer) {
            float healthLeftPercent;
            if (this.tempEnvDamageImmunity) {
                return false;
            }
            if (this.envDmgCooldown > 0) {
                return false;
            }
            float minimumHealthPct = this.getMinRemainingHealthForEnvironmentalDamage((float)this.difficulty);
            if (minimumHealthPct > (healthLeftPercent = (this.m_21223_() - damage) / this.m_21233_())) {
                return false;
            }
            this.envDmgCooldown = 30;
        } else if (!this.m_9236_().m_5776_()) {
            Entity source;
            IColonyEvent event = this.colony.getEventManager().getEventByID(this.eventID);
            if (event instanceof IColonyCampFireRaidEvent) {
                ((IColonyCampFireRaidEvent)((Object)event)).setCampFireTime(0);
            }
            if ((source = damageSource.m_7639_()) instanceof Player) {
                if (damage > 30.0f && this.f_19796_.m_188503_(5) == 0) {
                    source.m_6469_(this.m_9236_().m_269111_().m_269374_((Entity)this), damage * 0.5f);
                }
                float raiderDamageEnchantLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchants.raiderDamage.get()), (ItemStack)((Player)source).m_21205_());
                float baseScalingDamage = Math.min(damage, 7.0f);
                float totalWithScaled = Math.max(damage, damage - baseScalingDamage + baseScalingDamage * 0.03f * this.m_21233_() * (1.0f + raiderDamageEnchantLevel / 5.0f));
                return super.m_6469_(damageSource, totalWithScaled);
            }
        }
        return super.m_6469_(damageSource, damage);
    }

    protected float getMinRemainingHealthForEnvironmentalDamage(float difficulty) {
        return Math.min(difficulty / 10.0f + 0.2f, 0.6f);
    }

    public void setColony(IColony colony) {
        if (colony != null) {
            this.colony = colony;
        }
    }

    public int getEventID() {
        return this.eventID;
    }

    public void setEventID(int eventID) {
        this.eventID = eventID;
    }

    public void setTempEnvDamageImmunity(boolean immunity) {
        this.tempEnvDamageImmunity = immunity;
    }

    @Override
    public void initStatsFor(double baseHealth, double difficulty, double baseDamage) {
        super.initStatsFor(baseHealth, difficulty, baseDamage);
        this.difficulty = difficulty;
    }

    @Override
    public double getDifficulty() {
        return this.difficulty;
    }

    @Override
    public int getTeamId() {
        return -1;
    }
}

