/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.defaultoptions.difficulty;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.client.screen.ScreenInitEvent;
import net.blay09.mods.defaultoptions.DefaultOptions;
import net.blay09.mods.defaultoptions.config.DefaultOptionsConfig;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.world.Difficulty;

public class DefaultDifficultyHandler {
    public static void initialize() {
        Balm.getEvents().onEvent(ScreenInitEvent.Post.class, DefaultDifficultyHandler::onInitGui);
    }

    public static void onInitGui(ScreenInitEvent.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreateWorldScreen) {
            CreateWorldScreen screen2 = (CreateWorldScreen)screen;
            WorldCreationUiState uiState = screen2.m_267748_();
            Difficulty difficulty = DefaultOptionsConfig.getActive().defaultDifficulty.toDifficulty();
            uiState.m_267754_(difficulty);
            DefaultOptions.logger.info("Default difficulty has been set to {}.", (Object)difficulty);
            if (DefaultOptionsConfig.getActive().lockDifficulty) {
                DefaultDifficultyHandler.lockDifficultyButton(screen2);
            }
            uiState.m_267755_(state -> {
                if (DefaultOptionsConfig.getActive().lockDifficulty) {
                    DefaultDifficultyHandler.lockDifficultyButton(screen2);
                }
            });
        }
    }

    private static void lockDifficultyButton(CreateWorldScreen screen) {
        AbstractWidget difficultyButton = DefaultDifficultyHandler.findDifficultyButton(screen);
        if (difficultyButton != null) {
            difficultyButton.f_93623_ = false;
            DefaultOptions.logger.info("Difficulty has been locked.");
        } else {
            DefaultOptions.logger.error("Could not find difficulty button. Unable to lock difficulty.");
        }
    }

    private static AbstractWidget findDifficultyButton(CreateWorldScreen screen) {
        return screen.m_6702_().stream().filter(it -> {
            CycleButton button;
            return it instanceof CycleButton && (button = (CycleButton)it).m_168883_() instanceof Difficulty;
        }).findAny().orElse(null);
    }
}

