/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetracelium.compat.botania;

import com.google.common.collect.Streams;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.blocks.workbench.gui.WorkbenchStatsGui;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.event.ModularItemDamageEvent;
import se.mickelus.tetra.gui.stats.bar.GuiStatBar;
import se.mickelus.tetra.gui.stats.bar.GuiStatBase;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterInteger;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloStatsGui;
import se.mickelus.tetracelium.compat.botania.ManaRepairStatGetter;
import vazkii.botania.api.mana.ManaItemHandler;

@ParametersAreNonnullByDefault
public class ManaRepair {
    public static ItemEffect effect = ItemEffect.get((String)"manaRepair");

    @OnlyIn(value=Dist.CLIENT)
    public static void clientInit() {
        ManaRepairStatGetter statGetter = new ManaRepairStatGetter();
        GuiStatBar statBar = new GuiStatBar(0, 0, 59, "tetra.stats.manaRepair", 0.0, 400.0, false, false, true, (IStatGetter)statGetter, LabelGetterBasic.integerLabelInverted, (ITooltipGetter)new TooltipGetterInteger("tetra.stats.manaRepair.tooltip", (IStatGetter)statGetter));
        WorkbenchStatsGui.addBar((GuiStatBase)statBar);
        HoloStatsGui.addBar((GuiStatBase)statBar);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.m_9236_().f_46443_ && event.player.m_9236_().m_46467_() % 20L == 0L) {
            Inventory inventory = event.player.m_150109_();
            Streams.concat((Stream[])new Stream[]{inventory.f_35974_.stream(), inventory.f_35975_.stream(), inventory.f_35976_.stream()}).filter(itemStack -> !itemStack.m_41619_()).filter(itemStack -> itemStack.m_41720_() instanceof IModularItem).forEach(itemStack -> ManaRepair.itemInventoryTick(itemStack, (Entity)event.player));
        }
    }

    public static void itemInventoryTick(ItemStack itemStack, Entity entity) {
        int damage;
        Player player;
        int repairAmount;
        float durabilityPerMana = EffectHelper.getEffectEfficiency((ItemStack)itemStack, (ItemEffect)effect);
        if (durabilityPerMana > 0.0f && itemStack.m_41773_() > 0 && entity instanceof Player && (repairAmount = ManaRepair.requestManaForDurability(player = (Player)entity, itemStack, damage = itemStack.m_41773_(), durabilityPerMana)) > 0) {
            itemStack.m_41721_(damage - repairAmount);
            player.m_150109_().m_6596_();
        }
    }

    @SubscribeEvent
    public static void onModularItemDamage(ModularItemDamageEvent event) {
        event.setAmount(ManaRepair.reduceDurabilityDamage((Entity)event.getUsingEntity(), event.getItemStack(), event.getAmount()));
    }

    public static int reduceDurabilityDamage(@Nullable Entity entity, ItemStack itemStack, int amount) {
        float durabilityPerMana = EffectHelper.getEffectEfficiency((ItemStack)itemStack, (ItemEffect)effect);
        if (durabilityPerMana > 0.0f && entity instanceof Player) {
            Player player = (Player)entity;
            int result = ManaRepair.requestManaForDurability(player, itemStack, amount, durabilityPerMana);
            return amount - result;
        }
        return amount;
    }

    private static int requestManaForDurability(Player player, ItemStack itemStack, int damage, float durabilityPerMana) {
        int grantedMana = ManaItemHandler.instance().requestManaForTool(itemStack, player, Mth.m_14167_((float)((float)damage / durabilityPerMana)), true);
        return Math.min((int)(durabilityPerMana * (float)grantedMana), damage);
    }
}

