/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.config;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.config.ConfigScreen;
import dlovin.inventoryhud.gui.widgets.ButtonWidget;
import dlovin.inventoryhud.gui.widgets.CheckBox;
import dlovin.inventoryhud.gui.widgets.TextField;
import dlovin.inventoryhud.references.Translation;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;

public class ArmorConfigScreen
extends ConfigScreen {
    private final ResourceLocation CB_ARM = new ResourceLocation("inventoryhud", "textures/gui/cb_arm.png");
    private final ResourceLocation CB_MH = new ResourceLocation("inventoryhud", "textures/gui/cb_mh.png");
    private final ResourceLocation CB_OH = new ResourceLocation("inventoryhud", "textures/gui/cb_oh.png");
    private final ResourceLocation CB_AR = new ResourceLocation("inventoryhud", "textures/gui/cb_ar.png");
    private final ResourceLocation CB_INV = new ResourceLocation("inventoryhud", "textures/gui/cb_inv.png");

    public ArmorConfigScreen(boolean inGame) {
        super(1, inGame);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        String toggle = (Boolean)InventoryHUD.getClientConfig().ArmorDamage.get() != false ? ChatFormatting.DARK_GREEN + "ON" : ChatFormatting.DARK_RED + "OFF";
        this.addButton(0, toggle, this::ToggleSwitch);
        this.addNumericField(1, 0, 100, (Integer)InventoryHUD.getClientConfig().armAbove.get(), this::AboveChanged, 5);
        this.addCheckbox(2, (Boolean)InventoryHUD.getClientConfig().showArmor.get(), this::TypeArmorChanged, this.CB_ARM);
        this.addCheckbox(2, 22, (Boolean)InventoryHUD.getClientConfig().showMain.get(), this::TypeMainHandChanged, this.CB_MH);
        this.addCheckbox(2, 44, (Boolean)InventoryHUD.getClientConfig().showOff.get(), this::TypeOffHandChanged, this.CB_OH);
        this.addCheckbox(2, 66, (Boolean)InventoryHUD.getClientConfig().showArrows.get(), this::TypeArrowChanged, this.CB_AR);
        this.addCheckbox(2, 88, (Boolean)InventoryHUD.getClientConfig().showInv.get(), this::TypeInvChanged, this.CB_INV);
        this.addButton(3, 75, ((InvConfig.ArmorView)((Object)InventoryHUD.getClientConfig().armView.get())).name(), this::ViewSwitch);
        this.addButton(4, ((Boolean)InventoryHUD.getClientConfig().armBars.get()).toString(), this::BarsSwitch);
        this.addButton(5, ((Boolean)InventoryHUD.getClientConfig().moveAll.get()).toString(), this::MoveSwitch);
        this.addButton(6, ((Boolean)InventoryHUD.getClientConfig().showEmpty.get()).toString(), this::EmptySwitch);
        this.addButton(7, ((Boolean)InventoryHUD.getClientConfig().showCount.get()).toString(), this::CountSwitch);
        float sc = (float)((Integer)InventoryHUD.getClientConfig().armScale.get()).intValue() / 100.0f;
        String t = sc + "x";
        this.addButton(8, t, this::ScaleSwitch);
        this.addButton(9, ((Boolean)InventoryHUD.getClientConfig().showArrowsWithoutWeapon.get()).toString(), this::ShowArrows);
        this.addButton(10, ((Boolean)InventoryHUD.getClientConfig().armWithDebug.get()).toString(), this::WithDebug);
        this.addText(10, Translation.WITH_DEBUG.getString(), Translation.ARM_DEBUG_TT);
        this.addText(9, Translation.ARROWS_WITHOUT_WEAPON.getString(), Translation.ARROWS_WITHOUT_WEAPON_TT);
        this.addText(8, Translation.ARM_SCALE.getString(), Translation.ARM_SCALE_TT);
        this.addText(7, Translation.ARM_COUNT.getString(), Translation.ARM_COUNT_TT);
        this.addText(6, Translation.ARM_EMPTY.getString(), Translation.ARM_EMPTY_TT);
        this.addText(5, Translation.ARM_MOVE.getString(), Translation.ARM_MOVE_TT);
        this.addText(4, Translation.ARM_BARS.getString(), Translation.ARM_BARS_TT);
        this.addText(3, Translation.ARM_VIEW.getString(), Translation.ARM_VIEW_TT);
        this.addText(2, Translation.ARM_TYPE.getString(), Translation.ARM_TYPE_TT);
        this.addText(1, Translation.ARM_HIDE.getString(), Translation.ARM_HIDE_TT);
        this.addText(0, Translation.ARM_TOGGLE.getString(), Translation.ARM_TOGGLE_TT);
    }

    private void ShowArrows(ButtonWidget btn) {
        Boolean bd = (Boolean)InventoryHUD.getClientConfig().showArrowsWithoutWeapon.get() == false;
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showArrowsWithoutWeapon = bd;
        InventoryHUD.getClientConfig().showArrowsWithoutWeapon.set((Object)bd);
        btn.setMessage(bd.toString());
        InventoryHUD.saveConfig();
    }

    private void WithDebug(ButtonWidget btn) {
        Boolean bd = (Boolean)InventoryHUD.getClientConfig().armWithDebug.get() == false;
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.withDebug = bd;
        InventoryHUD.getClientConfig().armWithDebug.set((Object)bd);
        btn.setMessage(bd.toString());
        InventoryHUD.saveConfig();
    }

    private void ScaleSwitch(ButtonWidget btn) {
        int scale = (int)((InventoryHUD.getInstance().getInventoryGui().armorRenderer.armScale * 100.0f + 25.0f) % 175.0f);
        if (scale == 0) {
            scale = 50;
        }
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.armScale = (float)scale * 0.01f;
        InventoryHUD.getInstance().getInventoryGui().changeArmorOffset();
        InventoryHUD.getClientConfig().armScale.set((Object)scale);
        float sc = (float)((Integer)InventoryHUD.getClientConfig().armScale.get()).intValue() / 100.0f;
        String t = sc + "x";
        btn.setMessage(t);
        InventoryHUD.saveConfig();
        if (InventoryHUD.isCuriosMod) {
            InventoryHUD.getInstance().getInventoryGui().curiosRenderer.armScale = (float)scale * 0.01f;
        }
    }

    private void CountSwitch(ButtonWidget btn) {
        Boolean bd = (Boolean)InventoryHUD.getClientConfig().showCount.get() == false;
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showCount = bd;
        InventoryHUD.getClientConfig().showCount.set((Object)bd);
        btn.setMessage(bd.toString());
        InventoryHUD.saveConfig();
        if (InventoryHUD.isCuriosMod) {
            InventoryHUD.getInstance().getInventoryGui().curiosRenderer.showCount = bd;
        }
    }

    private void TypeArmorChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showArmor = cb.checked;
        InventoryHUD.getClientConfig().showArmor.set((Object)cb.checked);
        InventoryHUD.saveConfig();
    }

    private void TypeMainHandChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showMain = cb.checked;
        InventoryHUD.getClientConfig().showMain.set((Object)cb.checked);
        InventoryHUD.saveConfig();
    }

    private void TypeOffHandChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showOff = cb.checked;
        InventoryHUD.getClientConfig().showOff.set((Object)cb.checked);
        InventoryHUD.saveConfig();
    }

    private void TypeArrowChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showArrows = cb.checked;
        InventoryHUD.getClientConfig().showArrows.set((Object)cb.checked);
        InventoryHUD.saveConfig();
    }

    private void TypeInvChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showInv = cb.checked;
        InventoryHUD.getClientConfig().showInv.set((Object)cb.checked);
        InventoryHUD.saveConfig();
    }

    private void AboveChanged(TextField field) {
        int a;
        try {
            a = Integer.parseInt(field.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.armAbove = a;
        InventoryHUD.getClientConfig().armAbove.set((Object)a);
        InventoryHUD.saveConfig();
        if (InventoryHUD.isCuriosMod) {
            InventoryHUD.getInstance().getInventoryGui().curiosRenderer.armAbove = a;
        }
    }

    private void MoveSwitch(ButtonWidget btn) {
        Boolean bd = (Boolean)InventoryHUD.getClientConfig().moveAll.get() == false;
        InventoryHUD.getInstance().getInventoryGui().changeMoveAll(bd);
        InventoryHUD.getClientConfig().moveAll.set((Object)bd);
        btn.setMessage(bd.toString());
        InventoryHUD.saveConfig();
    }

    private void EmptySwitch(ButtonWidget btn) {
        Boolean bd = (Boolean)InventoryHUD.getClientConfig().showEmpty.get() == false;
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showEmpty = bd;
        InventoryHUD.getClientConfig().showEmpty.set((Object)bd);
        btn.setMessage(bd.toString());
        InventoryHUD.saveConfig();
        if (InventoryHUD.isCuriosMod) {
            InventoryHUD.getInstance().getInventoryGui().curiosRenderer.showEmpty = bd;
        }
    }

    private void ViewSwitch(ButtonWidget btn) {
        InvConfig.ArmorView at;
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.armView = at = (switch ((InvConfig.ArmorView)((Object)InventoryHUD.getClientConfig().armView.get())) {
            default -> throw new IncompatibleClassChangeError();
            case InvConfig.ArmorView.PERCENTAGE -> InvConfig.ArmorView.DAMAGE;
            case InvConfig.ArmorView.DAMAGE -> InvConfig.ArmorView.DAMAGE_LEFT;
            case InvConfig.ArmorView.DAMAGE_LEFT -> InvConfig.ArmorView.OFF;
            case InvConfig.ArmorView.OFF -> InvConfig.ArmorView.PERCENTAGE;
        });
        InventoryHUD.getClientConfig().armView.set((Object)at);
        btn.setMessage(at.name());
        InventoryHUD.saveConfig();
        if (InventoryHUD.isCuriosMod) {
            InventoryHUD.getInstance().getInventoryGui().curiosRenderer.armView = at;
        }
    }

    private void ToggleSwitch(ButtonWidget btn) {
        Boolean armor = (Boolean)InventoryHUD.getClientConfig().ArmorDamage.get() == false;
        InventoryHUD.armorHUD = armor;
        InventoryHUD.getClientConfig().ArmorDamage.set((Object)armor);
        String armString = armor != false ? ChatFormatting.DARK_GREEN + "ON" : ChatFormatting.DARK_RED + "OFF";
        btn.setMessage(armString);
        InventoryHUD.saveConfig();
    }

    private void BarsSwitch(ButtonWidget btn) {
        Boolean bars = (Boolean)InventoryHUD.getClientConfig().armBars.get() == false;
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.armBars = bars;
        InventoryHUD.getClientConfig().armBars.set((Object)bars);
        btn.setMessage(bars.toString());
        InventoryHUD.saveConfig();
        if (InventoryHUD.isCuriosMod) {
            InventoryHUD.getInstance().getInventoryGui().curiosRenderer.armBars = bars;
        }
    }
}

