/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.skill.bonus.player;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import daripher.skilltree.client.screen.SkillTreeEditorScreen;
import daripher.skilltree.client.tooltip.TooltipHelper;
import daripher.skilltree.init.PSTSkillBonuses;
import daripher.skilltree.skill.bonus.SkillBonus;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public final class GainedExperienceBonus
implements SkillBonus<GainedExperienceBonus> {
    private ExperienceSource experienceSource;
    private float multiplier;

    public GainedExperienceBonus(float multiplier, ExperienceSource source) {
        this.multiplier = multiplier;
        this.experienceSource = source;
    }

    @Override
    public SkillBonus.Serializer getSerializer() {
        return (SkillBonus.Serializer)PSTSkillBonuses.GAINED_EXPERIENCE.get();
    }

    public GainedExperienceBonus copy() {
        return new GainedExperienceBonus(this.multiplier, this.experienceSource);
    }

    @Override
    public GainedExperienceBonus multiply(double multiplier) {
        this.multiplier = (float)((double)this.multiplier * multiplier);
        return this;
    }

    @Override
    public boolean canMerge(SkillBonus<?> other) {
        if (!(other instanceof GainedExperienceBonus)) {
            return false;
        }
        GainedExperienceBonus otherBonus = (GainedExperienceBonus)other;
        return Objects.equals((Object)otherBonus.experienceSource, (Object)this.experienceSource);
    }

    @Override
    public SkillBonus<GainedExperienceBonus> merge(SkillBonus<?> other) {
        if (!(other instanceof GainedExperienceBonus)) {
            throw new IllegalArgumentException();
        }
        GainedExperienceBonus otherBonus = (GainedExperienceBonus)other;
        return new GainedExperienceBonus(otherBonus.multiplier + this.multiplier, this.experienceSource);
    }

    @Override
    public MutableComponent getTooltip() {
        MutableComponent sourceDescription = Component.m_237115_((String)this.experienceSource.getDescriptionId());
        MutableComponent bonusDescription = Component.m_237110_((String)this.getDescriptionId(), (Object[])new Object[]{sourceDescription});
        return TooltipHelper.getSkillBonusTooltip((Component)bonusDescription, (double)this.multiplier, AttributeModifier.Operation.MULTIPLY_BASE).m_130948_(TooltipHelper.getSkillBonusStyle(this.isPositive()));
    }

    @Override
    public boolean isPositive() {
        return this.multiplier > 0.0f;
    }

    @Override
    public void addEditorWidgets(SkillTreeEditorScreen editor, int row, Consumer<GainedExperienceBonus> consumer) {
        editor.addLabel(0, 0, "Multiplier", ChatFormatting.GOLD);
        editor.addLabel(110, 0, "Source", ChatFormatting.GOLD);
        editor.shiftWidgets(0, 19);
        editor.addNumericTextField(0, 0, 90, 14, this.multiplier).setNumericResponder(v -> {
            this.setMultiplier(v.floatValue());
            consumer.accept(this.copy());
        });
        editor.addDropDownList(110, 0, 90, 14, 10, this.experienceSource).setToNameFunc(ExperienceSource::getFormattedName).setResponder(s -> {
            this.setExpericenSource((ExperienceSource)((Object)s));
            consumer.accept(this.copy());
        });
        editor.shiftWidgets(0, 19);
    }

    public void setMultiplier(float multiplier) {
        this.multiplier = multiplier;
    }

    public void setExpericenSource(ExperienceSource experienceSource) {
        this.experienceSource = experienceSource;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public ExperienceSource getSource() {
        return this.experienceSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GainedExperienceBonus that = (GainedExperienceBonus)o;
        if (Float.compare(this.multiplier, that.multiplier) != 0) {
            return false;
        }
        return this.experienceSource == that.experienceSource;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.experienceSource, Float.valueOf(this.multiplier)});
    }

    public static enum ExperienceSource {
        MOBS("mobs"),
        FISHING("fishing"),
        ORE("ore");

        final String name;

        private ExperienceSource(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Component getFormattedName() {
            return Component.m_237113_((String)(this.getName().substring(0, 1).toUpperCase() + this.getName().substring(1)));
        }

        public static ExperienceSource byName(String name) {
            for (ExperienceSource type : ExperienceSource.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            return MOBS;
        }

        public String getDescriptionId() {
            return "experience.source." + this.getName();
        }
    }

    public static class Serializer
    implements SkillBonus.Serializer {
        @Override
        public GainedExperienceBonus deserialize(JsonObject json) throws JsonParseException {
            float multiplier = json.get("multiplier").getAsFloat();
            ExperienceSource experienceSource = ExperienceSource.byName(json.get("experience_source").getAsString());
            return new GainedExperienceBonus(multiplier, experienceSource);
        }

        @Override
        public void serialize(JsonObject json, SkillBonus<?> bonus) {
            if (!(bonus instanceof GainedExperienceBonus)) {
                throw new IllegalArgumentException();
            }
            GainedExperienceBonus aBonus = (GainedExperienceBonus)bonus;
            json.addProperty("multiplier", (Number)Float.valueOf(aBonus.multiplier));
            json.addProperty("experience_source", aBonus.experienceSource.name);
        }

        @Override
        public GainedExperienceBonus deserialize(CompoundTag tag) {
            float multiplier = tag.m_128457_("multiplier");
            ExperienceSource experienceSource = ExperienceSource.byName(tag.m_128461_("experience_source"));
            return new GainedExperienceBonus(multiplier, experienceSource);
        }

        @Override
        public CompoundTag serialize(SkillBonus<?> bonus) {
            if (!(bonus instanceof GainedExperienceBonus)) {
                throw new IllegalArgumentException();
            }
            GainedExperienceBonus aBonus = (GainedExperienceBonus)bonus;
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("multiplier", aBonus.multiplier);
            tag.m_128359_("experience_source", aBonus.experienceSource.name);
            return tag;
        }

        @Override
        public GainedExperienceBonus deserialize(FriendlyByteBuf buf) {
            return new GainedExperienceBonus(buf.readFloat(), ExperienceSource.byName(buf.m_130277_()));
        }

        @Override
        public void serialize(FriendlyByteBuf buf, SkillBonus<?> bonus) {
            if (!(bonus instanceof GainedExperienceBonus)) {
                throw new IllegalArgumentException();
            }
            GainedExperienceBonus aBonus = (GainedExperienceBonus)bonus;
            buf.writeFloat(aBonus.multiplier);
            buf.m_130070_(aBonus.experienceSource.name);
        }

        @Override
        public SkillBonus<?> createDefaultInstance() {
            return new GainedExperienceBonus(0.25f, ExperienceSource.MOBS);
        }
    }
}

