/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.skill.bonus.player;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import daripher.skilltree.client.screen.SkillTreeEditorScreen;
import daripher.skilltree.client.tooltip.TooltipHelper;
import daripher.skilltree.data.serializers.SerializationHelper;
import daripher.skilltree.init.PSTItemConditions;
import daripher.skilltree.init.PSTSkillBonuses;
import daripher.skilltree.network.NetworkHelper;
import daripher.skilltree.skill.bonus.SkillBonus;
import daripher.skilltree.skill.bonus.condition.item.ItemCondition;
import daripher.skilltree.skill.bonus.condition.item.ItemTagCondition;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.Tags;

public final class CantUseItemBonus
implements SkillBonus<CantUseItemBonus> {
    @Nonnull
    private ItemCondition itemCondition;

    public CantUseItemBonus(@Nonnull ItemCondition itemCondition) {
        this.itemCondition = itemCondition;
    }

    @Override
    public SkillBonus.Serializer getSerializer() {
        return (SkillBonus.Serializer)PSTSkillBonuses.CANT_USE_ITEM.get();
    }

    public CantUseItemBonus copy() {
        return new CantUseItemBonus(this.itemCondition);
    }

    @Override
    public CantUseItemBonus multiply(double multiplier) {
        return this;
    }

    @Override
    public boolean canMerge(SkillBonus<?> other) {
        if (!(other instanceof CantUseItemBonus)) {
            return false;
        }
        CantUseItemBonus otherBonus = (CantUseItemBonus)other;
        return Objects.equals(otherBonus.itemCondition, this.itemCondition);
    }

    @Override
    public SkillBonus<CantUseItemBonus> merge(SkillBonus<?> other) {
        return this;
    }

    @Override
    public MutableComponent getTooltip() {
        Component itemDescription = this.itemCondition.getTooltip("plural");
        return Component.m_237110_((String)this.getDescriptionId(), (Object[])new Object[]{itemDescription}).m_130948_(TooltipHelper.getSkillBonusStyle(this.isPositive()));
    }

    @Override
    public boolean isPositive() {
        return false;
    }

    @Override
    public void addEditorWidgets(SkillTreeEditorScreen editor, int row, Consumer<CantUseItemBonus> consumer) {
        editor.addLabel(0, 0, "Item Condition", ChatFormatting.GOLD);
        editor.shiftWidgets(0, 19);
        editor.addDropDownList(0, 0, 200, 14, 10, this.itemCondition, PSTItemConditions.conditionsList()).setToNameFunc(a -> Component.m_237113_((String)PSTItemConditions.getName(a))).setResponder(c -> {
            this.setItemCondition((ItemCondition)c);
            consumer.accept(this.copy());
            editor.m_232761_();
        });
        editor.shiftWidgets(0, 19);
        this.itemCondition.addEditorWidgets(editor, c -> {
            this.setItemCondition((ItemCondition)c);
            consumer.accept(this.copy());
        });
    }

    public void setItemCondition(@Nonnull ItemCondition itemCondition) {
        this.itemCondition = itemCondition;
    }

    @Nonnull
    public ItemCondition getItemCondition() {
        return this.itemCondition;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CantUseItemBonus that = (CantUseItemBonus)obj;
        return Objects.equals(this.itemCondition, that.itemCondition);
    }

    public int hashCode() {
        return Objects.hash(this.itemCondition);
    }

    public static class Serializer
    implements SkillBonus.Serializer {
        @Override
        public CantUseItemBonus deserialize(JsonObject json) throws JsonParseException {
            ItemCondition condition = SerializationHelper.deserializeItemCondition(json);
            return new CantUseItemBonus(condition);
        }

        @Override
        public void serialize(JsonObject json, SkillBonus<?> bonus) {
            if (!(bonus instanceof CantUseItemBonus)) {
                throw new IllegalArgumentException();
            }
            CantUseItemBonus aBonus = (CantUseItemBonus)bonus;
            SerializationHelper.serializeItemCondition(json, aBonus.itemCondition);
        }

        @Override
        public CantUseItemBonus deserialize(CompoundTag tag) {
            ItemCondition condition = SerializationHelper.deserializeItemCondition(tag);
            return new CantUseItemBonus(condition);
        }

        @Override
        public CompoundTag serialize(SkillBonus<?> bonus) {
            if (!(bonus instanceof CantUseItemBonus)) {
                throw new IllegalArgumentException();
            }
            CantUseItemBonus aBonus = (CantUseItemBonus)bonus;
            CompoundTag tag = new CompoundTag();
            SerializationHelper.serializeItemCondition(tag, aBonus.itemCondition);
            return tag;
        }

        @Override
        public CantUseItemBonus deserialize(FriendlyByteBuf buf) {
            return new CantUseItemBonus(NetworkHelper.readItemCondition(buf));
        }

        @Override
        public void serialize(FriendlyByteBuf buf, SkillBonus<?> bonus) {
            if (!(bonus instanceof CantUseItemBonus)) {
                throw new IllegalArgumentException();
            }
            CantUseItemBonus aBonus = (CantUseItemBonus)bonus;
            NetworkHelper.writeItemCondition(buf, aBonus.itemCondition);
        }

        @Override
        public SkillBonus<?> createDefaultInstance() {
            return new CantUseItemBonus(new ItemTagCondition(Tags.Items.TOOLS_BOWS.f_203868_()));
        }
    }
}

