/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.skill.bonus.condition.living;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import daripher.skilltree.client.screen.SkillTreeEditorScreen;
import daripher.skilltree.init.PSTLivingConditions;
import daripher.skilltree.skill.bonus.condition.living.LivingCondition;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public final class HealthPercentageCondition
implements LivingCondition {
    private float min;
    private float max;

    public HealthPercentageCondition(float min, float max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean met(LivingEntity living) {
        float percentage = living.m_21223_() / living.m_21233_();
        if (this.min == -1.0f) {
            return percentage <= this.max;
        }
        if (this.max == -1.0f) {
            return percentage >= this.min;
        }
        return percentage <= this.max && percentage >= this.min;
    }

    @Override
    public MutableComponent getTooltip(MutableComponent bonusTooltip, String target) {
        String key = this.getDescriptionId();
        MutableComponent targetDescription = Component.m_237115_((String)"%s.target.%s".formatted(key, target));
        String min = ItemStack.f_41584_.format(this.min * 100.0f);
        String max = ItemStack.f_41584_.format(this.max * 100.0f);
        if (this.min == -1.0f) {
            return Component.m_237110_((String)(key + ".max"), (Object[])new Object[]{bonusTooltip, targetDescription, max});
        }
        if (this.max == -1.0f) {
            return Component.m_237110_((String)(key + ".min"), (Object[])new Object[]{bonusTooltip, targetDescription, min});
        }
        return Component.m_237110_((String)(key + ".range"), (Object[])new Object[]{bonusTooltip, targetDescription, min, max});
    }

    @Override
    public LivingCondition.Serializer getSerializer() {
        return (LivingCondition.Serializer)PSTLivingConditions.HEALTH_PERCENTAGE.get();
    }

    @Override
    public void addEditorWidgets(SkillTreeEditorScreen editor, Consumer<LivingCondition> consumer) {
        editor.addLabel(0, 0, "Min", ChatFormatting.GREEN);
        editor.addLabel(55, 0, "Max", ChatFormatting.GREEN);
        editor.shiftWidgets(0, 19);
        editor.addNumericTextField(0, 0, 50, 14, this.min).setNumericResponder(a -> {
            this.setMin(a.floatValue());
            consumer.accept(this);
        });
        editor.addNumericTextField(55, 0, 50, 14, this.max).setNumericResponder(a -> {
            this.setMax(a.floatValue());
            consumer.accept(this);
        });
        editor.shiftWidgets(0, 19);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HealthPercentageCondition that = (HealthPercentageCondition)o;
        return Float.compare(this.min, that.min) == 0 && Float.compare(this.max, that.max) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.min), Float.valueOf(this.max));
    }

    public void setMin(float min) {
        this.min = min;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public static class Serializer
    implements LivingCondition.Serializer {
        @Override
        public LivingCondition deserialize(JsonObject json) throws JsonParseException {
            float min = json.has("min") ? json.get("min").getAsFloat() : -1.0f;
            float max = json.has("max") ? json.get("max").getAsFloat() : -1.0f;
            return new HealthPercentageCondition(min, max);
        }

        @Override
        public void serialize(JsonObject json, LivingCondition condition) {
            if (!(condition instanceof HealthPercentageCondition)) {
                throw new IllegalArgumentException();
            }
            HealthPercentageCondition aCondition = (HealthPercentageCondition)condition;
            if (aCondition.min != -1.0f) {
                json.addProperty("min", (Number)Float.valueOf(aCondition.min));
            }
            if (aCondition.max != -1.0f) {
                json.addProperty("max", (Number)Float.valueOf(aCondition.max));
            }
        }

        @Override
        public LivingCondition deserialize(CompoundTag tag) {
            float min = tag.m_128441_("Min") ? tag.m_128457_("Min") : -1.0f;
            float max = tag.m_128441_("Max") ? tag.m_128457_("Max") : -1.0f;
            return new HealthPercentageCondition(min, max);
        }

        @Override
        public CompoundTag serialize(LivingCondition condition) {
            if (!(condition instanceof HealthPercentageCondition)) {
                throw new IllegalArgumentException();
            }
            HealthPercentageCondition aCondition = (HealthPercentageCondition)condition;
            CompoundTag tag = new CompoundTag();
            if (aCondition.min != -1.0f) {
                tag.m_128350_("Min", aCondition.min);
            }
            if (aCondition.max != -1.0f) {
                tag.m_128350_("Max", aCondition.max);
            }
            return tag;
        }

        @Override
        public LivingCondition deserialize(FriendlyByteBuf buf) {
            return new HealthPercentageCondition(buf.readFloat(), buf.readFloat());
        }

        @Override
        public void serialize(FriendlyByteBuf buf, LivingCondition condition) {
            if (!(condition instanceof HealthPercentageCondition)) {
                throw new IllegalArgumentException();
            }
            HealthPercentageCondition aCondition = (HealthPercentageCondition)condition;
            buf.writeFloat(aCondition.min);
            buf.writeFloat(aCondition.max);
        }

        @Override
        public LivingCondition createDefaultInstance() {
            return new HealthPercentageCondition(-1.0f, 0.5f);
        }
    }
}

