/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.recipe;

import com.google.gson.JsonObject;
import daripher.skilltree.init.PSTRecipeSerializers;
import daripher.skilltree.potion.PotionHelper;
import daripher.skilltree.recipe.SkillRequiringRecipe;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MixtureRecipe
extends CustomRecipe
implements SkillRequiringRecipe {
    public MixtureRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.MISC);
    }

    public boolean matches(@NotNull CraftingContainer container, @NotNull Level level) {
        if (this.isUncraftable((Container)container, (Recipe)this)) {
            return false;
        }
        ItemStack potionStack1 = ItemStack.f_41583_;
        ItemStack potionStack2 = ItemStack.f_41583_;
        int potionsCount = 0;
        for (int slot = 0; slot < container.m_6643_(); ++slot) {
            ItemStack stackInSlot = container.m_8020_(slot);
            if (stackInSlot.m_41619_() || !PotionHelper.isPotion(stackInSlot) || PotionHelper.isMixture(stackInSlot)) continue;
            ++potionsCount;
            if (potionStack1.m_41619_()) {
                potionStack1 = stackInSlot;
                continue;
            }
            potionStack2 = stackInSlot;
        }
        if (PotionUtils.m_43547_((ItemStack)potionStack1).isEmpty() || PotionUtils.m_43547_((ItemStack)potionStack2).isEmpty()) {
            return false;
        }
        return potionsCount == 2 && potionStack1.m_41720_() == potionStack2.m_41720_();
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer container, @NotNull RegistryAccess access) {
        if (this.isUncraftable((Container)container, (Recipe)this)) {
            return ItemStack.f_41583_;
        }
        ItemStack potionStack1 = ItemStack.f_41583_;
        ItemStack potionStack2 = ItemStack.f_41583_;
        for (int slot = 0; slot < container.m_6643_(); ++slot) {
            ItemStack stackInSlot = container.m_8020_(slot);
            if (stackInSlot.m_41619_() || !PotionHelper.isPotion(stackInSlot) || PotionHelper.isMixture(stackInSlot)) continue;
            if (potionStack1.m_41619_()) {
                potionStack1 = stackInSlot;
                continue;
            }
            potionStack2 = stackInSlot;
        }
        return PotionHelper.mixPotions(potionStack1, potionStack2);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)PSTRecipeSerializers.POTION_MIXING.get();
    }

    public static class Serializer
    implements RecipeSerializer<MixtureRecipe> {
        @NotNull
        public MixtureRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject jsonObject) {
            return new MixtureRecipe(id);
        }

        public MixtureRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            return new MixtureRecipe(id);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull MixtureRecipe recipe) {
        }
    }
}

