/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.mixin.minecraft;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import daripher.itemproduction.block.entity.Interactive;
import daripher.skilltree.mixin.RecipeCollectionAccessor;
import daripher.skilltree.recipe.SkillRequiringRecipe;
import java.util.ArrayList;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.crafting.Recipe;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={RecipeBookComponent.class})
public class RecipeBookComponentMixin {
    @Shadow
    protected RecipeBookMenu<?> f_100271_;

    @ModifyExpressionValue(method={"updateCollections"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/Lists;newArrayList(Ljava/lang/Iterable;)Ljava/util/ArrayList;")})
    private ArrayList<RecipeCollection> removeUncraftableRecipes(ArrayList<RecipeCollection> original) {
        original.forEach(this::removeUncraftableRecipes);
        return original;
    }

    protected void removeUncraftableRecipes(RecipeCollection recipeCollection) {
        RecipeCollectionAccessor accessor = (RecipeCollectionAccessor)recipeCollection;
        accessor.getCraftable().removeIf(this::isUncraftable);
    }

    private boolean isUncraftable(Recipe<?> recipe) {
        if (!(recipe instanceof SkillRequiringRecipe)) {
            return false;
        }
        SkillRequiringRecipe aRecipe = (SkillRequiringRecipe)recipe;
        RecipeBookMenu<?> recipeBookMenu = this.f_100271_;
        if (!(recipeBookMenu instanceof Interactive)) {
            return true;
        }
        Interactive interactive = (Interactive)recipeBookMenu;
        return aRecipe.isUncraftable(interactive, recipe);
    }
}

