/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.data.generation.skills;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import daripher.skilltree.data.generation.skills.PSTSkillsProvider;
import daripher.skilltree.data.reloader.SkillTreesReloader;
import daripher.skilltree.skill.PassiveSkillTree;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class PSTSkillTreesProvider
implements DataProvider {
    private final PackOutput packOutput;
    private final PSTSkillsProvider skillsProvider;

    public PSTSkillTreesProvider(DataGenerator dataGenerator, PSTSkillsProvider skillsProvider) {
        this.packOutput = dataGenerator.getPackOutput();
        this.skillsProvider = skillsProvider;
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput output) {
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        PassiveSkillTree skillTree = new PassiveSkillTree(new ResourceLocation("skilltree", "main_tree"));
        this.skillsProvider.getSkills().keySet().forEach(skillTree.getSkillIds()::add);
        Path path = this.packOutput.m_245114_().resolve(this.getSkillTreePath(skillTree));
        JsonElement json = SkillTreesReloader.GSON.toJsonTree((Object)skillTree);
        futuresBuilder.add((Object)DataProvider.m_253162_((CachedOutput)output, (JsonElement)json, (Path)path));
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    public String getSkillTreePath(PassiveSkillTree skillTree) {
        ResourceLocation id = skillTree.getId();
        return "data/%s/skill_trees/%s.json".formatted(id.m_135827_(), id.m_135815_());
    }

    @NotNull
    public String m_6055_() {
        return "Skill Trees Provider";
    }
}

