/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import team.tnt.collectorsalbum.common.resource.function.ConstantNumberProvider;
import team.tnt.collectorsalbum.common.resource.function.NumberProvider;
import team.tnt.collectorsalbum.common.resource.function.NumberProviderType;

public class WeightedRandom<T>
implements Supplier<T> {
    private final Random random = new Random();
    private final List<WeightedItem<T>> items;
    private final T defaultValue;
    private Integer total;

    public WeightedRandom(List<WeightedItem<T>> items, T defaultValue) {
        this.items = items;
        this.defaultValue = defaultValue;
    }

    public WeightedRandom(List<WeightedItem<T>> items) {
        this(items, null);
    }

    public void setSeed(long seed) {
        this.random.setSeed(seed);
    }

    public static <T> Codec<WeightedRandom<T>> codec(Codec<T> elementCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)WeightedItem.codec(elementCodec).listOf().fieldOf("items").forGetter(t -> t.items), (App)elementCodec.optionalFieldOf("defaultValue").forGetter(t -> Optional.ofNullable(t.defaultValue))).apply((Applicative)instance, (items, defaultValueOptional) -> new WeightedRandom<Object>((List<WeightedItem<Object>>)items, defaultValueOptional.orElse(null))));
    }

    @Override
    public T get() {
        if (this.total == null) {
            this.total = this.getTotal();
        }
        if (this.total > 0) {
            int roll = this.random.nextInt(this.total);
            for (WeightedItem<T> item : this.items) {
                int itemWeight = item.getWeight();
                if ((roll -= itemWeight) > 0) continue;
                return item.item;
            }
        }
        return this.defaultValue;
    }

    private int getTotal() {
        return this.items.stream().mapToInt(WeightedItem::getWeight).sum();
    }

    public record WeightedItem<T>(NumberProvider weight, T item) {
        public static <T> WeightedItem<T> decode(Either<Integer, NumberProvider> weight, T item) {
            return new WeightedItem<T>((NumberProvider)weight.map(num -> ConstantNumberProvider.ONE, Function.identity()), item);
        }

        public int getWeight() {
            return this.weight.intValue();
        }

        public static <T> Codec<WeightedItem<T>> codec(Codec<T> elementCodec) {
            return RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)Codec.INT, NumberProviderType.INSTANCE_CODEC).fieldOf("weight").forGetter(item -> Either.right((Object)item.weight)), (App)elementCodec.fieldOf("item").forGetter(t -> t.item)).apply((Applicative)instance, WeightedItem::decode));
        }
    }
}

