/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.platform.resource;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;
import team.tnt.collectorsalbum.CollectorsAlbum;
import team.tnt.collectorsalbum.platform.resource.PlatformGsonReloadListener;

public abstract class PlatformGsonCodecReloadListener<T>
extends PlatformGsonReloadListener {
    public static final Gson GSON = new Gson();
    private final Codec<T> codec;

    public PlatformGsonCodecReloadListener(String dir, Codec<T> codec) {
        super(GSON, dir);
        this.codec = codec;
    }

    public Codec<T> codec() {
        return this.codec;
    }

    public List<T> getNetworkData() {
        return null;
    }

    public synchronized void onNetworkDataReceived(List<T> collection) {
    }

    protected abstract void preApply(Map<ResourceLocation, JsonElement> var1, ResourceManager var2, ProfilerFiller var3);

    protected abstract void resolve(ResourceLocation var1, T var2);

    protected boolean filterEntry(ResourceLocation identifier) {
        return true;
    }

    @Override
    public final void apply(Map<ResourceLocation, JsonElement> resource, ResourceManager manager, ProfilerFiller profiler) {
        this.preApply(resource, manager, profiler);
        for (Map.Entry<ResourceLocation, JsonElement> entry : resource.entrySet()) {
            ResourceLocation identifier = entry.getKey();
            if (!this.filterEntry(identifier)) continue;
            JsonElement element = entry.getValue();
            try {
                DataResult dataResult = this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
                T data = this.readData(identifier, dataResult);
                this.resolve(identifier, data);
            }
            catch (Exception e) {
                this.handleParsingError(e, identifier);
            }
        }
        this.onReloadComplete(manager, profiler);
    }

    protected void onReloadComplete(ResourceManager manager, ProfilerFiller profiler) {
    }

    protected void handleParsingError(Exception e, ResourceLocation currentPath) {
        LOGGER.error((Message)new FormattedMessage("Failed to parse {} element due to error", (Object)currentPath), (Throwable)e);
    }

    protected T readData(ResourceLocation path, DataResult<T> dataResult) {
        return (T)dataResult.getOrThrow(false, arg_0 -> ((Logger)CollectorsAlbum.LOGGER).error(arg_0));
    }
}

