/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.platform.network;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import team.tnt.collectorsalbum.platform.Identifiable;
import team.tnt.collectorsalbum.platform.JavaServiceLoader;
import team.tnt.collectorsalbum.platform.Side;
import team.tnt.collectorsalbum.platform.network.Network;
import team.tnt.collectorsalbum.platform.network.NetworkMessage;
import team.tnt.collectorsalbum.platform.network.PacketDirection;
import team.tnt.collectorsalbum.platform.network.PacketHolder;

public final class PlatformNetworkManager
implements Identifiable {
    public static final Network NETWORK = JavaServiceLoader.loadService(Network.class);
    private final ResourceLocation identifier;
    private Registry registry = new Registry();

    private PlatformNetworkManager(ResourceLocation identifier) {
        this.identifier = identifier;
    }

    @Override
    public ResourceLocation identifier() {
        return this.identifier;
    }

    public static PlatformNetworkManager create(ResourceLocation identifier) {
        return new PlatformNetworkManager(identifier);
    }

    public static PlatformNetworkManager create(String namespace) {
        return PlatformNetworkManager.create(new ResourceLocation(namespace, "network"));
    }

    public <T extends NetworkMessage> void registerPacket(PacketDirection direction, ResourceLocation pid, Class<T> packet, Function<FriendlyByteBuf, T> decoder) {
        this.registry.register(direction, new PacketHolder(pid, packet, decoder));
    }

    public void bind(Side side) {
        ArrayList c2s = new ArrayList();
        ArrayList s2c = new ArrayList();
        this.bindRef(c2s::addAll, s2c::addAll);
        NETWORK.initialize(this.identifier, side, c2s, s2c);
    }

    public void bindRef(Consumer<List<PacketHolder<?, ?>>> c2sPackets, Consumer<List<PacketHolder<?, ?>>> s2cPackets) {
        List<PacketHolder<?, ?>> c2s = this.registry.sidePackets.get((Object)PacketDirection.CLIENT_TO_SERVER);
        List<PacketHolder<?, ?>> s2c = this.registry.sidePackets.get((Object)PacketDirection.SERVER_TO_CLIENT);
        if (!c2s.isEmpty()) {
            c2sPackets.accept(c2s);
        }
        if (!s2c.isEmpty()) {
            s2cPackets.accept(s2c);
        }
    }

    public void close() {
        this.registry = null;
    }

    private static final class Registry {
        private final EnumMap<PacketDirection, List<PacketHolder<?, ?>>> sidePackets = new EnumMap(PacketDirection.class);

        private Registry() {
            this.sidePackets.put(PacketDirection.CLIENT_TO_SERVER, new ArrayList());
            this.sidePackets.put(PacketDirection.SERVER_TO_CLIENT, new ArrayList());
        }

        void register(PacketDirection direction, PacketHolder<?, ?> packet) {
            this.sidePackets.get((Object)direction).add(packet);
        }
    }
}

